/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.security;

import io.micrometer.core.instrument.Metrics;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.oauth2.client.authentication.OAuth2LoginAuthenticationToken;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;
import org.springframework.security.web.authentication.WebAuthenticationDetails;
import org.springframework.stereotype.Component;
import org.tailormap.api.security.events.DefaultAuthenticationFailureEvent;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class AuthenticationEventsLogger {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private static String getIPAddressInfo(AbstractAuthenticationEvent event) {
        Object object;
        String extraInfo = "";
        if (logger.isTraceEnabled() && (object = event.getAuthentication().getDetails()) instanceof WebAuthenticationDetails) {
            WebAuthenticationDetails details = (WebAuthenticationDetails)object;
            extraInfo = " (IP: %s)".formatted(details.getRemoteAddress());
        }
        return extraInfo;
    }

    @EventListener
    public void onSuccess(AuthenticationSuccessEvent success) {
        String authInfo = "";
        String clientId = "";
        String clientName = "";
        Object object = success.getSource();
        if (object instanceof OAuth2LoginAuthenticationToken) {
            OAuth2User oAuth2User;
            OAuth2LoginAuthenticationToken token = (OAuth2LoginAuthenticationToken)object;
            Object userClaims = "";
            if (logger.isTraceEnabled() && (oAuth2User = token.getPrincipal()) instanceof DefaultOidcUser) {
                DefaultOidcUser oidcUser = (DefaultOidcUser)oAuth2User;
                userClaims = ", user claims: " + String.valueOf(oidcUser.getUserInfo().getClaims());
            }
            clientId = token.getClientRegistration().getClientId();
            clientName = token.getClientRegistration().getClientName();
            authInfo = "via OIDC registration \"%s\" with client ID %s%s".formatted(clientName, clientId, userClaims);
        }
        if (success.getSource() instanceof UsernamePasswordAuthenticationToken) {
            authInfo = "using username/password";
        }
        logger.info("Authentication successful for user \"{}\"{}, granted authorities: {}, {}", new Object[]{logger.isTraceEnabled() ? success.getAuthentication().getName() : "<username hidden>", AuthenticationEventsLogger.getIPAddressInfo((AbstractAuthenticationEvent)success), success.getAuthentication().getAuthorities().toString(), authInfo});
        Metrics.counter((String)"tailormap_authentication_success", (String[])new String[]{"type", success.getSource() instanceof OAuth2LoginAuthenticationToken ? "oauth2" : "username_password", "clientId", clientId, "clientName", clientName}).increment();
    }

    @EventListener
    public void onFailure(AbstractAuthenticationFailureEvent failure) {
        String userInfo = "";
        if (failure.getAuthentication().getPrincipal() != null) {
            userInfo = String.format(" for user \"%s\"", failure.getAuthentication().getPrincipal());
        }
        logger.info("Authentication failure: {} {}{}", new Object[]{failure.getException().getMessage(), userInfo, AuthenticationEventsLogger.getIPAddressInfo((AbstractAuthenticationEvent)failure)});
        Metrics.counter((String)"tailormap_authentication_failure", (String[])new String[]{"type", failure.getSource() instanceof OAuth2LoginAuthenticationToken ? "oauth2" : "username_password"}).increment();
    }

    @EventListener
    public void onDefaultAuthenticationFailureEvent(DefaultAuthenticationFailureEvent event) {
        logger.info("Default authentication failure", (Throwable)event.getException());
    }
}

