/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.security;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.tailormap.api.persistence.Group;
import org.tailormap.api.persistence.User;
import org.tailormap.api.persistence.json.AdminAdditionalProperty;

public class TailormapUserDetails
implements UserDetails {
    private final User user;

    public TailormapUserDetails(User user) {
        this.user = user;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        HashSet authorities = new HashSet();
        this.user.getGroups().stream().map(Group::getName).map(SimpleGrantedAuthority::new).forEach(authorities::add);
        this.user.getGroups().stream().map(Group::getAliasForGroup).filter(StringUtils::isNotBlank).map(SimpleGrantedAuthority::new).forEach(authorities::add);
        return authorities;
    }

    public String getPassword() {
        return this.user.getPassword();
    }

    public String getUsername() {
        return this.user.getUsername();
    }

    public boolean isAccountNonExpired() {
        return this.user.getValidUntil() == null || this.user.getValidUntil().isAfter(ZonedDateTime.now(ZoneId.systemDefault()));
    }

    public boolean isEnabled() {
        return this.user.isEnabled();
    }

    public List<AdminAdditionalProperty> getAdditionalProperties() {
        return this.user.getAdditionalProperties();
    }
}

