/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

@Schema(name="ErrorResponse", description=" General server error response. Can be returned when something goes terribly wrong in the backend. **Note** that the diagnostic message may be of a general character to prevent disclosure of information about the backend. Error codes are defined in the [HTTP status code](https://en.wikipedia.org/wiki/List_of_HTTP_status_codes) standard, and can range from 400 to 599. ")
public class ErrorResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer code = 500;
    private String message = "Internal server error";

    public ErrorResponse code(Integer code) {
        this.code = code;
        return this;
    }

    @Schema(name="code", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="code")
    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public ErrorResponse message(String message) {
        this.message = message;
        return this;
    }

    @Schema(name="message", description="diagnostic message", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorResponse errorResponse = (ErrorResponse)o;
        return Objects.equals(this.code, errorResponse.code) && Objects.equals(this.message, errorResponse.message);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ErrorResponse {\n");
        sb.append("    code: ").append(this.toIndentedString((Object)this.code)).append("\n");
        sb.append("    message: ").append(this.toIndentedString((Object)this.message)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

