package org.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.tailormap.api.persistence.json.AuthorizationRuleDecision;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * A single authorization rule.
 */
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)

@Schema(name = "AuthorizationRule", description = "A single authorization rule.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.14.0")
public class AuthorizationRule implements Serializable {

  private static final long serialVersionUID = 1L;

  private String groupName;

  @Valid
  private Map<String, AuthorizationRuleDecision> decisions = new HashMap<>();

  public AuthorizationRule() {
    super();
  }

  public AuthorizationRule groupName(String groupName) {
    this.groupName = groupName;
    return this;
  }

  /**
   * Name of the group.
   * @return groupName
   */
  @NotNull 
  @Schema(name = "groupName", description = "Name of the group.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("groupName")
  public String getGroupName() {
    return groupName;
  }

  public void setGroupName(String groupName) {
    this.groupName = groupName;
  }

  public AuthorizationRule decisions(Map<String, AuthorizationRuleDecision> decisions) {
    this.decisions = decisions;
    return this;
  }

  public AuthorizationRule putDecisionsItem(String key, AuthorizationRuleDecision decisionsItem) {
    if (this.decisions == null) {
      this.decisions = new HashMap<>();
    }
    this.decisions.put(key, decisionsItem);
    return this;
  }

  /**
   * A map of access type to decision.
   * @return decisions
   */
  @NotNull @Valid 
  @Schema(name = "decisions", description = "A map of access type to decision.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("decisions")
  public Map<String, AuthorizationRuleDecision> getDecisions() {
    return decisions;
  }

  public void setDecisions(Map<String, AuthorizationRuleDecision> decisions) {
    this.decisions = decisions;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AuthorizationRule authorizationRule = (AuthorizationRule) o;
    return Objects.equals(this.groupName, authorizationRule.groupName) &&
        Objects.equals(this.decisions, authorizationRule.decisions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(groupName, decisions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuthorizationRule {\n");
    sb.append("    groupName: ").append(toIndentedString(groupName)).append("\n");
    sb.append("    decisions: ").append(toIndentedString(decisions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

