package org.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.lang.Nullable;
import org.tailormap.api.persistence.json.TailormapObjectRef;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Categorization for items in the catalog.
 */
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)

@Schema(name = "CatalogNode", description = "Categorization for items in the catalog.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.14.0")
public class CatalogNode implements Serializable {

  private static final long serialVersionUID = 1L;

  private String id;

  private String title;

  private Boolean root;

  @Valid
  private List<String> children = new ArrayList<>();

  @Valid
  private List<@Valid TailormapObjectRef> items = new ArrayList<>();

  public CatalogNode id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  
  @Schema(name = "id", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("id")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public CatalogNode title(String title) {
    this.title = title;
    return this;
  }

  /**
   * Get title
   * @return title
   */
  
  @Schema(name = "title", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public CatalogNode root(Boolean root) {
    this.root = root;
    return this;
  }

  /**
   * Get root
   * @return root
   */
  
  @Schema(name = "root", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("root")
  public Boolean getRoot() {
    return root;
  }

  public void setRoot(Boolean root) {
    this.root = root;
  }

  public CatalogNode children(List<String> children) {
    this.children = children;
    return this;
  }

  public CatalogNode addChildrenItem(String childrenItem) {
    if (this.children == null) {
      this.children = new ArrayList<>();
    }
    this.children.add(childrenItem);
    return this;
  }

  /**
   * Get children
   * @return children
   */
  
  @Schema(name = "children", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("children")
  public List<String> getChildren() {
    return children;
  }

  public void setChildren(List<String> children) {
    this.children = children;
  }

  public CatalogNode items(List<@Valid TailormapObjectRef> items) {
    this.items = items;
    return this;
  }

  public CatalogNode addItemsItem(TailormapObjectRef itemsItem) {
    if (this.items == null) {
      this.items = new ArrayList<>();
    }
    this.items.add(itemsItem);
    return this;
  }

  /**
   * Get items
   * @return items
   */
  @Valid 
  @Schema(name = "items", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("items")
  public List<@Valid TailormapObjectRef> getItems() {
    return items;
  }

  public void setItems(List<@Valid TailormapObjectRef> items) {
    this.items = items;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CatalogNode catalogNode = (CatalogNode) o;
    return Objects.equals(this.id, catalogNode.id) &&
        Objects.equals(this.title, catalogNode.title) &&
        Objects.equals(this.root, catalogNode.root) &&
        Objects.equals(this.children, catalogNode.children) &&
        Objects.equals(this.items, catalogNode.items);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, title, root, children, items);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CatalogNode {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    root: ").append(toIndentedString(root)).append("\n");
    sb.append("    children: ").append(toIndentedString(children)).append("\n");
    sb.append("    items: ").append(toIndentedString(items)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

