package org.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.tailormap.api.persistence.json.AttributeSettings;
import org.tailormap.api.persistence.json.FeatureTypeTemplate;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * FeatureTypeSettings
 */
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.14.0")
public class FeatureTypeSettings implements Serializable {

  private static final long serialVersionUID = 1L;

  private FeatureTypeTemplate template;

  @Valid
  private List<String> attributeOrder = new ArrayList<>();

  @Valid
  private List<String> hideAttributes = new ArrayList<>();

  @Valid
  private List<String> readOnlyAttributes = new ArrayList<>();

  @Valid
  private Map<String, AttributeSettings> attributeSettings = new HashMap<>();

  public FeatureTypeSettings() {
    super();
  }

  public FeatureTypeSettings template(FeatureTypeTemplate template) {
    this.template = template;
    return this;
  }

  /**
   * Get template
   * @return template
   */
  @Valid 
  @Schema(name = "template", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("template")
  public FeatureTypeTemplate getTemplate() {
    return template;
  }

  public void setTemplate(FeatureTypeTemplate template) {
    this.template = template;
  }

  public FeatureTypeSettings attributeOrder(List<String> attributeOrder) {
    this.attributeOrder = attributeOrder;
    return this;
  }

  public FeatureTypeSettings addAttributeOrderItem(String attributeOrderItem) {
    if (this.attributeOrder == null) {
      this.attributeOrder = new ArrayList<>();
    }
    this.attributeOrder.add(attributeOrderItem);
    return this;
  }

  /**
   * Reordering of the attributes by attribute names. Attributes in the feature type that are not in this array should still be shown; either after the attribute that precedes the attribute in the original feature type attribute ordering or at the end.
   * @return attributeOrder
   */
  @NotNull 
  @Schema(name = "attributeOrder", description = "Reordering of the attributes by attribute names. Attributes in the feature type that are not in this array should still be shown; either after the attribute that precedes the attribute in the original feature type attribute ordering or at the end.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("attributeOrder")
  public List<String> getAttributeOrder() {
    return attributeOrder;
  }

  public void setAttributeOrder(List<String> attributeOrder) {
    this.attributeOrder = attributeOrder;
  }

  public FeatureTypeSettings hideAttributes(List<String> hideAttributes) {
    this.hideAttributes = hideAttributes;
    return this;
  }

  public FeatureTypeSettings addHideAttributesItem(String hideAttributesItem) {
    if (this.hideAttributes == null) {
      this.hideAttributes = new ArrayList<>();
    }
    this.hideAttributes.add(hideAttributesItem);
    return this;
  }

  /**
   * List of attribute names that should be hidden in all viewers.
   * @return hideAttributes
   */
  @NotNull 
  @Schema(name = "hideAttributes", description = "List of attribute names that should be hidden in all viewers.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("hideAttributes")
  public List<String> getHideAttributes() {
    return hideAttributes;
  }

  public void setHideAttributes(List<String> hideAttributes) {
    this.hideAttributes = hideAttributes;
  }

  public FeatureTypeSettings readOnlyAttributes(List<String> readOnlyAttributes) {
    this.readOnlyAttributes = readOnlyAttributes;
    return this;
  }

  public FeatureTypeSettings addReadOnlyAttributesItem(String readOnlyAttributesItem) {
    if (this.readOnlyAttributes == null) {
      this.readOnlyAttributes = new ArrayList<>();
    }
    this.readOnlyAttributes.add(readOnlyAttributesItem);
    return this;
  }

  /**
   * List of attribute names that are not editable.
   * @return readOnlyAttributes
   */
  @NotNull 
  @Schema(name = "readOnlyAttributes", description = "List of attribute names that are not editable.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("readOnlyAttributes")
  public List<String> getReadOnlyAttributes() {
    return readOnlyAttributes;
  }

  public void setReadOnlyAttributes(List<String> readOnlyAttributes) {
    this.readOnlyAttributes = readOnlyAttributes;
  }

  public FeatureTypeSettings attributeSettings(Map<String, AttributeSettings> attributeSettings) {
    this.attributeSettings = attributeSettings;
    return this;
  }

  public FeatureTypeSettings putAttributeSettingsItem(String key, AttributeSettings attributeSettingsItem) {
    if (this.attributeSettings == null) {
      this.attributeSettings = new HashMap<>();
    }
    this.attributeSettings.put(key, attributeSettingsItem);
    return this;
  }

  /**
   * Map of attribute name to its' settings.
   * @return attributeSettings
   */
  @NotNull @Valid 
  @Schema(name = "attributeSettings", description = "Map of attribute name to its' settings.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("attributeSettings")
  public Map<String, AttributeSettings> getAttributeSettings() {
    return attributeSettings;
  }

  public void setAttributeSettings(Map<String, AttributeSettings> attributeSettings) {
    this.attributeSettings = attributeSettings;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FeatureTypeSettings featureTypeSettings = (FeatureTypeSettings) o;
    return Objects.equals(this.template, featureTypeSettings.template) &&
        Objects.equals(this.attributeOrder, featureTypeSettings.attributeOrder) &&
        Objects.equals(this.hideAttributes, featureTypeSettings.hideAttributes) &&
        Objects.equals(this.readOnlyAttributes, featureTypeSettings.readOnlyAttributes) &&
        Objects.equals(this.attributeSettings, featureTypeSettings.attributeSettings);
  }

  @Override
  public int hashCode() {
    return Objects.hash(template, attributeOrder, hideAttributes, readOnlyAttributes, attributeSettings);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FeatureTypeSettings {\n");
    sb.append("    template: ").append(toIndentedString(template)).append("\n");
    sb.append("    attributeOrder: ").append(toIndentedString(attributeOrder)).append("\n");
    sb.append("    hideAttributes: ").append(toIndentedString(hideAttributes)).append("\n");
    sb.append("    readOnlyAttributes: ").append(toIndentedString(readOnlyAttributes)).append("\n");
    sb.append("    attributeSettings: ").append(toIndentedString(attributeSettings)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

