package org.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import org.springframework.lang.Nullable;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Template/description for a feature. Will replace placeholders by attribute values in the viewer
 */
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)

@Schema(name = "FeatureTypeTemplate", description = "Template/description for a feature. Will replace placeholders by attribute values in the viewer")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.14.0")
public class FeatureTypeTemplate implements Serializable {

  private static final long serialVersionUID = 1L;

  private String template;

  private String markupLanguage;

  private String templateLanguage;

  public FeatureTypeTemplate template(String template) {
    this.template = template;
    return this;
  }

  /**
   * Get template
   * @return template
   */
  
  @Schema(name = "template", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("template")
  public String getTemplate() {
    return template;
  }

  public void setTemplate(String template) {
    this.template = template;
  }

  public FeatureTypeTemplate markupLanguage(String markupLanguage) {
    this.markupLanguage = markupLanguage;
    return this;
  }

  /**
   * Get markupLanguage
   * @return markupLanguage
   */
  
  @Schema(name = "markupLanguage", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("markupLanguage")
  public String getMarkupLanguage() {
    return markupLanguage;
  }

  public void setMarkupLanguage(String markupLanguage) {
    this.markupLanguage = markupLanguage;
  }

  public FeatureTypeTemplate templateLanguage(String templateLanguage) {
    this.templateLanguage = templateLanguage;
    return this;
  }

  /**
   * Get templateLanguage
   * @return templateLanguage
   */
  
  @Schema(name = "templateLanguage", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("templateLanguage")
  public String getTemplateLanguage() {
    return templateLanguage;
  }

  public void setTemplateLanguage(String templateLanguage) {
    this.templateLanguage = templateLanguage;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FeatureTypeTemplate featureTypeTemplate = (FeatureTypeTemplate) o;
    return Objects.equals(this.template, featureTypeTemplate.template) &&
        Objects.equals(this.markupLanguage, featureTypeTemplate.markupLanguage) &&
        Objects.equals(this.templateLanguage, featureTypeTemplate.templateLanguage);
  }

  @Override
  public int hashCode() {
    return Objects.hash(template, markupLanguage, templateLanguage);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FeatureTypeTemplate {\n");
    sb.append("    template: ").append(toIndentedString(template)).append("\n");
    sb.append("    markupLanguage: ").append(toIndentedString(markupLanguage)).append("\n");
    sb.append("    templateLanguage: ").append(toIndentedString(templateLanguage)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

