package org.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.lang.Nullable;
import org.tailormap.api.persistence.json.FormFieldValue;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * model for a single form field
 */
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)

@Schema(name = "FormField", description = "model for a single form field")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.14.0")
public class FormField implements Serializable {

  private static final long serialVersionUID = 1L;

  private String name;

  private String label;

  /**
   * Gets or Sets type
   */
  public enum TypeEnum {
    TEXT("text"),
    
    NUMBER("number"),
    
    INTEGER("integer"),
    
    BOOLEAN("boolean"),
    
    SELECT("select"),
    
    TEXTAREA("textarea"),
    
    DATE("date"),
    
    TIMESTAMP("timestamp");

    private final String value;

    TypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  private TypeEnum type;

  private String tab = null;

  private BigDecimal column = null;

  private Boolean uniqueValuesAsOptions = null;

  @Valid
  private List<@Valid FormFieldValue> valueList;

  private Boolean allowValueListOnly = null;

  private Boolean disabled = null;

  private Boolean required = null;

  private Boolean autoFillUser = null;

  private Boolean autoFillDate = null;

  private String placeholder = null;

  private String hint = null;

  public FormField name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   * @return name
   */
  
  @Schema(name = "name", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public FormField label(String label) {
    this.label = label;
    return this;
  }

  /**
   * Get label
   * @return label
   */
  
  @Schema(name = "label", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("label")
  public String getLabel() {
    return label;
  }

  public void setLabel(String label) {
    this.label = label;
  }

  public FormField type(TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
   */
  
  @Schema(name = "type", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("type")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public FormField tab(String tab) {
    this.tab = tab;
    return this;
  }

  /**
   * Get tab
   * @return tab
   */
  
  @Schema(name = "tab", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tab")
  public String getTab() {
    return tab;
  }

  public void setTab(String tab) {
    this.tab = tab;
  }

  public FormField column(BigDecimal column) {
    this.column = column;
    return this;
  }

  /**
   * Get column
   * @return column
   */
  @Valid 
  @Schema(name = "column", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("column")
  public BigDecimal getColumn() {
    return column;
  }

  public void setColumn(BigDecimal column) {
    this.column = column;
  }

  public FormField uniqueValuesAsOptions(Boolean uniqueValuesAsOptions) {
    this.uniqueValuesAsOptions = uniqueValuesAsOptions;
    return this;
  }

  /**
   * when true the unique values for the column are used when editing this field
   * @return uniqueValuesAsOptions
   */
  
  @Schema(name = "uniqueValuesAsOptions", description = "when true the unique values for the column are used when editing this field", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("uniqueValuesAsOptions")
  public Boolean getUniqueValuesAsOptions() {
    return uniqueValuesAsOptions;
  }

  public void setUniqueValuesAsOptions(Boolean uniqueValuesAsOptions) {
    this.uniqueValuesAsOptions = uniqueValuesAsOptions;
  }

  public FormField valueList(List<@Valid FormFieldValue> valueList) {
    this.valueList = valueList;
    return this;
  }

  public FormField addValueListItem(FormFieldValue valueListItem) {
    if (this.valueList == null) {
      this.valueList = new ArrayList<>();
    }
    this.valueList.add(valueListItem);
    return this;
  }

  /**
   * Get valueList
   * @return valueList
   */
  @Valid 
  @Schema(name = "valueList", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("valueList")
  public List<@Valid FormFieldValue> getValueList() {
    return valueList;
  }

  public void setValueList(List<@Valid FormFieldValue> valueList) {
    this.valueList = valueList;
  }

  public FormField allowValueListOnly(Boolean allowValueListOnly) {
    this.allowValueListOnly = allowValueListOnly;
    return this;
  }

  /**
   * Get allowValueListOnly
   * @return allowValueListOnly
   */
  
  @Schema(name = "allowValueListOnly", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("allowValueListOnly")
  public Boolean getAllowValueListOnly() {
    return allowValueListOnly;
  }

  public void setAllowValueListOnly(Boolean allowValueListOnly) {
    this.allowValueListOnly = allowValueListOnly;
  }

  public FormField disabled(Boolean disabled) {
    this.disabled = disabled;
    return this;
  }

  /**
   * Get disabled
   * @return disabled
   */
  
  @Schema(name = "disabled", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("disabled")
  public Boolean getDisabled() {
    return disabled;
  }

  public void setDisabled(Boolean disabled) {
    this.disabled = disabled;
  }

  public FormField required(Boolean required) {
    this.required = required;
    return this;
  }

  /**
   * Get required
   * @return required
   */
  
  @Schema(name = "required", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("required")
  public Boolean getRequired() {
    return required;
  }

  public void setRequired(Boolean required) {
    this.required = required;
  }

  public FormField autoFillUser(Boolean autoFillUser) {
    this.autoFillUser = autoFillUser;
    return this;
  }

  /**
   * Get autoFillUser
   * @return autoFillUser
   */
  
  @Schema(name = "autoFillUser", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("autoFillUser")
  public Boolean getAutoFillUser() {
    return autoFillUser;
  }

  public void setAutoFillUser(Boolean autoFillUser) {
    this.autoFillUser = autoFillUser;
  }

  public FormField autoFillDate(Boolean autoFillDate) {
    this.autoFillDate = autoFillDate;
    return this;
  }

  /**
   * Get autoFillDate
   * @return autoFillDate
   */
  
  @Schema(name = "autoFillDate", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("autoFillDate")
  public Boolean getAutoFillDate() {
    return autoFillDate;
  }

  public void setAutoFillDate(Boolean autoFillDate) {
    this.autoFillDate = autoFillDate;
  }

  public FormField placeholder(String placeholder) {
    this.placeholder = placeholder;
    return this;
  }

  /**
   * Get placeholder
   * @return placeholder
   */
  
  @Schema(name = "placeholder", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("placeholder")
  public String getPlaceholder() {
    return placeholder;
  }

  public void setPlaceholder(String placeholder) {
    this.placeholder = placeholder;
  }

  public FormField hint(String hint) {
    this.hint = hint;
    return this;
  }

  /**
   * Get hint
   * @return hint
   */
  
  @Schema(name = "hint", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("hint")
  public String getHint() {
    return hint;
  }

  public void setHint(String hint) {
    this.hint = hint;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FormField formField = (FormField) o;
    return Objects.equals(this.name, formField.name) &&
        Objects.equals(this.label, formField.label) &&
        Objects.equals(this.type, formField.type) &&
        Objects.equals(this.tab, formField.tab) &&
        Objects.equals(this.column, formField.column) &&
        Objects.equals(this.uniqueValuesAsOptions, formField.uniqueValuesAsOptions) &&
        Objects.equals(this.valueList, formField.valueList) &&
        Objects.equals(this.allowValueListOnly, formField.allowValueListOnly) &&
        Objects.equals(this.disabled, formField.disabled) &&
        Objects.equals(this.required, formField.required) &&
        Objects.equals(this.autoFillUser, formField.autoFillUser) &&
        Objects.equals(this.autoFillDate, formField.autoFillDate) &&
        Objects.equals(this.placeholder, formField.placeholder) &&
        Objects.equals(this.hint, formField.hint);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, label, type, tab, column, uniqueValuesAsOptions, valueList, allowValueListOnly, disabled, required, autoFillUser, autoFillDate, placeholder, hint);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FormField {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    label: ").append(toIndentedString(label)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    tab: ").append(toIndentedString(tab)).append("\n");
    sb.append("    column: ").append(toIndentedString(column)).append("\n");
    sb.append("    uniqueValuesAsOptions: ").append(toIndentedString(uniqueValuesAsOptions)).append("\n");
    sb.append("    valueList: ").append(toIndentedString(valueList)).append("\n");
    sb.append("    allowValueListOnly: ").append(toIndentedString(allowValueListOnly)).append("\n");
    sb.append("    disabled: ").append(toIndentedString(disabled)).append("\n");
    sb.append("    required: ").append(toIndentedString(required)).append("\n");
    sb.append("    autoFillUser: ").append(toIndentedString(autoFillUser)).append("\n");
    sb.append("    autoFillDate: ").append(toIndentedString(autoFillDate)).append("\n");
    sb.append("    placeholder: ").append(toIndentedString(placeholder)).append("\n");
    sb.append("    hint: ").append(toIndentedString(hint)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

