package org.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * JDBCConnectionProperties
 */
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.14.0")
public class JDBCConnectionProperties implements Serializable {

  private static final long serialVersionUID = 1L;

  /**
   * Gets or Sets dbtype
   */
  public enum DbtypeEnum {
    POSTGIS("postgis"),
    
    ORACLE("oracle"),
    
    SQLSERVER("sqlserver");

    private final String value;

    DbtypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DbtypeEnum fromValue(String value) {
      for (DbtypeEnum b : DbtypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  private DbtypeEnum dbtype;

  private String database;

  private Integer port;

  private String host;

  private String schema;

  private Integer fetchSize;

  private String primaryKeyMetadataTable;

  private String geometryMetadataTable;

  @Valid
  private Map<String, String> additionalProperties = new HashMap<>();

  public JDBCConnectionProperties dbtype(DbtypeEnum dbtype) {
    this.dbtype = dbtype;
    return this;
  }

  /**
   * Get dbtype
   * @return dbtype
   */
  
  @Schema(name = "dbtype", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("dbtype")
  public DbtypeEnum getDbtype() {
    return dbtype;
  }

  public void setDbtype(DbtypeEnum dbtype) {
    this.dbtype = dbtype;
  }

  public JDBCConnectionProperties database(String database) {
    this.database = database;
    return this;
  }

  /**
   * Get database
   * @return database
   */
  
  @Schema(name = "database", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("database")
  public String getDatabase() {
    return database;
  }

  public void setDatabase(String database) {
    this.database = database;
  }

  public JDBCConnectionProperties port(Integer port) {
    this.port = port;
    return this;
  }

  /**
   * Get port
   * @return port
   */
  
  @Schema(name = "port", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("port")
  public Integer getPort() {
    return port;
  }

  public void setPort(Integer port) {
    this.port = port;
  }

  public JDBCConnectionProperties host(String host) {
    this.host = host;
    return this;
  }

  /**
   * Get host
   * @return host
   */
  
  @Schema(name = "host", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("host")
  public String getHost() {
    return host;
  }

  public void setHost(String host) {
    this.host = host;
  }

  public JDBCConnectionProperties schema(String schema) {
    this.schema = schema;
    return this;
  }

  /**
   * Get schema
   * @return schema
   */
  
  @Schema(name = "schema", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("schema")
  public String getSchema() {
    return schema;
  }

  public void setSchema(String schema) {
    this.schema = schema;
  }

  public JDBCConnectionProperties fetchSize(Integer fetchSize) {
    this.fetchSize = fetchSize;
    return this;
  }

  /**
   * Get fetchSize
   * @return fetchSize
   */
  
  @Schema(name = "fetchSize", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("fetchSize")
  public Integer getFetchSize() {
    return fetchSize;
  }

  public void setFetchSize(Integer fetchSize) {
    this.fetchSize = fetchSize;
  }

  public JDBCConnectionProperties primaryKeyMetadataTable(String primaryKeyMetadataTable) {
    this.primaryKeyMetadataTable = primaryKeyMetadataTable;
    return this;
  }

  /**
   * Get primaryKeyMetadataTable
   * @return primaryKeyMetadataTable
   */
  
  @Schema(name = "primaryKeyMetadataTable", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("primaryKeyMetadataTable")
  public String getPrimaryKeyMetadataTable() {
    return primaryKeyMetadataTable;
  }

  public void setPrimaryKeyMetadataTable(String primaryKeyMetadataTable) {
    this.primaryKeyMetadataTable = primaryKeyMetadataTable;
  }

  public JDBCConnectionProperties geometryMetadataTable(String geometryMetadataTable) {
    this.geometryMetadataTable = geometryMetadataTable;
    return this;
  }

  /**
   * Get geometryMetadataTable
   * @return geometryMetadataTable
   */
  
  @Schema(name = "geometryMetadataTable", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("geometryMetadataTable")
  public String getGeometryMetadataTable() {
    return geometryMetadataTable;
  }

  public void setGeometryMetadataTable(String geometryMetadataTable) {
    this.geometryMetadataTable = geometryMetadataTable;
  }

  public JDBCConnectionProperties additionalProperties(Map<String, String> additionalProperties) {
    this.additionalProperties = additionalProperties;
    return this;
  }

  public JDBCConnectionProperties putAdditionalPropertiesItem(String key, String additionalPropertiesItem) {
    if (this.additionalProperties == null) {
      this.additionalProperties = new HashMap<>();
    }
    this.additionalProperties.put(key, additionalPropertiesItem);
    return this;
  }

  /**
   * Get additionalProperties
   * @return additionalProperties
   */
  
  @Schema(name = "additionalProperties", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("additionalProperties")
  public Map<String, String> getAdditionalProperties() {
    return additionalProperties;
  }

  public void setAdditionalProperties(Map<String, String> additionalProperties) {
    this.additionalProperties = additionalProperties;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JDBCConnectionProperties jdBCConnectionProperties = (JDBCConnectionProperties) o;
    return Objects.equals(this.dbtype, jdBCConnectionProperties.dbtype) &&
        Objects.equals(this.database, jdBCConnectionProperties.database) &&
        Objects.equals(this.port, jdBCConnectionProperties.port) &&
        Objects.equals(this.host, jdBCConnectionProperties.host) &&
        Objects.equals(this.schema, jdBCConnectionProperties.schema) &&
        Objects.equals(this.fetchSize, jdBCConnectionProperties.fetchSize) &&
        Objects.equals(this.primaryKeyMetadataTable, jdBCConnectionProperties.primaryKeyMetadataTable) &&
        Objects.equals(this.geometryMetadataTable, jdBCConnectionProperties.geometryMetadataTable) &&
        Objects.equals(this.additionalProperties, jdBCConnectionProperties.additionalProperties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dbtype, database, port, host, schema, fetchSize, primaryKeyMetadataTable, geometryMetadataTable, additionalProperties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JDBCConnectionProperties {\n");
    sb.append("    dbtype: ").append(toIndentedString(dbtype)).append("\n");
    sb.append("    database: ").append(toIndentedString(database)).append("\n");
    sb.append("    port: ").append(toIndentedString(port)).append("\n");
    sb.append("    host: ").append(toIndentedString(host)).append("\n");
    sb.append("    schema: ").append(toIndentedString(schema)).append("\n");
    sb.append("    fetchSize: ").append(toIndentedString(fetchSize)).append("\n");
    sb.append("    primaryKeyMetadataTable: ").append(toIndentedString(primaryKeyMetadataTable)).append("\n");
    sb.append("    geometryMetadataTable: ").append(toIndentedString(geometryMetadataTable)).append("\n");
    sb.append("    additionalProperties: ").append(toIndentedString(additionalProperties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

