package org.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import org.springframework.lang.Nullable;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * model for a page tile
 */
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)

@Schema(name = "PageTile", description = "model for a page tile")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.14.0")
public class PageTile implements Serializable {

  private static final long serialVersionUID = 1L;

  private String id;

  private String title;

  private String content;

  private String image = null;

  private Long applicationId = null;

  private Long pageId = null;

  private String url = null;

  private String className = null;

  private Boolean filterRequireAuthorization = null;

  private Boolean openInNewWindow = null;

  public PageTile id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  
  @Schema(name = "id", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("id")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public PageTile title(String title) {
    this.title = title;
    return this;
  }

  /**
   * page tile title
   * @return title
   */
  
  @Schema(name = "title", description = "page tile title", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public PageTile content(String content) {
    this.content = content;
    return this;
  }

  /**
   * page tile contents
   * @return content
   */
  
  @Schema(name = "content", description = "page tile contents", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("content")
  public String getContent() {
    return content;
  }

  public void setContent(String content) {
    this.content = content;
  }

  public PageTile image(String image) {
    this.image = image;
    return this;
  }

  /**
   * image to show on the tile
   * @return image
   */
  
  @Schema(name = "image", description = "image to show on the tile", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("image")
  public String getImage() {
    return image;
  }

  public void setImage(String image) {
    this.image = image;
  }

  public PageTile applicationId(Long applicationId) {
    this.applicationId = applicationId;
    return this;
  }

  /**
   * linked application
   * @return applicationId
   */
  
  @Schema(name = "applicationId", description = "linked application", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("applicationId")
  public Long getApplicationId() {
    return applicationId;
  }

  public void setApplicationId(Long applicationId) {
    this.applicationId = applicationId;
  }

  public PageTile pageId(Long pageId) {
    this.pageId = pageId;
    return this;
  }

  /**
   * linked page
   * @return pageId
   */
  
  @Schema(name = "pageId", description = "linked page", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("pageId")
  public Long getPageId() {
    return pageId;
  }

  public void setPageId(Long pageId) {
    this.pageId = pageId;
  }

  public PageTile url(String url) {
    this.url = url;
    return this;
  }

  /**
   * link to an other domain / website
   * @return url
   */
  
  @Schema(name = "url", description = "link to an other domain / website", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("url")
  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  public PageTile className(String className) {
    this.className = className;
    return this;
  }

  /**
   * optional css classname for styling
   * @return className
   */
  
  @Schema(name = "className", description = "optional css classname for styling", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("className")
  public String getClassName() {
    return className;
  }

  public void setClassName(String className) {
    this.className = className;
  }

  public PageTile filterRequireAuthorization(Boolean filterRequireAuthorization) {
    this.filterRequireAuthorization = filterRequireAuthorization;
    return this;
  }

  /**
   * indicates if this tile should be filtered from the list if an application id is set for which the user does not have access
   * @return filterRequireAuthorization
   */
  
  @Schema(name = "filterRequireAuthorization", description = "indicates if this tile should be filtered from the list if an application id is set for which the user does not have access", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("filterRequireAuthorization")
  public Boolean getFilterRequireAuthorization() {
    return filterRequireAuthorization;
  }

  public void setFilterRequireAuthorization(Boolean filterRequireAuthorization) {
    this.filterRequireAuthorization = filterRequireAuthorization;
  }

  public PageTile openInNewWindow(Boolean openInNewWindow) {
    this.openInNewWindow = openInNewWindow;
    return this;
  }

  /**
   * indicates whether the link should be opened in a new window
   * @return openInNewWindow
   */
  
  @Schema(name = "openInNewWindow", description = "indicates whether the link should be opened in a new window", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("openInNewWindow")
  public Boolean getOpenInNewWindow() {
    return openInNewWindow;
  }

  public void setOpenInNewWindow(Boolean openInNewWindow) {
    this.openInNewWindow = openInNewWindow;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PageTile pageTile = (PageTile) o;
    return Objects.equals(this.id, pageTile.id) &&
        Objects.equals(this.title, pageTile.title) &&
        Objects.equals(this.content, pageTile.content) &&
        Objects.equals(this.image, pageTile.image) &&
        Objects.equals(this.applicationId, pageTile.applicationId) &&
        Objects.equals(this.pageId, pageTile.pageId) &&
        Objects.equals(this.url, pageTile.url) &&
        Objects.equals(this.className, pageTile.className) &&
        Objects.equals(this.filterRequireAuthorization, pageTile.filterRequireAuthorization) &&
        Objects.equals(this.openInNewWindow, pageTile.openInNewWindow);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, title, content, image, applicationId, pageId, url, className, filterRequireAuthorization, openInNewWindow);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PageTile {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("    image: ").append(toIndentedString(image)).append("\n");
    sb.append("    applicationId: ").append(toIndentedString(applicationId)).append("\n");
    sb.append("    pageId: ").append(toIndentedString(pageId)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    className: ").append(toIndentedString(className)).append("\n");
    sb.append("    filterRequireAuthorization: ").append(toIndentedString(filterRequireAuthorization)).append("\n");
    sb.append("    openInNewWindow: ").append(toIndentedString(openInNewWindow)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

