package org.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.lang.Nullable;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * TMServiceInfo
 */
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.14.0")
public class TMServiceInfo implements Serializable {

  private static final long serialVersionUID = 1L;

  private String title;

  @Valid
  private Set<String> keywords = new LinkedHashSet<>();

  private String description;

  private URI publisher;

  private URI schema;

  private URI source;

  public TMServiceInfo title(String title) {
    this.title = title;
    return this;
  }

  /**
   * Get title
   * @return title
   */
  
  @Schema(name = "title", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public TMServiceInfo keywords(Set<String> keywords) {
    this.keywords = keywords;
    return this;
  }

  public TMServiceInfo addKeywordsItem(String keywordsItem) {
    if (this.keywords == null) {
      this.keywords = new LinkedHashSet<>();
    }
    this.keywords.add(keywordsItem);
    return this;
  }

  /**
   * Get keywords
   * @return keywords
   */
  
  @Schema(name = "keywords", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("keywords")
  public Set<String> getKeywords() {
    return keywords;
  }

  @JsonDeserialize(as = LinkedHashSet.class)
  public void setKeywords(Set<String> keywords) {
    this.keywords = keywords;
  }

  public TMServiceInfo description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Get description
   * @return description
   */
  
  @Schema(name = "description", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public TMServiceInfo publisher(URI publisher) {
    this.publisher = publisher;
    return this;
  }

  /**
   * Get publisher
   * @return publisher
   */
  @Valid 
  @Schema(name = "publisher", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("publisher")
  public URI getPublisher() {
    return publisher;
  }

  public void setPublisher(URI publisher) {
    this.publisher = publisher;
  }

  public TMServiceInfo schema(URI schema) {
    this.schema = schema;
    return this;
  }

  /**
   * Get schema
   * @return schema
   */
  @Valid 
  @Schema(name = "schema", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("schema")
  public URI getSchema() {
    return schema;
  }

  public void setSchema(URI schema) {
    this.schema = schema;
  }

  public TMServiceInfo source(URI source) {
    this.source = source;
    return this;
  }

  /**
   * Get source
   * @return source
   */
  @Valid 
  @Schema(name = "source", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("source")
  public URI getSource() {
    return source;
  }

  public void setSource(URI source) {
    this.source = source;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TMServiceInfo tmServiceInfo = (TMServiceInfo) o;
    return Objects.equals(this.title, tmServiceInfo.title) &&
        Objects.equals(this.keywords, tmServiceInfo.keywords) &&
        Objects.equals(this.description, tmServiceInfo.description) &&
        Objects.equals(this.publisher, tmServiceInfo.publisher) &&
        Objects.equals(this.schema, tmServiceInfo.schema) &&
        Objects.equals(this.source, tmServiceInfo.source);
  }

  @Override
  public int hashCode() {
    return Objects.hash(title, keywords, description, publisher, schema, source);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TMServiceInfo {\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    keywords: ").append(toIndentedString(keywords)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    publisher: ").append(toIndentedString(publisher)).append("\n");
    sb.append("    schema: ").append(toIndentedString(schema)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

