package org.tailormap.api.viewer.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.tailormap.api.persistence.json.Bounds;
import org.tailormap.api.persistence.json.HiddenLayerFunctionalityEnum;
import org.tailormap.api.persistence.json.TileLayerHiDpiMode;
import org.tailormap.api.viewer.model.LayerSearchIndex;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 *  A map layer, but only enough information to draw the layer. For advanced functionality that required access to attributes the LayerDetails should be requested. 
 */

@Schema(name = "AppLayer", description = " A map layer, but only enough information to draw the layer. For advanced functionality that required access to attributes the LayerDetails should be requested. ")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.14.0")
public class AppLayer implements Serializable {

  private static final long serialVersionUID = 1L;

  private String id;

  private String serviceId;

  private String layerName;

  private String title;

  private String url;

  private Boolean visible;

  private Integer opacity;

  private Double minScale;

  private Double maxScale;

  private String legendImageUrl;

  /**
   * Whether the legend is a static image or a dynamic WMS legend.
   */
  public enum LegendTypeEnum {
    STATIC("static"),
    
    DYNAMIC("dynamic");

    private final String value;

    LegendTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static LegendTypeEnum fromValue(String value) {
      for (LegendTypeEnum b : LegendTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  private LegendTypeEnum legendType;

  private Boolean tilingDisabled;

  private Integer tilingGutter;

  private Boolean hiDpiDisabled;

  private TileLayerHiDpiMode hiDpiMode;

  private String hiDpiSubstituteLayer;

  private Integer minZoom;

  private Integer maxZoom;

  private Integer tileSize;

  private Bounds tileGridExtent;

  private Boolean hasAttributes;

  private Boolean editable;

  private String attribution;

  private String description;

  private Double autoRefreshInSeconds = null;

  private LayerSearchIndex searchIndex;

  private Boolean webMercatorAvailable;

  @Valid
  private Set<HiddenLayerFunctionalityEnum> hiddenFunctionality = new LinkedHashSet<>();

  public AppLayer() {
    super();
  }

  public AppLayer id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Unique id of this layer reference in the application. Another app layer may exist which references the same layerName of the same service, but with different settings.
   * @return id
   */
  @NotNull 
  @Schema(name = "id", description = "Unique id of this layer reference in the application. Another app layer may exist which references the same layerName of the same service, but with different settings.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("id")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public AppLayer serviceId(String serviceId) {
    this.serviceId = serviceId;
    return this;
  }

  /**
   * Get serviceId
   * @return serviceId
   */
  @NotNull 
  @Schema(name = "serviceId", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("serviceId")
  public String getServiceId() {
    return serviceId;
  }

  public void setServiceId(String serviceId) {
    this.serviceId = serviceId;
  }

  public AppLayer layerName(String layerName) {
    this.layerName = layerName;
    return this;
  }

  /**
   * Layer name as known by the service.
   * @return layerName
   */
  @NotNull 
  @Schema(name = "layerName", description = "Layer name as known by the service.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("layerName")
  public String getLayerName() {
    return layerName;
  }

  public void setLayerName(String layerName) {
    this.layerName = layerName;
  }

  public AppLayer title(String title) {
    this.title = title;
    return this;
  }

  /**
   * Layer title or display name.
   * @return title
   */
  @NotNull 
  @Schema(name = "title", description = "Layer title or display name.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public AppLayer url(String url) {
    this.url = url;
    return this;
  }

  /**
   * URL for this specific layer. If empty use URL from the service.
   * @return url
   */
  
  @Schema(name = "url", description = "URL for this specific layer. If empty use URL from the service.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("url")
  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  public AppLayer visible(Boolean visible) {
    this.visible = visible;
    return this;
  }

  /**
   * Get visible
   * @return visible
   */
  @NotNull 
  @Schema(name = "visible", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("visible")
  public Boolean getVisible() {
    return visible;
  }

  public void setVisible(Boolean visible) {
    this.visible = visible;
  }

  public AppLayer opacity(Integer opacity) {
    this.opacity = opacity;
    return this;
  }

  /**
   * The opacity of the layer (in percentage, from 0-100, where 0 is \"transparent\" and 100 is \"opaque\").
   * @return opacity
   */
  
  @Schema(name = "opacity", description = "The opacity of the layer (in percentage, from 0-100, where 0 is \"transparent\" and 100 is \"opaque\").", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("opacity")
  public Integer getOpacity() {
    return opacity;
  }

  public void setOpacity(Integer opacity) {
    this.opacity = opacity;
  }

  public AppLayer minScale(Double minScale) {
    this.minScale = minScale;
    return this;
  }

  /**
   * Minimum scale at which this layer should be shown or is not blank. When absent there is no minimum. As reported by the service (ScaleHint or MinScaleDenominator).
   * @return minScale
   */
  
  @Schema(name = "minScale", description = "Minimum scale at which this layer should be shown or is not blank. When absent there is no minimum. As reported by the service (ScaleHint or MinScaleDenominator).", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("minScale")
  public Double getMinScale() {
    return minScale;
  }

  public void setMinScale(Double minScale) {
    this.minScale = minScale;
  }

  public AppLayer maxScale(Double maxScale) {
    this.maxScale = maxScale;
    return this;
  }

  /**
   * Maximum scale denominator at which this layer should be shown or is not blank. When absent there is no maximum. As reported by the service (ScaleHint or MaxScaleDenominator).
   * @return maxScale
   */
  
  @Schema(name = "maxScale", description = "Maximum scale denominator at which this layer should be shown or is not blank. When absent there is no maximum. As reported by the service (ScaleHint or MaxScaleDenominator).", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("maxScale")
  public Double getMaxScale() {
    return maxScale;
  }

  public void setMaxScale(Double maxScale) {
    this.maxScale = maxScale;
  }

  public AppLayer legendImageUrl(String legendImageUrl) {
    this.legendImageUrl = legendImageUrl;
    return this;
  }

  /**
   * URL to an image with the layer legend.
   * @return legendImageUrl
   */
  
  @Schema(name = "legendImageUrl", description = "URL to an image with the layer legend.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("legendImageUrl")
  public String getLegendImageUrl() {
    return legendImageUrl;
  }

  public void setLegendImageUrl(String legendImageUrl) {
    this.legendImageUrl = legendImageUrl;
  }

  public AppLayer legendType(LegendTypeEnum legendType) {
    this.legendType = legendType;
    return this;
  }

  /**
   * Whether the legend is a static image or a dynamic WMS legend.
   * @return legendType
   */
  
  @Schema(name = "legendType", description = "Whether the legend is a static image or a dynamic WMS legend.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("legendType")
  public LegendTypeEnum getLegendType() {
    return legendType;
  }

  public void setLegendType(LegendTypeEnum legendType) {
    this.legendType = legendType;
  }

  public AppLayer tilingDisabled(Boolean tilingDisabled) {
    this.tilingDisabled = tilingDisabled;
    return this;
  }

  /**
   * Set to true to request a single tile for WMS (may result in errors when max size/mem exceeded)
   * @return tilingDisabled
   */
  
  @Schema(name = "tilingDisabled", description = "Set to true to request a single tile for WMS (may result in errors when max size/mem exceeded)", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tilingDisabled")
  public Boolean getTilingDisabled() {
    return tilingDisabled;
  }

  public void setTilingDisabled(Boolean tilingDisabled) {
    this.tilingDisabled = tilingDisabled;
  }

  public AppLayer tilingGutter(Integer tilingGutter) {
    this.tilingGutter = tilingGutter;
    return this;
  }

  /**
   * Gutter around tile to discard to avoid tile edge rendering artifacts
   * @return tilingGutter
   */
  
  @Schema(name = "tilingGutter", description = "Gutter around tile to discard to avoid tile edge rendering artifacts", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tilingGutter")
  public Integer getTilingGutter() {
    return tilingGutter;
  }

  public void setTilingGutter(Integer tilingGutter) {
    this.tilingGutter = tilingGutter;
  }

  public AppLayer hiDpiDisabled(Boolean hiDpiDisabled) {
    this.hiDpiDisabled = hiDpiDisabled;
    return this;
  }

  /**
   * Set to true to *not* render in high DPI when available
   * @return hiDpiDisabled
   */
  
  @Schema(name = "hiDpiDisabled", description = "Set to true to *not* render in high DPI when available", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("hiDpiDisabled")
  public Boolean getHiDpiDisabled() {
    return hiDpiDisabled;
  }

  public void setHiDpiDisabled(Boolean hiDpiDisabled) {
    this.hiDpiDisabled = hiDpiDisabled;
  }

  public AppLayer hiDpiMode(TileLayerHiDpiMode hiDpiMode) {
    this.hiDpiMode = hiDpiMode;
    return this;
  }

  /**
   * Get hiDpiMode
   * @return hiDpiMode
   */
  @Valid 
  @Schema(name = "hiDpiMode", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("hiDpiMode")
  public TileLayerHiDpiMode getHiDpiMode() {
    return hiDpiMode;
  }

  public void setHiDpiMode(TileLayerHiDpiMode hiDpiMode) {
    this.hiDpiMode = hiDpiMode;
  }

  public AppLayer hiDpiSubstituteLayer(String hiDpiSubstituteLayer) {
    this.hiDpiSubstituteLayer = hiDpiSubstituteLayer;
    return this;
  }

  /**
   * The layer name of this service to substitute when the device pixel ratio is higher
   * @return hiDpiSubstituteLayer
   */
  
  @Schema(name = "hiDpiSubstituteLayer", description = "The layer name of this service to substitute when the device pixel ratio is higher", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("hiDpiSubstituteLayer")
  public String getHiDpiSubstituteLayer() {
    return hiDpiSubstituteLayer;
  }

  public void setHiDpiSubstituteLayer(String hiDpiSubstituteLayer) {
    this.hiDpiSubstituteLayer = hiDpiSubstituteLayer;
  }

  public AppLayer minZoom(Integer minZoom) {
    this.minZoom = minZoom;
    return this;
  }

  /**
   * Minimum zoom for XYZ layer
   * @return minZoom
   */
  
  @Schema(name = "minZoom", description = "Minimum zoom for XYZ layer", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("minZoom")
  public Integer getMinZoom() {
    return minZoom;
  }

  public void setMinZoom(Integer minZoom) {
    this.minZoom = minZoom;
  }

  public AppLayer maxZoom(Integer maxZoom) {
    this.maxZoom = maxZoom;
    return this;
  }

  /**
   * Maximum zoom for XYZ layer
   * @return maxZoom
   */
  
  @Schema(name = "maxZoom", description = "Maximum zoom for XYZ layer", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("maxZoom")
  public Integer getMaxZoom() {
    return maxZoom;
  }

  public void setMaxZoom(Integer maxZoom) {
    this.maxZoom = maxZoom;
  }

  public AppLayer tileSize(Integer tileSize) {
    this.tileSize = tileSize;
    return this;
  }

  /**
   * Tile size for XYZ layer
   * @return tileSize
   */
  
  @Schema(name = "tileSize", description = "Tile size for XYZ layer", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tileSize")
  public Integer getTileSize() {
    return tileSize;
  }

  public void setTileSize(Integer tileSize) {
    this.tileSize = tileSize;
  }

  public AppLayer tileGridExtent(Bounds tileGridExtent) {
    this.tileGridExtent = tileGridExtent;
    return this;
  }

  /**
   * Get tileGridExtent
   * @return tileGridExtent
   */
  @Valid 
  @Schema(name = "tileGridExtent", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("tileGridExtent")
  public Bounds getTileGridExtent() {
    return tileGridExtent;
  }

  public void setTileGridExtent(Bounds tileGridExtent) {
    this.tileGridExtent = tileGridExtent;
  }

  public AppLayer hasAttributes(Boolean hasAttributes) {
    this.hasAttributes = hasAttributes;
    return this;
  }

  /**
   * Whether this layer has attributes that can be accessed eg. for feature info or attribute list
   * @return hasAttributes
   */
  @NotNull 
  @Schema(name = "hasAttributes", description = "Whether this layer has attributes that can be accessed eg. for feature info or attribute list", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("hasAttributes")
  public Boolean getHasAttributes() {
    return hasAttributes;
  }

  public void setHasAttributes(Boolean hasAttributes) {
    this.hasAttributes = hasAttributes;
  }

  public AppLayer editable(Boolean editable) {
    this.editable = editable;
    return this;
  }

  /**
   * Whether this layer can be edited.
   * @return editable
   */
  
  @Schema(name = "editable", description = "Whether this layer can be edited.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("editable")
  public Boolean getEditable() {
    return editable;
  }

  public void setEditable(Boolean editable) {
    this.editable = editable;
  }

  public AppLayer attribution(String attribution) {
    this.attribution = attribution;
    return this;
  }

  /**
   * Attribution text to show for this layer.
   * @return attribution
   */
  
  @Schema(name = "attribution", description = "Attribution text to show for this layer.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("attribution")
  public String getAttribution() {
    return attribution;
  }

  public void setAttribution(String attribution) {
    this.attribution = attribution;
  }

  public AppLayer description(String description) {
    this.description = description;
    return this;
  }

  /**
   * Description text to show for this layer, may contain some links and images (see htmlify pipe)
   * @return description
   */
  
  @Schema(name = "description", description = "Description text to show for this layer, may contain some links and images (see htmlify pipe)", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public AppLayer autoRefreshInSeconds(Double autoRefreshInSeconds) {
    this.autoRefreshInSeconds = autoRefreshInSeconds;
    return this;
  }

  /**
   * Automatically refresh the layer (in seconds)
   * @return autoRefreshInSeconds
   */
  
  @Schema(name = "autoRefreshInSeconds", description = "Automatically refresh the layer (in seconds)", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("autoRefreshInSeconds")
  public Double getAutoRefreshInSeconds() {
    return autoRefreshInSeconds;
  }

  public void setAutoRefreshInSeconds(Double autoRefreshInSeconds) {
    this.autoRefreshInSeconds = autoRefreshInSeconds;
  }

  public AppLayer searchIndex(LayerSearchIndex searchIndex) {
    this.searchIndex = searchIndex;
    return this;
  }

  /**
   * Get searchIndex
   * @return searchIndex
   */
  @Valid 
  @Schema(name = "searchIndex", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("searchIndex")
  public LayerSearchIndex getSearchIndex() {
    return searchIndex;
  }

  public void setSearchIndex(LayerSearchIndex searchIndex) {
    this.searchIndex = searchIndex;
  }

  public AppLayer webMercatorAvailable(Boolean webMercatorAvailable) {
    this.webMercatorAvailable = webMercatorAvailable;
    return this;
  }

  /**
   * Whether Web Mercator projection is available for this layer.
   * @return webMercatorAvailable
   */
  
  @Schema(name = "webMercatorAvailable", description = "Whether Web Mercator projection is available for this layer.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("webMercatorAvailable")
  public Boolean getWebMercatorAvailable() {
    return webMercatorAvailable;
  }

  public void setWebMercatorAvailable(Boolean webMercatorAvailable) {
    this.webMercatorAvailable = webMercatorAvailable;
  }

  public AppLayer hiddenFunctionality(Set<HiddenLayerFunctionalityEnum> hiddenFunctionality) {
    this.hiddenFunctionality = hiddenFunctionality;
    return this;
  }

  public AppLayer addHiddenFunctionalityItem(HiddenLayerFunctionalityEnum hiddenFunctionalityItem) {
    if (this.hiddenFunctionality == null) {
      this.hiddenFunctionality = new LinkedHashSet<>();
    }
    this.hiddenFunctionality.add(hiddenFunctionalityItem);
    return this;
  }

  /**
   * Functionality that should be hidden for a layer in the UI. The functionality is still available in the backend, so not a \"security\" setting.
   * @return hiddenFunctionality
   */
  @Valid 
  @Schema(name = "hiddenFunctionality", description = "Functionality that should be hidden for a layer in the UI. The functionality is still available in the backend, so not a \"security\" setting.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("hiddenFunctionality")
  public Set<HiddenLayerFunctionalityEnum> getHiddenFunctionality() {
    return hiddenFunctionality;
  }

  @JsonDeserialize(as = LinkedHashSet.class)
  public void setHiddenFunctionality(Set<HiddenLayerFunctionalityEnum> hiddenFunctionality) {
    this.hiddenFunctionality = hiddenFunctionality;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AppLayer appLayer = (AppLayer) o;
    return Objects.equals(this.id, appLayer.id) &&
        Objects.equals(this.serviceId, appLayer.serviceId) &&
        Objects.equals(this.layerName, appLayer.layerName) &&
        Objects.equals(this.title, appLayer.title) &&
        Objects.equals(this.url, appLayer.url) &&
        Objects.equals(this.visible, appLayer.visible) &&
        Objects.equals(this.opacity, appLayer.opacity) &&
        Objects.equals(this.minScale, appLayer.minScale) &&
        Objects.equals(this.maxScale, appLayer.maxScale) &&
        Objects.equals(this.legendImageUrl, appLayer.legendImageUrl) &&
        Objects.equals(this.legendType, appLayer.legendType) &&
        Objects.equals(this.tilingDisabled, appLayer.tilingDisabled) &&
        Objects.equals(this.tilingGutter, appLayer.tilingGutter) &&
        Objects.equals(this.hiDpiDisabled, appLayer.hiDpiDisabled) &&
        Objects.equals(this.hiDpiMode, appLayer.hiDpiMode) &&
        Objects.equals(this.hiDpiSubstituteLayer, appLayer.hiDpiSubstituteLayer) &&
        Objects.equals(this.minZoom, appLayer.minZoom) &&
        Objects.equals(this.maxZoom, appLayer.maxZoom) &&
        Objects.equals(this.tileSize, appLayer.tileSize) &&
        Objects.equals(this.tileGridExtent, appLayer.tileGridExtent) &&
        Objects.equals(this.hasAttributes, appLayer.hasAttributes) &&
        Objects.equals(this.editable, appLayer.editable) &&
        Objects.equals(this.attribution, appLayer.attribution) &&
        Objects.equals(this.description, appLayer.description) &&
        Objects.equals(this.autoRefreshInSeconds, appLayer.autoRefreshInSeconds) &&
        Objects.equals(this.searchIndex, appLayer.searchIndex) &&
        Objects.equals(this.webMercatorAvailable, appLayer.webMercatorAvailable) &&
        Objects.equals(this.hiddenFunctionality, appLayer.hiddenFunctionality);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, serviceId, layerName, title, url, visible, opacity, minScale, maxScale, legendImageUrl, legendType, tilingDisabled, tilingGutter, hiDpiDisabled, hiDpiMode, hiDpiSubstituteLayer, minZoom, maxZoom, tileSize, tileGridExtent, hasAttributes, editable, attribution, description, autoRefreshInSeconds, searchIndex, webMercatorAvailable, hiddenFunctionality);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AppLayer {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    serviceId: ").append(toIndentedString(serviceId)).append("\n");
    sb.append("    layerName: ").append(toIndentedString(layerName)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    visible: ").append(toIndentedString(visible)).append("\n");
    sb.append("    opacity: ").append(toIndentedString(opacity)).append("\n");
    sb.append("    minScale: ").append(toIndentedString(minScale)).append("\n");
    sb.append("    maxScale: ").append(toIndentedString(maxScale)).append("\n");
    sb.append("    legendImageUrl: ").append(toIndentedString(legendImageUrl)).append("\n");
    sb.append("    legendType: ").append(toIndentedString(legendType)).append("\n");
    sb.append("    tilingDisabled: ").append(toIndentedString(tilingDisabled)).append("\n");
    sb.append("    tilingGutter: ").append(toIndentedString(tilingGutter)).append("\n");
    sb.append("    hiDpiDisabled: ").append(toIndentedString(hiDpiDisabled)).append("\n");
    sb.append("    hiDpiMode: ").append(toIndentedString(hiDpiMode)).append("\n");
    sb.append("    hiDpiSubstituteLayer: ").append(toIndentedString(hiDpiSubstituteLayer)).append("\n");
    sb.append("    minZoom: ").append(toIndentedString(minZoom)).append("\n");
    sb.append("    maxZoom: ").append(toIndentedString(maxZoom)).append("\n");
    sb.append("    tileSize: ").append(toIndentedString(tileSize)).append("\n");
    sb.append("    tileGridExtent: ").append(toIndentedString(tileGridExtent)).append("\n");
    sb.append("    hasAttributes: ").append(toIndentedString(hasAttributes)).append("\n");
    sb.append("    editable: ").append(toIndentedString(editable)).append("\n");
    sb.append("    attribution: ").append(toIndentedString(attribution)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    autoRefreshInSeconds: ").append(toIndentedString(autoRefreshInSeconds)).append("\n");
    sb.append("    searchIndex: ").append(toIndentedString(searchIndex)).append("\n");
    sb.append("    webMercatorAvailable: ").append(toIndentedString(webMercatorAvailable)).append("\n");
    sb.append("    hiddenFunctionality: ").append(toIndentedString(hiddenFunctionality)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

