package org.tailormap.api.viewer.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 *  A possibly complete feature from the attribute source. The feature could have been filtered to not provide certain attributes. Any geometry attributes will be presented in WKT format 
 */

@Schema(name = "Feature", description = " A possibly complete feature from the attribute source. The feature could have been filtered to not provide certain attributes. Any geometry attributes will be presented in WKT format ")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.14.0")
public class Feature implements Serializable {

  private static final long serialVersionUID = 1L;

  private String fid;

  private String geometry;

  @Valid
  private Map<String, Object> attributes = new HashMap<>();

  public Feature() {
    super();
  }

  public Feature fid(String fid) {
    this.fid = fid;
    return this;
  }

  /**
   * feature id, a non-mutable identifier from the attribute source
   * @return fid
   */
  
  @Schema(name = "__fid", accessMode = Schema.AccessMode.READ_ONLY, description = "feature id, a non-mutable identifier from the attribute source", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("__fid")
  public String getFid() {
    return fid;
  }

  public void setFid(String fid) {
    this.fid = fid;
  }

  public Feature geometry(String geometry) {
    this.geometry = geometry;
    return this;
  }

  /**
   *  Default geometry of the feature as WKT, possibly simplified. Always linearized to make sure that it only holds a specification valid WKT. Can be used for highlighting or buffer/selection, not for editing. 
   * @return geometry
   */
  
  @Schema(name = "geometry", description = " Default geometry of the feature as WKT, possibly simplified. Always linearized to make sure that it only holds a specification valid WKT. Can be used for highlighting or buffer/selection, not for editing. ", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("geometry")
  public String getGeometry() {
    return geometry;
  }

  public void setGeometry(String geometry) {
    this.geometry = geometry;
  }

  public Feature attributes(Map<String, Object> attributes) {
    this.attributes = attributes;
    return this;
  }

  public Feature putAttributesItem(String key, Object attributesItem) {
    if (this.attributes == null) {
      this.attributes = new HashMap<>();
    }
    this.attributes.put(key, attributesItem);
    return this;
  }

  /**
   * feature attributes in key/value pairs
   * @return attributes
   */
  @NotNull @Size(min = 1) 
  @Schema(name = "attributes", description = "feature attributes in key/value pairs", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("attributes")
  public Map<String, Object> getAttributes() {
    return attributes;
  }

  public void setAttributes(Map<String, Object> attributes) {
    this.attributes = attributes;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Feature feature = (Feature) o;
    return Objects.equals(this.fid, feature.fid) &&
        Objects.equals(this.geometry, feature.geometry) &&
        Objects.equals(this.attributes, feature.attributes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fid, geometry, attributes);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Feature {\n");
    sb.append("    fid: ").append(toIndentedString(fid)).append("\n");
    sb.append("    geometry: ").append(toIndentedString(geometry)).append("\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

