package org.tailormap.api.viewer.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.lang.Nullable;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * A search result document
 */

@Schema(name = "SearchDocument", description = "A search result document")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.14.0")
public class SearchDocument implements Serializable {

  private static final long serialVersionUID = 1L;

  private String fid;

  private String geometry = null;

  @Valid
  private List<String> displayValues;

  public SearchDocument fid(String fid) {
    this.fid = fid;
    return this;
  }

  /**
   * The unique identifier of the feature, also the primary key in the underlying data source
   * @return fid
   */
  
  @Schema(name = "fid", description = "The unique identifier of the feature, also the primary key in the underlying data source", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("fid")
  public String getFid() {
    return fid;
  }

  public void setFid(String fid) {
    this.fid = fid;
  }

  public SearchDocument geometry(String geometry) {
    this.geometry = geometry;
    return this;
  }

  /**
   * The geometry of the feature (WKT)
   * @return geometry
   */
  
  @Schema(name = "geometry", description = "The geometry of the feature (WKT)", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("geometry")
  public String getGeometry() {
    return geometry;
  }

  public void setGeometry(String geometry) {
    this.geometry = geometry;
  }

  public SearchDocument displayValues(List<String> displayValues) {
    this.displayValues = displayValues;
    return this;
  }

  public SearchDocument addDisplayValuesItem(String displayValuesItem) {
    if (this.displayValues == null) {
      this.displayValues = new ArrayList<>();
    }
    this.displayValues.add(displayValuesItem);
    return this;
  }

  /**
   * The values from the index to display in the search result
   * @return displayValues
   */
  
  @Schema(name = "displayValues", description = "The values from the index to display in the search result", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("displayValues")
  public List<String> getDisplayValues() {
    return displayValues;
  }

  public void setDisplayValues(List<String> displayValues) {
    this.displayValues = displayValues;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SearchDocument searchDocument = (SearchDocument) o;
    return Objects.equals(this.fid, searchDocument.fid) &&
        Objects.equals(this.geometry, searchDocument.geometry) &&
        Objects.equals(this.displayValues, searchDocument.displayValues);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fid, geometry, displayValues);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SearchDocument {\n");
    sb.append("    fid: ").append(toIndentedString(fid)).append("\n");
    sb.append("    geometry: ").append(toIndentedString(geometry)).append("\n");
    sb.append("    displayValues: ").append(toIndentedString(displayValues)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

