package org.tailormap.api.viewer.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.lang.Nullable;
import org.tailormap.api.viewer.model.SearchDocument;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * A -possibly empty- list of search documents that fulfill the requested conditions and some metadata.
 */

@Schema(name = "SearchResponse", description = "A -possibly empty- list of search documents that fulfill the requested conditions and some metadata.")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.14.0")
public class SearchResponse implements Serializable {

  private static final long serialVersionUID = 1L;

  private Long start = null;

  private Long total;

  private Float maxScore = null;

  @Valid
  private List<@Valid SearchDocument> documents = new ArrayList<>();

  public SearchResponse start(Long start) {
    this.start = start;
    return this;
  }

  /**
   * requested start point, this will allow the client to request the next or previous page by adding or removing 1 or more. See also https://solr.apache.org/guide/solr/latest/query-guide/common-query-parameters.html#start-parameter
   * minimum: 0
   * @return start
   */
  @Min(0L) 
  @Schema(name = "start", description = "requested start point, this will allow the client to request the next or previous page by adding or removing 1 or more. See also https://solr.apache.org/guide/solr/latest/query-guide/common-query-parameters.html#start-parameter", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("start")
  public Long getStart() {
    return start;
  }

  public void setStart(Long start) {
    this.start = start;
  }

  public SearchResponse total(Long total) {
    this.total = total;
    return this;
  }

  /**
   * the total number of available search documents, could be an estimated value.
   * @return total
   */
  
  @Schema(name = "total", description = "the total number of available search documents, could be an estimated value.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("total")
  public Long getTotal() {
    return total;
  }

  public void setTotal(Long total) {
    this.total = total;
  }

  public SearchResponse maxScore(Float maxScore) {
    this.maxScore = maxScore;
    return this;
  }

  /**
   * the maximum score of the search documents. Commonly `null` for wildcard searches as these are filters and don't score.
   * @return maxScore
   */
  
  @Schema(name = "maxScore", description = "the maximum score of the search documents. Commonly `null` for wildcard searches as these are filters and don't score.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("maxScore")
  public Float getMaxScore() {
    return maxScore;
  }

  public void setMaxScore(Float maxScore) {
    this.maxScore = maxScore;
  }

  public SearchResponse documents(List<@Valid SearchDocument> documents) {
    this.documents = documents;
    return this;
  }

  public SearchResponse addDocumentsItem(SearchDocument documentsItem) {
    if (this.documents == null) {
      this.documents = new ArrayList<>();
    }
    this.documents.add(documentsItem);
    return this;
  }

  /**
   * list of search documents. When the pagenumber*pagesize exceeds the number of documents this list will be empty
   * @return documents
   */
  @Valid @Size(min = 0) 
  @Schema(name = "documents", description = "list of search documents. When the pagenumber*pagesize exceeds the number of documents this list will be empty", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("documents")
  public List<@Valid SearchDocument> getDocuments() {
    return documents;
  }

  public void setDocuments(List<@Valid SearchDocument> documents) {
    this.documents = documents;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SearchResponse searchResponse = (SearchResponse) o;
    return Objects.equals(this.start, searchResponse.start) &&
        Objects.equals(this.total, searchResponse.total) &&
        Objects.equals(this.maxScore, searchResponse.maxScore) &&
        Objects.equals(this.documents, searchResponse.documents);
  }

  @Override
  public int hashCode() {
    return Objects.hash(start, total, maxScore, documents);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SearchResponse {\n");
    sb.append("    start: ").append(toIndentedString(start)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    maxScore: ").append(toIndentedString(maxScore)).append("\n");
    sb.append("    documents: ").append(toIndentedString(documents)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

