/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.admin.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.springframework.format.annotation.DateTimeFormat;

@Schema(name="SearchIndexSummary", description="Summary of a search index run. This is created/updated when the index is finished.")
public class SearchIndexSummary
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer total = null;
    private Integer skippedCounter = null;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime startedAt = null;
    private Double duration = null;
    private String errorMessage = null;

    public SearchIndexSummary total(Integer total) {
        this.total = total;
        return this;
    }

    @Schema(name="total", description="Total number of features counted for indexing. When 0 or null, the index was cleared.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="total")
    public Integer getTotal() {
        return this.total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public SearchIndexSummary skippedCounter(Integer skippedCounter) {
        this.skippedCounter = skippedCounter;
        return this;
    }

    @Schema(name="skippedCounter", description="Number of features skipped during indexing.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="skippedCounter")
    public Integer getSkippedCounter() {
        return this.skippedCounter;
    }

    public void setSkippedCounter(Integer skippedCounter) {
        this.skippedCounter = skippedCounter;
    }

    public SearchIndexSummary startedAt(OffsetDateTime startedAt) {
        this.startedAt = startedAt;
        return this;
    }

    @Valid
    @Schema(name="startedAt", example="2024-12-13T11:30:40.863829185+01:00", description="Zoned date-time when the task started.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="startedAt")
    public OffsetDateTime getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(OffsetDateTime startedAt) {
        this.startedAt = startedAt;
    }

    public SearchIndexSummary duration(Double duration) {
        this.duration = duration;
        return this;
    }

    @Schema(name="duration", description="Time taken to index the source in seconds.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="duration")
    public Double getDuration() {
        return this.duration;
    }

    public void setDuration(Double duration) {
        this.duration = duration;
    }

    public SearchIndexSummary errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Schema(name="errorMessage", description="Error message if the task failed. Check the status field of the search index.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="errorMessage")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchIndexSummary searchIndexSummary = (SearchIndexSummary)o;
        return Objects.equals(this.total, searchIndexSummary.total) && Objects.equals(this.skippedCounter, searchIndexSummary.skippedCounter) && Objects.equals(this.startedAt, searchIndexSummary.startedAt) && Objects.equals(this.duration, searchIndexSummary.duration) && Objects.equals(this.errorMessage, searchIndexSummary.errorMessage);
    }

    public int hashCode() {
        return Objects.hash(this.total, this.skippedCounter, this.startedAt, this.duration, this.errorMessage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchIndexSummary {\n");
        sb.append("    total: ").append(this.toIndentedString((Object)this.total)).append("\n");
        sb.append("    skippedCounter: ").append(this.toIndentedString((Object)this.skippedCounter)).append("\n");
        sb.append("    startedAt: ").append(this.toIndentedString((Object)this.startedAt)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString((Object)this.duration)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString((Object)this.errorMessage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

