/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.configuration.dev;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.apache.solr.client.solrj.SolrServerException;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.EventListener;
import org.springframework.core.io.ClassPathResource;
import org.springframework.jdbc.core.simple.JdbcClient;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.PropertyPlaceholderHelper;
import org.tailormap.api.admin.model.TaskSchedule;
import org.tailormap.api.geotools.featuresources.FeatureSourceFactoryHelper;
import org.tailormap.api.geotools.featuresources.JDBCFeatureSourceHelper;
import org.tailormap.api.geotools.featuresources.WFSFeatureSourceHelper;
import org.tailormap.api.persistence.Application;
import org.tailormap.api.persistence.Catalog;
import org.tailormap.api.persistence.Configuration;
import org.tailormap.api.persistence.GeoService;
import org.tailormap.api.persistence.Group;
import org.tailormap.api.persistence.Page;
import org.tailormap.api.persistence.SearchIndex;
import org.tailormap.api.persistence.TMFeatureSource;
import org.tailormap.api.persistence.TMFeatureType;
import org.tailormap.api.persistence.Upload;
import org.tailormap.api.persistence.User;
import org.tailormap.api.persistence.helper.GeoServiceHelper;
import org.tailormap.api.persistence.json.AppContent;
import org.tailormap.api.persistence.json.AppLayerSettings;
import org.tailormap.api.persistence.json.AppSettings;
import org.tailormap.api.persistence.json.AppTreeLayerNode;
import org.tailormap.api.persistence.json.AppTreeLevelNode;
import org.tailormap.api.persistence.json.AppTreeNode;
import org.tailormap.api.persistence.json.AppUiSettings;
import org.tailormap.api.persistence.json.AttributeSettings;
import org.tailormap.api.persistence.json.AttributeValueSettings;
import org.tailormap.api.persistence.json.AuthorizationRule;
import org.tailormap.api.persistence.json.AuthorizationRuleDecision;
import org.tailormap.api.persistence.json.Bounds;
import org.tailormap.api.persistence.json.CatalogNode;
import org.tailormap.api.persistence.json.FeatureTypeRef;
import org.tailormap.api.persistence.json.FeatureTypeTemplate;
import org.tailormap.api.persistence.json.Filter;
import org.tailormap.api.persistence.json.FilterEditConfiguration;
import org.tailormap.api.persistence.json.FilterGroup;
import org.tailormap.api.persistence.json.GeoServiceDefaultLayerSettings;
import org.tailormap.api.persistence.json.GeoServiceLayerSettings;
import org.tailormap.api.persistence.json.GeoServiceProtocol;
import org.tailormap.api.persistence.json.GeoServiceSettings;
import org.tailormap.api.persistence.json.HiddenLayerFunctionalityEnum;
import org.tailormap.api.persistence.json.JDBCConnectionProperties;
import org.tailormap.api.persistence.json.MenuItem;
import org.tailormap.api.persistence.json.PageTile;
import org.tailormap.api.persistence.json.ServiceAuthentication;
import org.tailormap.api.persistence.json.TailormapObjectRef;
import org.tailormap.api.persistence.json.TileLayerHiDpiMode;
import org.tailormap.api.repository.ApplicationRepository;
import org.tailormap.api.repository.CatalogRepository;
import org.tailormap.api.repository.ConfigurationRepository;
import org.tailormap.api.repository.FeatureSourceRepository;
import org.tailormap.api.repository.GeoServiceRepository;
import org.tailormap.api.repository.GroupRepository;
import org.tailormap.api.repository.PageRepository;
import org.tailormap.api.repository.SearchIndexRepository;
import org.tailormap.api.repository.UploadRepository;
import org.tailormap.api.repository.UserRepository;
import org.tailormap.api.scheduling.FailingPocTask;
import org.tailormap.api.scheduling.IndexTask;
import org.tailormap.api.scheduling.InterruptablePocTask;
import org.tailormap.api.scheduling.PocTask;
import org.tailormap.api.scheduling.TMJobDataMap;
import org.tailormap.api.scheduling.TaskManagerService;
import org.tailormap.api.scheduling.TaskType;
import org.tailormap.api.security.InternalAdminAuthentication;
import org.tailormap.api.solr.SolrHelper;
import org.tailormap.api.solr.SolrService;
import org.tailormap.api.viewer.model.AppStyling;
import org.tailormap.api.viewer.model.Component;
import org.tailormap.api.viewer.model.ComponentConfig;

@org.springframework.context.annotation.Configuration
@ConditionalOnProperty(name={"tailormap-api.database.populate-testdata"}, havingValue="true")
public class PopulateTestData {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ApplicationContext appContext;
    private final UserRepository userRepository;
    private final GroupRepository groupRepository;
    private final CatalogRepository catalogRepository;
    private final GeoServiceRepository geoServiceRepository;
    private final GeoServiceHelper geoServiceHelper;
    private final SolrService solrService;
    private final TaskManagerService taskManagerService;
    private final FeatureSourceRepository featureSourceRepository;
    private final ApplicationRepository applicationRepository;
    private final ConfigurationRepository configurationRepository;
    private final SearchIndexRepository searchIndexRepository;
    private final FeatureSourceFactoryHelper featureSourceFactoryHelper;
    private final UploadRepository uploadRepository;
    private final PageRepository pageRepository;
    private final JdbcClient jdbcClient;
    @Value(value="${spatial.dbs.connect:false}")
    private boolean connectToSpatialDbs;
    @Value(value="#{'${tailormap-api.database.populate-testdata.categories}'.split(',')}")
    private Set<String> categories;
    @Value(value="${spatial.dbs.localhost:true}")
    private boolean connectToSpatialDbsAtLocalhost;
    @Value(value="${tailormap-api.database.populate-testdata.admin-hashed-password}")
    private String adminHashedPassword;
    @Value(value="${tailormap-api.database.populate-testdata.exit:false}")
    private boolean exit;
    @Value(value="${MAP5_URL:#{null}}")
    private String map5url;
    private final String tiles3dProxyUsername = "b3p";
    private final String tiles3dProxyPassword = "cOxPlJFWmtndFk0eVg5VdL";
    @Value(value="${tailormap-api.solr-batch-size:1000}")
    private int solrBatchSize;
    @Value(value="${tailormap-api.solr-geometry-validation-rule:repairBuffer0}")
    private String solrGeometryValidationRule;
    private final List<AuthorizationRule> ruleAnonymousRead = List.of(new AuthorizationRule().groupName("anonymous").decisions(Map.of("read", AuthorizationRuleDecision.ALLOW)));
    private final List<AuthorizationRule> ruleLoggedIn = List.of(new AuthorizationRule().groupName("authenticated").decisions(Map.of("read", AuthorizationRuleDecision.ALLOW)));

    public PopulateTestData(ApplicationContext appContext, UserRepository userRepository, GroupRepository groupRepository, CatalogRepository catalogRepository, GeoServiceRepository geoServiceRepository, GeoServiceHelper geoServiceHelper, SolrService solrService, TaskManagerService taskManagerService, FeatureSourceRepository featureSourceRepository, ApplicationRepository applicationRepository, ConfigurationRepository configurationRepository, FeatureSourceFactoryHelper featureSourceFactoryHelper, SearchIndexRepository searchIndexRepository, UploadRepository uploadRepository, PageRepository pageRepository, JdbcClient jdbcClient) {
        this.appContext = appContext;
        this.userRepository = userRepository;
        this.groupRepository = groupRepository;
        this.catalogRepository = catalogRepository;
        this.geoServiceRepository = geoServiceRepository;
        this.geoServiceHelper = geoServiceHelper;
        this.solrService = solrService;
        this.taskManagerService = taskManagerService;
        this.featureSourceRepository = featureSourceRepository;
        this.applicationRepository = applicationRepository;
        this.configurationRepository = configurationRepository;
        this.featureSourceFactoryHelper = featureSourceFactoryHelper;
        this.searchIndexRepository = searchIndexRepository;
        this.uploadRepository = uploadRepository;
        this.pageRepository = pageRepository;
        this.jdbcClient = jdbcClient;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    @Transactional
    public void populate() throws Exception {
        InternalAdminAuthentication.setInSecurityContext();
        try {
            this.createTestUsersAndGroups();
            this.createConfigurationTestData();
            if (this.categories.contains("catalog")) {
                this.createCatalogTestData();
            }
            if (this.categories.contains("apps")) {
                this.createAppTestData();
            }
            if (this.categories.contains("search-index")) {
                try {
                    this.createSolrIndex();
                }
                catch (Exception e) {
                    logger.error("Exception creating Solr Index for testdata (continuing)", (Throwable)e);
                }
            }
            if (this.categories.contains("tasks")) {
                this.createScheduledTasks();
            }
            if (this.categories.contains("pages")) {
                this.createPages();
            }
            logger.info("Test entities created");
            if (this.categories.contains("drawing")) {
                this.insertTestDrawing();
                logger.info("Test drawing created");
                try {
                    this.insertDrawingStyle();
                    logger.info("Test drawing style created");
                }
                catch (Exception e) {
                    logger.error("Exception creating drawing style", (Throwable)e);
                }
            }
        }
        finally {
            InternalAdminAuthentication.clearSecurityContextAuthentication();
        }
        if (this.exit) {
            new Thread(() -> {
                try {
                    logger.info("Exiting in 10 seconds");
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SpringApplication.exit((ApplicationContext)this.appContext, (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 0});
                System.exit(0);
            }).start();
        }
    }

    public void createTestUsersAndGroups() throws NoSuchElementException {
        Group groupFoo = new Group().setName("test-foo").setDescription("Used for integration tests.");
        this.groupRepository.save((Object)groupFoo);
        Group groupBar = new Group().setName("test-bar").setDescription("Used for integration tests.");
        groupBar.addOrUpdateAdminProperty("group-property", (Object)true, true);
        groupBar.addOrUpdateAdminProperty("group-private-property", (Object)999.9, false);
        this.groupRepository.save((Object)groupBar);
        Group groupBaz = new Group().setName("test-baz").setDescription("Used for integration tests.");
        this.groupRepository.save((Object)groupBaz);
        User u = new User().setUsername("user").setPassword("{noop}user").setEmail("user@example.com");
        u.getGroups().addAll(List.of(groupFoo, groupBar, groupBaz));
        this.userRepository.save((Object)u);
        u = new User().setUsername("foo").setPassword("{noop}foo").setEmail("foo@example.com").setName("Foo only user");
        u.getGroups().add(groupFoo);
        this.userRepository.save((Object)u);
        u = new User().setUsername("tm-admin").setPassword(this.adminHashedPassword);
        u.addOrUpdateAdminProperty("some-property", (Object)"some-value", true);
        u.addOrUpdateAdminProperty("admin-property", (Object)"private-value", false);
        u.getGroups().add((Group)this.groupRepository.findById((Object)"admin").orElseThrow());
        u.getGroups().add(groupBar);
        this.userRepository.save((Object)u);
    }

    private void createCatalogTestData() throws Exception {
        Catalog catalog = (Catalog)this.catalogRepository.findById((Object)"main").orElseThrow();
        CatalogNode rootCatalogNode = (CatalogNode)catalog.getNodes().get(0);
        CatalogNode catalogNode = new CatalogNode().id("test").title("Test services");
        rootCatalogNode.addChildrenItem(catalogNode.getId());
        catalog.getNodes().add(catalogNode);
        String osmAttribution = "\u00a9 [OpenStreetMap](https://www.openstreetmap.org/copyright) contributors";
        Bounds rdTileGridExtent = new Bounds().minx(Double.valueOf(-285401.92)).maxx(Double.valueOf(595401.92)).miny(Double.valueOf(22598.08)).maxy(Double.valueOf(903401.92));
        Upload legend = new Upload().setCategory("legend").setFilename("gemeentegebied-legend.png").setMimeType("image/png").setContent(new ClassPathResource("test/gemeentegebied-legend.png").getContentAsByteArray()).setLastModified(OffsetDateTime.now(ZoneId.systemDefault()));
        this.uploadRepository.save((Object)legend);
        List<GeoService> services = List.of(new GeoService().setId("demo").setProtocol(GeoServiceProtocol.WMS).setTitle("Demo").setPublished(true).setAuthorizationRules(this.ruleAnonymousRead).setUrl("https://demo.tailormap.com/geoserver/geodata/ows?SERVICE=WMS"), new GeoService().setId("osm").setProtocol(GeoServiceProtocol.XYZ).setTitle("OSM").setUrl("https://tile.openstreetmap.org/{z}/{x}/{y}.png").setAuthorizationRules(this.ruleAnonymousRead).setSettings(new GeoServiceSettings().xyzCrs("EPSG:3857").layerSettings(Map.of("xyz", new GeoServiceLayerSettings().attribution(osmAttribution).maxZoom(Integer.valueOf(19))))), new GeoService().setId("snapshot-geoserver").setProtocol(GeoServiceProtocol.WMS).setTitle("Test GeoServer").setUrl("https://snapshot.tailormap.nl/geoserver/wms").setAuthorizationRules(this.ruleAnonymousRead).setPublished(true), new GeoService().setId("filtered-snapshot-geoserver").setProtocol(GeoServiceProtocol.WMS).setTitle("Test GeoServer (with authorization rules)").setUrl("https://snapshot.tailormap.nl/geoserver/wms").setAuthorizationRules(List.of(new AuthorizationRule().groupName("test-foo").decisions(Map.of("read", AuthorizationRuleDecision.ALLOW)), new AuthorizationRule().groupName("test-baz").decisions(Map.of("read", AuthorizationRuleDecision.ALLOW)))).setSettings(new GeoServiceSettings().layerSettings(Map.of("BGT", new GeoServiceLayerSettings().addAuthorizationRulesItem(new AuthorizationRule().groupName("test-foo").decisions(Map.of("read", AuthorizationRuleDecision.DENY))).addAuthorizationRulesItem(new AuthorizationRule().groupName("test-baz").decisions(Map.of("read", AuthorizationRuleDecision.ALLOW)))))).setPublished(true), new GeoService().setId("snapshot-geoserver-proxied").setProtocol(GeoServiceProtocol.WMS).setTitle("Test GeoServer (proxied)").setUrl("https://snapshot.tailormap.nl/geoserver/wms").setAuthorizationRules(this.ruleAnonymousRead).setSettings(new GeoServiceSettings().useProxy(Boolean.valueOf(true))), new GeoService().setId("openbasiskaart").setProtocol(GeoServiceProtocol.WMTS).setTitle("Openbasiskaart").setUrl("https://www.openbasiskaart.nl/mapcache/wmts").setAuthorizationRules(this.ruleAnonymousRead).setSettings(new GeoServiceSettings().defaultLayerSettings(new GeoServiceDefaultLayerSettings().attribution(osmAttribution)).layerSettings(Map.of("osm", new GeoServiceLayerSettings().title("Openbasiskaart").hiDpiDisabled(Boolean.valueOf(false)).hiDpiMode(TileLayerHiDpiMode.SUBSTITUTELAYERSHOWNEXTZOOMLEVEL).hiDpiSubstituteLayer("osm-hq")))), new GeoService().setId("openbasiskaart-proxied").setProtocol(GeoServiceProtocol.WMTS).setTitle("Openbasiskaart (proxied)").setUrl("https://www.openbasiskaart.nl/mapcache/wmts").setAuthorizationRules(this.ruleAnonymousRead).setAuthentication(new ServiceAuthentication().method(ServiceAuthentication.MethodEnum.PASSWORD).username("test").password("test")).setSettings(new GeoServiceSettings().useProxy(Boolean.valueOf(true)).defaultLayerSettings(new GeoServiceDefaultLayerSettings().attribution(osmAttribution)).layerSettings(Map.of("osm", new GeoServiceLayerSettings().hiDpiDisabled(Boolean.valueOf(false)).hiDpiMode(TileLayerHiDpiMode.SUBSTITUTELAYERSHOWNEXTZOOMLEVEL).hiDpiSubstituteLayer("osm-hq")))), new GeoService().setId("openbasiskaart-tms").setProtocol(GeoServiceProtocol.XYZ).setTitle("Openbasiskaart (TMS)").setUrl("https://openbasiskaart.nl/mapcache/tms/1.0.0/osm@rd/{z}/{x}/{-y}.png").setAuthorizationRules(this.ruleAnonymousRead).setSettings(new GeoServiceSettings().xyzCrs("EPSG:28992").defaultLayerSettings(new GeoServiceDefaultLayerSettings().attribution(osmAttribution)).layerSettings(Map.of("xyz", new GeoServiceLayerSettings().maxZoom(Integer.valueOf(15)).tileGridExtent(rdTileGridExtent).hiDpiDisabled(Boolean.valueOf(false)).hiDpiMode(TileLayerHiDpiMode.SUBSTITUTELAYERTILEPIXELRATIOONLY).hiDpiSubstituteLayer("https://openbasiskaart.nl/mapcache/tms/1.0.0/osm-hq@rd-hq/{z}/{x}/{-y}.png")))), new GeoService().setId("pdok-hwh-luchtfotorgb").setProtocol(GeoServiceProtocol.WMTS).setTitle("PDOK HWH luchtfoto").setUrl("https://service.pdok.nl/hwh/luchtfotorgb/wmts/v1_0").setAuthorizationRules(this.ruleAnonymousRead).setPublished(true).setSettings(new GeoServiceSettings().defaultLayerSettings(new GeoServiceDefaultLayerSettings().attribution("\u00a9 [Beeldmateriaal.nl](https://beeldmateriaal.nl)").hiDpiDisabled(Boolean.valueOf(false))).putLayerSettingsItem("Actueel_orthoHR", new GeoServiceLayerSettings().title("Luchtfoto"))), new GeoService().setId("b3p-mapproxy-luchtfoto").setProtocol(GeoServiceProtocol.XYZ).setTitle("Luchtfoto (TMS)").setUrl("https://mapproxy.b3p.nl/tms/1.0.0/luchtfoto/EPSG28992/{z}/{x}/{-y}.jpeg").setAuthorizationRules(this.ruleAnonymousRead).setPublished(true).setSettings(new GeoServiceSettings().xyzCrs("EPSG:28992").defaultLayerSettings(new GeoServiceDefaultLayerSettings().attribution("\u00a9 [Beeldmateriaal.nl](https://beeldmateriaal.nl)").hiDpiDisabled(Boolean.valueOf(false))).layerSettings(Map.of("xyz", new GeoServiceLayerSettings().maxZoom(Integer.valueOf(14)).tileGridExtent(rdTileGridExtent).hiDpiMode(TileLayerHiDpiMode.SHOWNEXTZOOMLEVEL)))), new GeoService().setId("at-basemap").setProtocol(GeoServiceProtocol.WMTS).setTitle("basemap.at").setUrl("https://mapsneu.wien.gv.at/basemapneu/1.0.0/WMTSCapabilities.xml").setAuthorizationRules(this.ruleAnonymousRead).setPublished(true).setSettings(new GeoServiceSettings().defaultLayerSettings(new GeoServiceDefaultLayerSettings().attribution("\u00a9 [basemap.at](https://basemap.at)").hiDpiDisabled(Boolean.valueOf(true))).layerSettings(Map.of("geolandbasemap", new GeoServiceLayerSettings().title("Basemap").hiDpiDisabled(Boolean.valueOf(false)).hiDpiMode(TileLayerHiDpiMode.SUBSTITUTELAYERTILEPIXELRATIOONLY).hiDpiSubstituteLayer("bmaphidpi"), "bmaporthofoto30cm", new GeoServiceLayerSettings().title("Orthophoto").hiDpiDisabled(Boolean.valueOf(false))))), new GeoService().setId("pdok-kadaster-bestuurlijkegebieden").setProtocol(GeoServiceProtocol.WMS).setUrl("https://service.pdok.nl/kadaster/bestuurlijkegebieden/wms/v1_0?service=WMS").setAuthorizationRules(this.ruleAnonymousRead).setSettings(new GeoServiceSettings().defaultLayerSettings(new GeoServiceDefaultLayerSettings().description("This layer shows an administrative boundary.")).serverType(GeoServiceSettings.ServerTypeEnum.MAPSERVER).useProxy(Boolean.valueOf(true)).putLayerSettingsItem("Gemeentegebied", new GeoServiceLayerSettings().legendImageId(legend.getId().toString()))).setPublished(true).setTitle("PDOK Kadaster bestuurlijke gebieden"), new GeoService().setId("bestuurlijkegebieden-proxied").setProtocol(GeoServiceProtocol.WMS).setUrl("https://service.pdok.nl/kadaster/bestuurlijkegebieden/wms/v1_0?service=WMS").setAuthorizationRules(this.ruleAnonymousRead).setAuthentication(new ServiceAuthentication().method(ServiceAuthentication.MethodEnum.PASSWORD).username("test").password("test")).setSettings(new GeoServiceSettings().serverType(GeoServiceSettings.ServerTypeEnum.MAPSERVER).useProxy(Boolean.valueOf(true))).setPublished(true).setTitle("Bestuurlijke gebieden (proxied met auth)"), new GeoService().setId("3dbag_utrecht").setProtocol(GeoServiceProtocol.TILES3D).setUrl("https://3dtilesnederland.nl/tiles/1.0/implicit/nederland/344.json").setTitle("3D BAG Utrecht").setPublished(true).setAuthorizationRules(this.ruleAnonymousRead), new GeoService().setId("ahn_terrain_model").setProtocol(GeoServiceProtocol.QUANTIZEDMESH).setUrl("https://api.pdok.nl/kadaster/3d-basisvoorziening/ogc/v1/collections/digitaalterreinmodel").setTitle("AHN Terrain Model").setPublished(true).setAuthorizationRules(this.ruleAnonymousRead), new GeoService().setId("3d_basisvoorziening_gebouwen_proxy").setProtocol(GeoServiceProtocol.TILES3D).setUrl("https://api.pdok.nl/kadaster/3d-basisvoorziening/ogc/v1_0/collections/gebouwen/3dtiles").setTitle("3D Basisvoorziening Gebouwen Proxy").setPublished(true).setAuthorizationRules(this.ruleAnonymousRead).setSettings(new GeoServiceSettings().useProxy(Boolean.valueOf(true))), new GeoService().setId("3d_utrecht_proxied_auth").setProtocol(GeoServiceProtocol.TILES3D).setUrl("https://snapshot.tailormap.nl/tiles3d-proxy/3dtiles").setTitle("3D Utrecht Proxied with Authorization").setPublished(true).setAuthorizationRules(this.ruleAnonymousRead).setAuthentication(new ServiceAuthentication().method(ServiceAuthentication.MethodEnum.PASSWORD).username("b3p").password("cOxPlJFWmtndFk0eVg5VdL")).setSettings(new GeoServiceSettings().useProxy(Boolean.valueOf(true))));
        if (this.map5url != null) {
            GeoServiceLayerSettings osmAttr = new GeoServiceLayerSettings().attribution(osmAttribution);
            GeoServiceLayerSettings map5Attr = new GeoServiceLayerSettings().attribution("Kaarten: [Map5.nl](https://map5.nl), data: " + osmAttribution);
            services = new ArrayList<GeoService>(services);
            services.add(new GeoService().setId("map5").setProtocol(GeoServiceProtocol.WMTS).setTitle("Map5").setUrl(this.map5url).setAuthorizationRules(this.ruleAnonymousRead).setSettings(new GeoServiceSettings().defaultLayerSettings(new GeoServiceDefaultLayerSettings().hiDpiDisabled(Boolean.valueOf(true))).layerSettings(Map.of("openlufo", new GeoServiceLayerSettings().attribution("\u00a9 [Beeldmateriaal.nl](https://beeldmateriaal.nl), " + osmAttribution), "luforoadslabels", osmAttr, "map5topo", new GeoServiceLayerSettings().attribution(map5Attr.getAttribution()).hiDpiDisabled(Boolean.valueOf(false)).hiDpiMode(TileLayerHiDpiMode.SUBSTITUTELAYERSHOWNEXTZOOMLEVEL).hiDpiSubstituteLayer("map5topo_hq"), "map5topo_gray", map5Attr, "map5topo_simple", map5Attr, "map5topo_simple_gray", map5Attr, "opensimpletopo", osmAttr, "opensimpletopo_gray", osmAttr, "opentopo", osmAttr, "opentopo_gray", osmAttr))));
        }
        for (GeoService geoService2 : services) {
            try {
                this.geoServiceHelper.loadServiceCapabilities(geoService2);
            }
            catch (Exception e) {
                logger.error("Error loading capabilities for {} service URL {}: {}, {}", new Object[]{geoService2.getProtocol().getValue(), geoService2.getUrl(), e.getClass(), e.getMessage()});
            }
            this.geoServiceRepository.save((Object)geoService2);
            catalogNode.addItemsItem(new TailormapObjectRef().kind(TailormapObjectRef.KindEnum.GEO_SERVICE).id(geoService2.getId()));
        }
        CatalogNode wfsFeatureSourceCatalogNode = new CatalogNode().id("wfs_feature_sources").title("WFS feature sources");
        rootCatalogNode.addChildrenItem(wfsFeatureSourceCatalogNode.getId());
        catalog.getNodes().add(wfsFeatureSourceCatalogNode);
        services.stream().filter(s -> s.getProtocol() == GeoServiceProtocol.WMS).forEach(s -> {
            this.geoServiceHelper.findAndSaveRelatedWFS(s);
            List linkedSources = this.featureSourceRepository.findByLinkedServiceId(s.getId());
            for (TMFeatureSource linkedSource : linkedSources) {
                wfsFeatureSourceCatalogNode.addItemsItem(new TailormapObjectRef().kind(TailormapObjectRef.KindEnum.FEATURE_SOURCE).id(linkedSource.getId().toString()));
            }
        });
        String geodataPassword = "980f1c8A-25933b2";
        Map<String, TMFeatureSource> featureSources = Map.of("postgis", new TMFeatureSource().setProtocol(TMFeatureSource.Protocol.JDBC).setTitle("PostGIS").setJdbcConnection(new JDBCConnectionProperties().dbtype(JDBCConnectionProperties.DbtypeEnum.POSTGIS).host(this.connectToSpatialDbsAtLocalhost ? "127.0.0.1" : "postgis").port(Integer.valueOf(this.connectToSpatialDbsAtLocalhost ? 54322 : 5432)).database("geodata").schema("public").additionalProperties(Map.of("connectionOptions", "?ApplicationName=tailormap-api"))).setAuthentication(new ServiceAuthentication().method(ServiceAuthentication.MethodEnum.PASSWORD).username("geodata").password(geodataPassword)), "postgis_osm", new TMFeatureSource().setProtocol(TMFeatureSource.Protocol.JDBC).setTitle("PostGIS OSM").setJdbcConnection(new JDBCConnectionProperties().dbtype(JDBCConnectionProperties.DbtypeEnum.POSTGIS).host(this.connectToSpatialDbsAtLocalhost ? "127.0.0.1" : "postgis").port(Integer.valueOf(this.connectToSpatialDbsAtLocalhost ? 54322 : 5432)).database("geodata").schema("osm").additionalProperties(Map.of("connectionOptions", "?ApplicationName=tailormap-api"))).setAuthentication(new ServiceAuthentication().method(ServiceAuthentication.MethodEnum.PASSWORD).username("geodata").password(geodataPassword)), "oracle", new TMFeatureSource().setProtocol(TMFeatureSource.Protocol.JDBC).setTitle("Oracle").setJdbcConnection(new JDBCConnectionProperties().dbtype(JDBCConnectionProperties.DbtypeEnum.ORACLE).host(this.connectToSpatialDbsAtLocalhost ? "127.0.0.1" : "oracle").database("/FREEPDB1").schema("GEODATA").additionalProperties(Map.of("connectionOptions", "?oracle.jdbc.J2EE13Compliant=true"))).setAuthentication(new ServiceAuthentication().method(ServiceAuthentication.MethodEnum.PASSWORD).username("geodata").password(geodataPassword)), "sqlserver", new TMFeatureSource().setProtocol(TMFeatureSource.Protocol.JDBC).setTitle("MS SQL Server").setJdbcConnection(new JDBCConnectionProperties().dbtype(JDBCConnectionProperties.DbtypeEnum.SQLSERVER).host(this.connectToSpatialDbsAtLocalhost ? "127.0.0.1" : "sqlserver").database("geodata").schema("dbo").additionalProperties(Map.of("connectionOptions", ";encrypt=false"))).setAuthentication(new ServiceAuthentication().method(ServiceAuthentication.MethodEnum.PASSWORD).username("geodata").password(geodataPassword)), "pdok-kadaster-bestuurlijkegebieden", new TMFeatureSource().setProtocol(TMFeatureSource.Protocol.WFS).setUrl("https://service.pdok.nl/kadaster/bestuurlijkegebieden/wfs/v1_0?service=WFS&VERSION=2.0.0").setTitle("Bestuurlijke gebieden").setNotes("Overzicht van de bestuurlijke indeling van Nederland in gemeenten en provincies alsmede de rijksgrens. Gegevens zijn afgeleid uit de Basisregistratie Kadaster (BRK)."));
        this.featureSourceRepository.saveAll(featureSources.values());
        new WFSFeatureSourceHelper().loadCapabilities(featureSources.get("pdok-kadaster-bestuurlijkegebieden"));
        this.geoServiceRepository.findById("pdok-kadaster-bestuurlijkegebieden").ifPresent(geoService -> {
            geoService.getSettings().getLayerSettings().put("Provinciegebied", new GeoServiceLayerSettings().description("The administrative boundary of Dutch Provinces, connected to a WFS.").featureType(new FeatureTypeRef().featureSourceId(((TMFeatureSource)featureSources.get("pdok-kadaster-bestuurlijkegebieden")).getId()).featureTypeName("bestuurlijkegebieden:Provinciegebied")).title("Provinciegebied (WFS)"));
            this.geoServiceRepository.save(geoService);
        });
        this.geoServiceRepository.findById("bestuurlijkegebieden-proxied").ifPresent(geoService -> {
            geoService.getSettings().getLayerSettings().put("Provinciegebied", new GeoServiceLayerSettings().featureType(new FeatureTypeRef().featureSourceId(((TMFeatureSource)featureSources.get("pdok-kadaster-bestuurlijkegebieden")).getId()).featureTypeName("bestuurlijkegebieden:Provinciegebied")).title("Provinciegebied (WFS, proxied met auth)"));
            this.geoServiceRepository.save(geoService);
        });
        CatalogNode featureSourceCatalogNode = new CatalogNode().id("feature_sources").title("Test feature sources");
        rootCatalogNode.addChildrenItem(featureSourceCatalogNode.getId());
        catalog.getNodes().add(featureSourceCatalogNode);
        for (TMFeatureSource featureSource : featureSources.values()) {
            featureSourceCatalogNode.addItemsItem(new TailormapObjectRef().kind(TailormapObjectRef.KindEnum.FEATURE_SOURCE).id(featureSource.getId().toString()));
        }
        this.catalogRepository.save((Object)catalog);
        if (this.connectToSpatialDbs) {
            featureSources.values().forEach(fs -> {
                try {
                    if (fs.getProtocol() == TMFeatureSource.Protocol.JDBC) {
                        new JDBCFeatureSourceHelper().loadCapabilities(fs);
                    } else if (fs.getProtocol() == TMFeatureSource.Protocol.WFS) {
                        new WFSFeatureSourceHelper().loadCapabilities(fs);
                    }
                }
                catch (Exception e) {
                    logger.error("Error loading capabilities for feature source {}", (Object)fs.getTitle(), (Object)e);
                }
            });
            services.stream().filter(s -> s.getId().startsWith("snapshot-geoserver")).forEach(s -> s.getSettings().layerSettings(Map.of("postgis:begroeidterreindeel", new GeoServiceLayerSettings().description("This layer shows data from https://www.postgis.net/\n\nhttps://postgis.net/brand.svg").featureType(new FeatureTypeRef().featureSourceId(((TMFeatureSource)featureSources.get("postgis")).getId()).featureTypeName("begroeidterreindeel")), "postgis:bak", new GeoServiceLayerSettings().featureType(new FeatureTypeRef().featureSourceId(((TMFeatureSource)featureSources.get("postgis")).getId()).featureTypeName("bak")), "postgis:kadastraal_perceel", new GeoServiceLayerSettings().description("cadastral parcel label points").featureType(new FeatureTypeRef().featureSourceId(((TMFeatureSource)featureSources.get("postgis")).getId()).featureTypeName("kadastraal_perceel")), "sqlserver:wegdeel", new GeoServiceLayerSettings().attribution("CC BY 4.0 [BGT/Kadaster](https://www.nationaalgeoregister.nl/geonetwork/srv/api/records/2cb4769c-b56e-48fa-8685-c48f61b9a319)").description("This layer shows data from [MS SQL Server](https://learn.microsoft.com/en-us/sql/relational-databases/spatial/spatial-data-sql-server).\n\nhttps://social.technet.microsoft.com/wiki/cfs-filesystemfile.ashx/__key/communityserver-components-imagefileviewer/communityserver-wikis-components-files-00-00-00-00-05/1884.SQL_5F00_h_5F00_rgb.png_2D00_550x0.png").featureType(new FeatureTypeRef().featureSourceId(((TMFeatureSource)featureSources.get("sqlserver")).getId()).featureTypeName("wegdeel")), "oracle:WATERDEEL", new GeoServiceLayerSettings().description("This layer shows data from Oracle Spatial.").featureType(new FeatureTypeRef().featureSourceId(((TMFeatureSource)featureSources.get("oracle")).getId()).featureTypeName("WATERDEEL")), "postgis:osm_polygon", new GeoServiceLayerSettings().description("This layer shows OSM data from postgis.").featureType(new FeatureTypeRef().featureSourceId(((TMFeatureSource)featureSources.get("postgis_osm")).getId()).featureTypeName("osm_polygon")))));
        }
        featureSources.get("pdok-kadaster-bestuurlijkegebieden").getFeatureTypes().stream().filter(ft -> ft.getName().equals("bestuurlijkegebieden:Provinciegebied")).findFirst().ifPresent(ft -> {
            ft.getSettings().addHideAttributesItem("identificatie");
            ft.getSettings().addHideAttributesItem("ligtInLandCode");
            ft.getSettings().addHideAttributesItem("fuuid");
            ft.getSettings().putAttributeSettingsItem("naam", new AttributeSettings().title("Naam"));
            ft.getSettings().setTemplate(new FeatureTypeTemplate().templateLanguage("simple").markupLanguage("markdown").template("### Provincie\nDeze provincie heet **{{naam}}** en ligt in _{{ligtInLandNaam}}_.\n\n| Attribuut | Waarde             |\n| --------- | ------------------ |\n| `code`    | {{code}}           |\n| `naam`    | {{naam}}           |\n| `ligt in` | {{ligtInLandNaam}} |"));
        });
        featureSources.get("postgis").getFeatureTypes().stream().filter(ft -> ft.getName().equals("begroeidterreindeel")).findFirst().ifPresent(ft -> {
            ft.getSettings().addHideAttributesItem("terminationdate");
            ft.getSettings().addHideAttributesItem("geom_kruinlijn");
            ft.getSettings().putAttributeSettingsItem("gmlid", new AttributeSettings().title("GML ID"));
            ft.getSettings().putAttributeSettingsItem("identificatie", new AttributeSettings().title("Identificatie"));
            ft.getSettings().putAttributeSettingsItem("tijdstipregistratie", new AttributeSettings().title("Registratie"));
            ft.getSettings().putAttributeSettingsItem("eindregistratie", new AttributeSettings().title("Eind registratie"));
            ft.getSettings().putAttributeSettingsItem("class", new AttributeSettings().title("Klasse"));
            ft.getSettings().putAttributeSettingsItem("bronhouder", new AttributeSettings().title("Bronhouder"));
            ft.getSettings().putAttributeSettingsItem("inonderzoek", new AttributeSettings().title("In onderzoek"));
            ft.getSettings().putAttributeSettingsItem("relatievehoogteligging", new AttributeSettings().title("Relatieve hoogteligging"));
            ft.getSettings().putAttributeSettingsItem("bgt_status", new AttributeSettings().title("BGT status"));
            ft.getSettings().putAttributeSettingsItem("plus_status", new AttributeSettings().title("Plus-status"));
            ft.getSettings().putAttributeSettingsItem("plus_fysiekvoorkomen", new AttributeSettings().title("Plus-fysiek voorkomen"));
            ft.getSettings().putAttributeSettingsItem("begroeidterreindeeloptalud", new AttributeSettings().title("Op talud"));
            ft.getSettings().addAttributeOrderItem("identificatie");
            ft.getSettings().addAttributeOrderItem("bronhouder");
            ft.getSettings().addAttributeOrderItem("class");
        });
        featureSources.get("postgis").getFeatureTypes().stream().filter(ft -> ft.getName().equals("bak")).findFirst().ifPresent(ft -> {
            ft.getSettings().addHideAttributesItem("gmlid");
            ft.getSettings().addHideAttributesItem("lv_publicatiedatum");
            ft.getSettings().addHideAttributesItem("creationdate");
            ft.getSettings().addHideAttributesItem("tijdstipregistratie");
            ft.getSettings().addHideAttributesItem("eindregistratie");
            ft.getSettings().addHideAttributesItem("terminationdate");
            ft.getSettings().addHideAttributesItem("inonderzoek");
            ft.getSettings().addHideAttributesItem("relatievehoogteligging");
            ft.getSettings().addHideAttributesItem("bgt_status");
            ft.getSettings().addHideAttributesItem("plus_status");
            ft.getSettings().addHideAttributesItem("function_");
            ft.getSettings().addHideAttributesItem("plus_type");
        });
        featureSources.get("postgis").getFeatureTypes().stream().filter(ft -> ft.getName().equals("kadastraal_perceel")).findFirst().ifPresent(ft -> ft.getSettings().addHideAttributesItem("gml_id"));
    }

    public void createAppTestData() throws Exception {
        Upload logo = new Upload().setCategory("app-logo").setFilename("gradient.svg").setMimeType("image/svg+xml").setContent(new ClassPathResource("test/gradient-logo.svg").getContentAsByteArray()).setLastModified(OffsetDateTime.now(ZoneId.systemDefault()));
        this.uploadRepository.save((Object)logo);
        List<AppTreeLayerNode> baseNodes = List.of(new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:openbasiskaart:osm").serviceId("openbasiskaart").layerName("osm").visible(Boolean.valueOf(true)), new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:pdok-hwh-luchtfotorgb:Actueel_orthoHR").serviceId("pdok-hwh-luchtfotorgb").layerName("Actueel_orthoHR").visible(Boolean.valueOf(false)));
        Application app = new Application().setName("default").setTitle("Tailormap demo").setCrs("EPSG:28992").setAuthorizationRules(this.ruleAnonymousRead).setComponents(List.of(new Component().type("SIMPLE_SEARCH").config(new ComponentConfig().enabled(Boolean.valueOf(true)).putAdditionalProperty("municipalities", List.of("0344"))), new Component().type("EDIT").config(new ComponentConfig().enabled(Boolean.valueOf(true))), new Component().type("COORDINATE_LINK_WINDOW").config(new ComponentConfig().enabled(Boolean.valueOf(true)).putAdditionalProperty("urls", List.of(Map.of("id", "google-maps", "url", "https://www.google.com/maps/@[lat],[lon],18z", "alias", "Google Maps", "projection", "EPSG:4326"), Map.of("id", "tm-demo", "url", "https://demo.tailormap.com/#@[X],[Y],18", "alias", "Tailormap demo", "projection", "EPSG:28992")))))).setContentRoot(new AppContent().addBaseLayerNodesItem((AppTreeNode)new AppTreeLevelNode().objectType("AppTreeLevelNode").id("root-base-layers").root(Boolean.valueOf(true)).title("Base layers").childrenIds(List.of("lyr:openbasiskaart:osm", "lyr:pdok-hwh-luchtfotorgb:Actueel_orthoHR", "lyr:openbasiskaart-proxied:osm", "lyr:openbasiskaart-tms:xyz", "lyr:b3p-mapproxy-luchtfoto:xyz"))).addBaseLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:openbasiskaart-proxied:osm").serviceId("openbasiskaart-proxied").layerName("osm").visible(Boolean.valueOf(false))).addBaseLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:openbasiskaart-tms:xyz").serviceId("openbasiskaart-tms").layerName("xyz").visible(Boolean.valueOf(false))).addBaseLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:b3p-mapproxy-luchtfoto:xyz").serviceId("b3p-mapproxy-luchtfoto").layerName("xyz").visible(Boolean.valueOf(false))).addLayerNodesItem((AppTreeNode)new AppTreeLevelNode().objectType("AppTreeLevelNode").id("root").root(Boolean.valueOf(true)).title("Layers").childrenIds(List.of("lyr:pdok-kadaster-bestuurlijkegebieden:Provinciegebied", "lyr:bestuurlijkegebieden-proxied:Provinciegebied", "lyr:pdok-kadaster-bestuurlijkegebieden:Gemeentegebied", "lyr:snapshot-geoserver:postgis:begroeidterreindeel", "lyr:snapshot-geoserver:postgis:bak", "lyr:snapshot-geoserver:postgis:kadastraal_perceel", "lyr:snapshot-geoserver:sqlserver:wegdeel", "lyr:snapshot-geoserver:oracle:WATERDEEL", "lyr:snapshot-geoserver:BGT", "lvl:proxied", "lvl:osm", "lvl:archeo"))).addLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:pdok-kadaster-bestuurlijkegebieden:Provinciegebied").serviceId("pdok-kadaster-bestuurlijkegebieden").layerName("Provinciegebied").visible(Boolean.valueOf(true))).addLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:bestuurlijkegebieden-proxied:Provinciegebied").serviceId("bestuurlijkegebieden-proxied").layerName("Provinciegebied").visible(Boolean.valueOf(false))).addLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:pdok-kadaster-bestuurlijkegebieden:Gemeentegebied").serviceId("pdok-kadaster-bestuurlijkegebieden").layerName("Gemeentegebied").visible(Boolean.valueOf(true))).addLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:snapshot-geoserver:postgis:begroeidterreindeel").serviceId("snapshot-geoserver").layerName("postgis:begroeidterreindeel").visible(Boolean.valueOf(true))).addLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:snapshot-geoserver:postgis:bak").serviceId("snapshot-geoserver").layerName("postgis:bak").visible(Boolean.valueOf(false))).addLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:snapshot-geoserver:postgis:kadastraal_perceel").serviceId("snapshot-geoserver").layerName("postgis:kadastraal_perceel").visible(Boolean.valueOf(false))).addLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:snapshot-geoserver:sqlserver:wegdeel").serviceId("snapshot-geoserver").layerName("sqlserver:wegdeel").visible(Boolean.valueOf(true))).addLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:snapshot-geoserver:oracle:WATERDEEL").serviceId("snapshot-geoserver").layerName("oracle:WATERDEEL").visible(Boolean.valueOf(true))).addLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:snapshot-geoserver:BGT").serviceId("snapshot-geoserver").layerName("BGT").visible(Boolean.valueOf(false))).addLayerNodesItem((AppTreeNode)new AppTreeLevelNode().objectType("AppTreeLevelNode").id("lvl:proxied").title("Proxied").childrenIds(List.of("lyr:snapshot-geoserver-proxied:postgis:begroeidterreindeel"))).addLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:snapshot-geoserver-proxied:postgis:begroeidterreindeel").serviceId("snapshot-geoserver-proxied").layerName("postgis:begroeidterreindeel").visible(Boolean.valueOf(false))).addLayerNodesItem((AppTreeNode)new AppTreeLevelNode().objectType("AppTreeLevelNode").id("lvl:osm").title("OSM").childrenIds(List.of("lyr:snapshot-geoserver:postgis:osm_polygon"))).addLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:snapshot-geoserver:postgis:osm_polygon").serviceId("snapshot-geoserver").layerName("postgis:osm_polygon").visible(Boolean.valueOf(false))).addLayerNodesItem((AppTreeNode)new AppTreeLevelNode().objectType("AppTreeLevelNode").id("lvl:archeo").title("Archeology").childrenIds(List.of("lyr:demo:geomorfologie"))).addLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:demo:geomorfologie").serviceId("demo").layerName("geomorfologie").visible(Boolean.valueOf(true)))).setStyling(new AppStyling().logo(logo.getId().toString())).setSettings(new AppSettings().putLayerSettingsItem("lyr:openbasiskaart:osm", new AppLayerSettings().title("Openbasiskaart")).putLayerSettingsItem("lyr:pdok-hwh-luchtfotorgb:Actueel_orthoHR", new AppLayerSettings().title("Luchtfoto")).putLayerSettingsItem("lyr:openbasiskaart-proxied:osm", new AppLayerSettings().title("Openbasiskaart (proxied)")).putLayerSettingsItem("lyr:snapshot-geoserver:oracle:WATERDEEL", new AppLayerSettings().opacity(Integer.valueOf(50)).title("Waterdeel overridden title").editable(Boolean.valueOf(true)).description("This is the layer description from the app layer setting.").attribution("CC BY 4.0 [BGT/Kadaster](https://www.nationaalgeoregister.nl/geonetwork/srv/api/records/2cb4769c-b56e-48fa-8685-c48f61b9a319)")).putLayerSettingsItem("lyr:snapshot-geoserver:postgis:osm_polygon", new AppLayerSettings().description("OpenStreetMap polygon data in EPSG:3857").opacity(Integer.valueOf(60)).editable(Boolean.valueOf(true)).title("OSM Polygon (EPSG:3857)").attribution("\u00a9 [OpenStreetMap](https://www.openstreetmap.org/copyright) contributors")).putLayerSettingsItem("lyr:snapshot-geoserver:postgis:begroeidterreindeel", new AppLayerSettings().editable(Boolean.valueOf(true)).addHideAttributesItem("begroeidterreindeeloptalud").addReadOnlyAttributesItem("eindregistratie")).putLayerSettingsItem("lyr:snapshot-geoserver:postgis:kadastraal_perceel", new AppLayerSettings().editable(Boolean.valueOf(true)).addReadOnlyAttributesItem("aanduiding")).putLayerSettingsItem("lyr:snapshot-geoserver:sqlserver:wegdeel", new AppLayerSettings().editable(Boolean.valueOf(true))).putLayerSettingsItem("lyr:snapshot-geoserver-proxied:postgis:begroeidterreindeel", new AppLayerSettings().editable(Boolean.valueOf(false))).putLayerSettingsItem("lyr:pdok-kadaster-bestuurlijkegebieden:Provinciegebied", new AppLayerSettings().hiddenFunctionality(Set.of(HiddenLayerFunctionalityEnum.FEATURE_INFO, HiddenLayerFunctionalityEnum.ATTRIBUTE_LIST, HiddenLayerFunctionalityEnum.EXPORT))).addFilterGroupsItem(new FilterGroup().id("filtergroup1").source("PRESET").type(FilterGroup.TypeEnum.ATTRIBUTE).layerIds(List.of("lyr:snapshot-geoserver:postgis:begroeidterreindeel")).operator(FilterGroup.OperatorEnum.AND).addFiltersItem(new Filter().id("filter1").type(Filter.TypeEnum.ATTRIBUTE).condition(Filter.ConditionEnum.BEFORE).addValueItem("2025-06-05").attribute("creationdate").attributeType(Filter.AttributeTypeEnum.DATE)).addFiltersItem(new Filter().id("filter2").type(Filter.TypeEnum.ATTRIBUTE).condition(Filter.ConditionEnum.UNIQUE_VALUES).addValueItem("bodembedekkers").addValueItem("bosplantsoen").addValueItem("gras- en kruidachtigen").attribute("plus_fysiekvoorkomen").attributeType(Filter.AttributeTypeEnum.STRING).editConfiguration(new FilterEditConfiguration().filterTool(FilterEditConfiguration.FilterToolEnum.CHECKBOX).attributeValuesSettings(List.of(new AttributeValueSettings().value("bodembedekkers").initiallySelected(Boolean.valueOf(true)).selectable(Boolean.valueOf(true)).alias("Bodembedekkers"), new AttributeValueSettings().value("bosplantsoen").initiallySelected(Boolean.valueOf(true)).selectable(Boolean.valueOf(true)).alias("Bosplantsoen"), new AttributeValueSettings().value("gras- en kruidachtigen").initiallySelected(Boolean.valueOf(true)).selectable(Boolean.valueOf(true)).alias("Gras- en kruidachtigen"), new AttributeValueSettings().value("griend en hakhout").initiallySelected(Boolean.valueOf(false)).selectable(Boolean.valueOf(true)), new AttributeValueSettings().value("heesters").initiallySelected(Boolean.valueOf(false)).selectable(Boolean.valueOf(true)), new AttributeValueSettings().value("planten").initiallySelected(Boolean.valueOf(false)).selectable(Boolean.valueOf(true)), new AttributeValueSettings().value("struikrozen").initiallySelected(Boolean.valueOf(false)).selectable(Boolean.valueOf(true)), new AttributeValueSettings().value("waardeOnbekend").initiallySelected(Boolean.valueOf(false)).selectable(Boolean.valueOf(true))))))).addFilterGroupsItem(new FilterGroup().id("filtergroup2").source("PRESET").type(FilterGroup.TypeEnum.ATTRIBUTE).layerIds(List.of("lyr:snapshot-geoserver:postgis:kadastraal_perceel")).operator(FilterGroup.OperatorEnum.AND).addFiltersItem(new Filter().id("filter3").type(Filter.TypeEnum.ATTRIBUTE).condition(Filter.ConditionEnum.u).addValueItem("1").addValueItem("12419").attribute("perceelnummer").attributeType(Filter.AttributeTypeEnum.DOUBLE).editConfiguration(new FilterEditConfiguration().filterTool(FilterEditConfiguration.FilterToolEnum.SLIDER).initialLowerValue(Double.valueOf(1.0)).initialUpperValue(Double.valueOf(12419.0)).minimumValue(Double.valueOf(1.0)).maximumValue(Double.valueOf(12419.0))))));
        app.getContentRoot().getBaseLayerNodes().addAll(baseNodes);
        app.setInitialExtent(new Bounds().minx(Double.valueOf(130011.0)).miny(Double.valueOf(458031.0)).maxx(Double.valueOf(132703.0)).maxy(Double.valueOf(459995.0)));
        app.setMaxExtent(new Bounds().minx(Double.valueOf(-285401.0)).miny(Double.valueOf(22598.0)).maxx(Double.valueOf(595401.0)).maxy(Double.valueOf(903401.0)));
        if (this.map5url != null) {
            AppTreeLevelNode root = (AppTreeLevelNode)app.getContentRoot().getBaseLayerNodes().get(0);
            ArrayList<String> childrenIds = new ArrayList<String>(root.getChildrenIds());
            childrenIds.add("lyr:map5:map5topo");
            childrenIds.add("lyr:map5:map5topo_simple");
            childrenIds.add("lvl:luchtfoto-labels");
            root.setChildrenIds(childrenIds);
            app.getSettings().putLayerSettingsItem("lyr:map5:map5topo", new AppLayerSettings().title("Map5")).putLayerSettingsItem("lyr:map5:map5topo_simple", new AppLayerSettings().title("Map5 simple"));
            app.getContentRoot().addBaseLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:map5:map5topo").serviceId("map5").layerName("map5topo").visible(Boolean.valueOf(false))).addBaseLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:map5:map5topo_simple").serviceId("map5").layerName("map5topo_simple").visible(Boolean.valueOf(false))).addBaseLayerNodesItem((AppTreeNode)new AppTreeLevelNode().objectType("AppTreeLevelNode").id("lvl:luchtfoto-labels").title("Luchtfoto met labels").addChildrenIdsItem("lyr:map5:luforoadslabels").addChildrenIdsItem("lyr:pdok-hwh-luchtfotorgb:Actueel_orthoHR2")).addBaseLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:map5:luforoadslabels").serviceId("map5").layerName("luforoadslabels").visible(Boolean.valueOf(false))).addBaseLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:pdok-hwh-luchtfotorgb:Actueel_orthoHR2").serviceId("pdok-hwh-luchtfotorgb").layerName("Actueel_orthoHR").visible(Boolean.valueOf(false)));
        }
        this.applicationRepository.save((Object)app);
        app = new Application().setName("base").setTitle("Service base app").setCrs("EPSG:28992").setAuthorizationRules(this.ruleAnonymousRead).setContentRoot(new AppContent().addBaseLayerNodesItem((AppTreeNode)new AppTreeLevelNode().objectType("AppTreeLevelNode").id("root-base-layers").root(Boolean.valueOf(true)).title("Base layers").childrenIds(List.of("lyr:openbasiskaart:osm", "lyr:pdok-hwh-luchtfotorgb:Actueel_orthoHR"))));
        app.getContentRoot().getBaseLayerNodes().addAll(baseNodes);
        this.applicationRepository.save((Object)app);
        app = new Application().setName("secured").setTitle("secured app").setCrs("EPSG:28992").setAuthorizationRules(this.ruleLoggedIn).setContentRoot(new AppContent().addBaseLayerNodesItem((AppTreeNode)new AppTreeLevelNode().objectType("AppTreeLevelNode").id("root-base-layers").root(Boolean.valueOf(true)).title("Base layers").childrenIds(List.of("lyr:openbasiskaart:osm", "lyr:pdok-hwh-luchtfotorgb:Actueel_orthoHR", "lyr:openbasiskaart-proxied:osm"))).addBaseLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:openbasiskaart-proxied:osm").serviceId("openbasiskaart-proxied").layerName("osm").visible(Boolean.valueOf(false))).addLayerNodesItem((AppTreeNode)new AppTreeLevelNode().objectType("AppTreeLevelNode").id("root").root(Boolean.valueOf(true)).title("Layers").childrenIds(List.of("lyr:pdok-kadaster-bestuurlijkegebieden:Provinciegebied", "lyr:pdok-kadaster-bestuurlijkegebieden:Gemeentegebied", "lvl:proxied"))).addLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:pdok-kadaster-bestuurlijkegebieden:Gemeentegebied").serviceId("pdok-kadaster-bestuurlijkegebieden").layerName("Gemeentegebied").visible(Boolean.valueOf(true))).addLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:pdok-kadaster-bestuurlijkegebieden:Provinciegebied").serviceId("pdok-kadaster-bestuurlijkegebieden").layerName("Provinciegebied").visible(Boolean.valueOf(false))).addLayerNodesItem((AppTreeNode)new AppTreeLevelNode().objectType("AppTreeLevelNode").id("lvl:proxied").title("Proxied").childrenIds(List.of("lyr:snapshot-geoserver-proxied:postgis:begroeidterreindeel"))).addLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:snapshot-geoserver-proxied:postgis:begroeidterreindeel").serviceId("snapshot-geoserver-proxied").layerName("postgis:begroeidterreindeel").visible(Boolean.valueOf(false)))).setSettings(new AppSettings().putLayerSettingsItem("lyr:openbasiskaart-proxied:osm", new AppLayerSettings().title("Openbasiskaart (proxied)")));
        app.getContentRoot().getBaseLayerNodes().addAll(baseNodes);
        this.applicationRepository.save((Object)app);
        app = new Application().setName("secured-auth").setTitle("secured (with authorizations)").setCrs("EPSG:28992").setAuthorizationRules(List.of(new AuthorizationRule().groupName("test-foo").decisions(Map.of("read", AuthorizationRuleDecision.ALLOW)), new AuthorizationRule().groupName("test-bar").decisions(Map.of("read", AuthorizationRuleDecision.ALLOW)))).setContentRoot(new AppContent().addLayerNodesItem((AppTreeNode)new AppTreeLevelNode().objectType("AppTreeLevelNode").id("root").root(Boolean.valueOf(true)).title("Layers").childrenIds(List.of("lvl:needs-auth", "lvl:public"))).addLayerNodesItem((AppTreeNode)new AppTreeLevelNode().objectType("AppTreeLevelNode").id("lvl:public").title("Public").childrenIds(List.of("lyr:snapshot-geoserver:BGT"))).addLayerNodesItem((AppTreeNode)new AppTreeLevelNode().objectType("AppTreeLevelNode").id("lvl:needs-auth").title("Needs auth").childrenIds(List.of("lyr:filtered-snapshot-geoserver:BGT", "lyr:filtered-snapshot-geoserver:postgis:begroeidterreindeel"))).addLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:filtered-snapshot-geoserver:BGT").serviceId("filtered-snapshot-geoserver").layerName("BGT").visible(Boolean.valueOf(true))).addLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:filtered-snapshot-geoserver:postgis:begroeidterreindeel").serviceId("filtered-snapshot-geoserver").layerName("postgis:begroeidterreindeel").visible(Boolean.valueOf(true))).addLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:snapshot-geoserver:BGT").serviceId("snapshot-geoserver").layerName("BGT").visible(Boolean.valueOf(true))));
        this.applicationRepository.save((Object)app);
        app = new Application().setName("austria").setCrs("EPSG:3857").setAuthorizationRules(this.ruleAnonymousRead).setTitle("Austria").setInitialExtent(new Bounds().minx(Double.valueOf(987982.0)).miny(Double.valueOf(5799551.0)).maxx(Double.valueOf(1963423.0)).maxy(Double.valueOf(6320708.0))).setMaxExtent(new Bounds().minx(Double.valueOf(206516.0)).miny(Double.valueOf(5095461.0)).maxx(Double.valueOf(3146930.0)).maxy(Double.valueOf(7096232.0))).setContentRoot(new AppContent().addBaseLayerNodesItem((AppTreeNode)new AppTreeLevelNode().objectType("AppTreeLevelNode").id("root-base-layers").root(Boolean.valueOf(true)).title("Base layers").childrenIds(List.of("lyr:at-basemap:geolandbasemap", "lyr:at-basemap:orthofoto", "lvl:orthofoto-labels", "lyr:osm:xyz"))).addBaseLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:at-basemap:geolandbasemap").serviceId("at-basemap").layerName("geolandbasemap").visible(Boolean.valueOf(true))).addBaseLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:at-basemap:orthofoto").serviceId("at-basemap").layerName("bmaporthofoto30cm").visible(Boolean.valueOf(false))).addBaseLayerNodesItem((AppTreeNode)new AppTreeLevelNode().objectType("AppTreeLevelNode").id("lvl:orthofoto-labels").title("Orthophoto with labels").childrenIds(List.of("lyr:at-basemap:bmapoverlay", "lyr:at-basemap:orthofoto_2"))).addBaseLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:at-basemap:bmapoverlay").serviceId("at-basemap").layerName("bmapoverlay").visible(Boolean.valueOf(false))).addBaseLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:at-basemap:orthofoto_2").serviceId("at-basemap").layerName("bmaporthofoto30cm").visible(Boolean.valueOf(false))).addBaseLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:osm:xyz").serviceId("osm").layerName("xyz").visible(Boolean.valueOf(false))));
        this.applicationRepository.save((Object)app);
        app = new Application().setName("3d_utrecht").setCrs("EPSG:3857").setAuthorizationRules(this.ruleLoggedIn).setTitle("3D Utrecht").setInitialExtent(new Bounds().minx(Double.valueOf(558390.0)).miny(Double.valueOf(6818485.0)).maxx(Double.valueOf(566751.0)).maxy(Double.valueOf(6824036.0))).setMaxExtent(new Bounds().minx(Double.valueOf(91467.0)).miny(Double.valueOf(6496479.0)).maxx(Double.valueOf(1037043.0)).maxy(Double.valueOf(7147453.0))).setSettings(new AppSettings().uiSettings(new AppUiSettings().enable3D(Boolean.valueOf(true)))).setContentRoot(new AppContent().addBaseLayerNodesItem((AppTreeNode)new AppTreeLevelNode().objectType("AppTreeLevelNode").id("root-base-layers").root(Boolean.valueOf(true)).title("Base layers").childrenIds(List.of("lyr:pdok-hwh-luchtfotorgb:Actueel_orthoHR", "lyr:osm:xyz"))).addBaseLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:pdok-hwh-luchtfotorgb:Actueel_orthoHR").serviceId("pdok-hwh-luchtfotorgb").layerName("Actueel_orthoHR").visible(Boolean.valueOf(true))).addBaseLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:osm:xyz").serviceId("osm").layerName("xyz").visible(Boolean.valueOf(false))).addLayerNodesItem((AppTreeNode)new AppTreeLevelNode().objectType("AppTreeLevelNode").id("root").root(Boolean.valueOf(true)).title("Layers").childrenIds(List.of("lyr:3dbag_utrecht:tiles3d", "lyr:snapshot-geoserver:postgis:begroeidterreindeel", "lyr:3d_basisvoorziening_gebouwen_proxy:tiles3d", "lyr:3d_utrecht_proxied_auth:tiles3d"))).addLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:3dbag_utrecht:tiles3d").serviceId("3dbag_utrecht").layerName("tiles3d").visible(Boolean.valueOf(true))).addLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:3d_basisvoorziening_gebouwen_proxy:tiles3d").serviceId("3d_basisvoorziening_gebouwen_proxy").layerName("tiles3d").visible(Boolean.valueOf(false))).addLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:3d_utrecht_proxied_auth:tiles3d").serviceId("3d_utrecht_proxied_auth").layerName("tiles3d").visible(Boolean.valueOf(false))).addLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:snapshot-geoserver:postgis:begroeidterreindeel").serviceId("snapshot-geoserver").layerName("postgis:begroeidterreindeel").visible(Boolean.valueOf(true))).addTerrainLayerNodesItem((AppTreeNode)new AppTreeLevelNode().objectType("AppTreeLevelNode").id("root-terrain-layers").root(Boolean.valueOf(true)).title("Terrain Layers").childrenIds(List.of("lyr:ahn_terrain_model:quantizedmesh"))).addTerrainLayerNodesItem((AppTreeNode)new AppTreeLayerNode().objectType("AppTreeLayerNode").id("lyr:ahn_terrain_model:quantizedmesh").serviceId("ahn_terrain_model").layerName("quantizedmesh").visible(Boolean.valueOf(false))));
        this.applicationRepository.save((Object)app);
        Configuration config = new Configuration();
        config.setKey("default-app");
        config.setValue("default");
        this.configurationRepository.save((Object)config);
        config = new Configuration();
        config.setKey("default-base-app");
        config.setValue("base");
        this.configurationRepository.save((Object)config);
    }

    private void createConfigurationTestData() throws JsonProcessingException {
        Configuration config = new Configuration();
        config.setKey("test");
        config.setAvailableForViewer(true);
        config.setValue("test value");
        config.setJsonValue(new ObjectMapper().readTree("{ \"someProperty\": 1, \"nestedObject\": { \"num\": 42 } }"));
        this.configurationRepository.save((Object)config);
    }

    @Transactional
    public void createSolrIndex() throws Exception {
        if (this.connectToSpatialDbs) {
            this.featureSourceRepository.flush();
            logger.info("Creating Solr index");
            String solrUrl = "http://" + (this.connectToSpatialDbsAtLocalhost ? "127.0.0.1" : "solr") + ":8983/solr/";
            this.solrService.setSolrUrl(solrUrl);
            SolrHelper solrHelper = new SolrHelper(this.solrService.getSolrClientForIndexing()).withBatchSize(this.solrBatchSize).withGeometryValidationRule(this.solrGeometryValidationRule);
            GeoService geoService = (GeoService)this.geoServiceRepository.findById("snapshot-geoserver").orElseThrow();
            Application defaultApp = this.applicationRepository.findByName("default");
            TMFeatureType begroeidterreindeelFT = geoService.findFeatureTypeForLayer(geoService.findLayer("postgis:begroeidterreindeel"), this.featureSourceRepository);
            TMFeatureType wegdeelFT = geoService.findFeatureTypeForLayer(geoService.findLayer("sqlserver:wegdeel"), this.featureSourceRepository);
            TMFeatureType kadastraalPerceelFT = geoService.findFeatureTypeForLayer(geoService.findLayer("postgis:kadastraal_perceel"), this.featureSourceRepository);
            try (SolrHelper solrHelper2 = solrHelper;){
                AppTreeLayerNode wegdeel;
                AppTreeLayerNode kadastraalPerceelLayerNode;
                SearchIndex begroeidterreindeelIndex = null;
                if (begroeidterreindeelFT != null) {
                    begroeidterreindeelIndex = new SearchIndex().setName("Begroeidterreindeel").setFeatureTypeId(begroeidterreindeelFT.getId()).setSearchFieldsUsed(List.of("class", "plus_fysiekvoorkomen", "bronhouder")).setSearchDisplayFieldsUsed(List.of("class", "plus_fysiekvoorkomen"));
                    begroeidterreindeelIndex = (SearchIndex)this.searchIndexRepository.save((Object)begroeidterreindeelIndex);
                    begroeidterreindeelIndex = solrHelper.addFeatureTypeIndex(begroeidterreindeelIndex, begroeidterreindeelFT, this.featureSourceFactoryHelper, this.searchIndexRepository);
                    begroeidterreindeelIndex = (SearchIndex)this.searchIndexRepository.save((Object)begroeidterreindeelIndex);
                }
                SearchIndex kadastraalPerceelIndex = null;
                if (kadastraalPerceelFT != null) {
                    kadastraalPerceelIndex = new SearchIndex().setName("kadastraal_perceel").setFeatureTypeId(kadastraalPerceelFT.getId()).setSearchFieldsUsed(List.of("aanduiding")).setSearchDisplayFieldsUsed(List.of("aanduiding"));
                    kadastraalPerceelIndex = (SearchIndex)this.searchIndexRepository.save((Object)kadastraalPerceelIndex);
                    kadastraalPerceelIndex = solrHelper.addFeatureTypeIndex(kadastraalPerceelIndex, kadastraalPerceelFT, this.featureSourceFactoryHelper, this.searchIndexRepository);
                    kadastraalPerceelIndex = (SearchIndex)this.searchIndexRepository.save((Object)kadastraalPerceelIndex);
                }
                SearchIndex wegdeelIndex = null;
                if (wegdeelFT != null) {
                    wegdeelIndex = new SearchIndex().setName("Wegdeel").setFeatureTypeId(wegdeelFT.getId()).setSearchFieldsUsed(List.of("function_", "plus_fysiekvoorkomenwegdeel", "surfacematerial", "bronhouder")).setSearchDisplayFieldsUsed(List.of("function_", "plus_fysiekvoorkomenwegdeel"));
                    wegdeelIndex = (SearchIndex)this.searchIndexRepository.save((Object)wegdeelIndex);
                    wegdeelIndex = solrHelper.addFeatureTypeIndex(wegdeelIndex, wegdeelFT, this.featureSourceFactoryHelper, this.searchIndexRepository);
                    wegdeelIndex = (SearchIndex)this.searchIndexRepository.save((Object)wegdeelIndex);
                }
                this.featureSourceRepository.getByTitle("PostGIS").flatMap(fs -> fs.getFeatureTypes().stream().filter(ft -> ft.getName().equals("bak")).findFirst()).ifPresent(ft -> {
                    SearchIndex bak = new SearchIndex().setName("bak").setFeatureTypeId(ft.getId()).setSearchFieldsUsed(List.of("gmlid", "identificatie", "plus_type")).setSearchDisplayFieldsUsed(List.of("gmlid", "plus_type", "bronhouder"));
                    this.searchIndexRepository.save((Object)bak);
                    try {
                        bak = solrHelper.addFeatureTypeIndex(bak, ft, this.featureSourceFactoryHelper, this.searchIndexRepository);
                        this.searchIndexRepository.save((Object)bak);
                    }
                    catch (IOException | SolrServerException e) {
                        throw new RuntimeException(e);
                    }
                });
                this.featureSourceRepository.getByTitle("PostGIS OSM").flatMap(fs -> fs.getFeatureTypes().stream().filter(ft -> ft.getName().equals("osm_roads")).findFirst()).ifPresent(ft -> {
                    SearchIndex osm_no_pk = new SearchIndex().setName("osm_no_pk").setFeatureTypeId(ft.getId()).setSearchFieldsUsed(List.of("landuse", "osm_id", "natural", "boundary")).setSearchDisplayFieldsUsed(List.of("landuse", "osm_id", "natural", "amenity", "boundary"));
                    this.searchIndexRepository.save((Object)osm_no_pk);
                });
                AppTreeLayerNode begroeidTerreindeelLayerNode = defaultApp.getAllAppTreeLayerNode().filter(node -> node.getId().equals("lyr:snapshot-geoserver:postgis:begroeidterreindeel")).findFirst().orElse(null);
                if (begroeidTerreindeelLayerNode != null && begroeidterreindeelIndex != null) {
                    defaultApp.getAppLayerSettings(begroeidTerreindeelLayerNode).setSearchIndexId(begroeidterreindeelIndex.getId());
                }
                if ((kadastraalPerceelLayerNode = (AppTreeLayerNode)defaultApp.getAllAppTreeLayerNode().filter(node -> node.getId().equals("lyr:snapshot-geoserver:postgis:kadastraal_perceel")).findFirst().orElse(null)) != null && kadastraalPerceelIndex != null) {
                    defaultApp.getAppLayerSettings(kadastraalPerceelLayerNode).setSearchIndexId(kadastraalPerceelIndex.getId());
                }
                if ((wegdeel = (AppTreeLayerNode)defaultApp.getAllAppTreeLayerNode().filter(node -> node.getId().equals("lyr:snapshot-geoserver:sqlserver:wegdeel")).findFirst().orElse(null)) != null && wegdeelIndex != null) {
                    defaultApp.getAppLayerSettings(wegdeel).setSearchIndexId(wegdeelIndex.getId());
                }
                this.applicationRepository.save((Object)defaultApp);
            }
        }
    }

    private void createScheduledTasks() {
        try {
            logger.info("Creating POC tasks");
            logger.info("Created 15 minutely task with key: {}", (Object)this.taskManagerService.createTask(PocTask.class, new TMJobDataMap(Map.of("type", TaskType.POC.getValue(), "foo", "foobar", "description", "POC task that runs every 15 minutes")), "0 0/15 * 1/1 * ? *"));
            logger.info("Created hourly task with key: {}", (Object)this.taskManagerService.createTask(PocTask.class, new TMJobDataMap(Map.of("type", TaskType.POC.getValue(), "foo", "bar", "description", "POC task that runs every hour", "priority", 10)), "0 0 0/1 1/1 * ? *"));
            logger.info("Created hourly failing task with key: {}", (Object)this.taskManagerService.createTask(FailingPocTask.class, new TMJobDataMap(Map.of("type", TaskType.FAILINGPOC.getValue(), "description", "POC task that fails every hour with low priority", "priority", 100)), "0 0 0/1 1/1 * ? *"));
            logger.info("Created daily task with key: {}", (Object)this.taskManagerService.createTask(InterruptablePocTask.class, new TMJobDataMap(Map.of("type", TaskType.INTERRUPTABLEPOC.getValue(), "description", "Interruptable POC task that runs every 15 minutes", "priority", 5)), "0 0/15 * 1/1 * ? *"));
        }
        catch (SchedulerException e) {
            logger.error("Error creating scheduled one or more poc tasks", (Throwable)e);
        }
        if (this.categories.contains("search-index")) {
            logger.info("Creating INDEX tasks");
            List.of("Begroeidterreindeel", "kadastraal_perceel").forEach(name -> this.searchIndexRepository.findByName(name).ifPresent(index -> {
                index.setSchedule(new TaskSchedule().cronExpression("0 0 0/1 1/1 * ? *").description("Update Solr index \"" + name + "\" every hour"));
                try {
                    UUID uuid = this.taskManagerService.createTask(IndexTask.class, new TMJobDataMap(Map.of("type", TaskType.INDEX, "description", index.getSchedule().getDescription(), "indexId", index.getId().toString(), "priority", 10)), index.getSchedule().getCronExpression());
                    index.getSchedule().setUuid(uuid);
                    this.searchIndexRepository.save(index);
                    logger.info("Created task to update Solr index with key: {}", (Object)uuid);
                }
                catch (SchedulerException e) {
                    logger.error("Error creating scheduled solr index task", (Throwable)e);
                }
            }));
        }
    }

    private void createPages() throws IOException {
        Upload logo = new Upload().setCategory("portal-image").setFilename("gradient.svg").setMimeType("image/svg+xml").setContent(new ClassPathResource("test/gradient-logo.svg").getContentAsByteArray()).setLastModified(OffsetDateTime.now(ZoneId.systemDefault()));
        this.uploadRepository.save((Object)logo);
        Page about = new Page();
        about.setName("about");
        about.setType("page");
        about.setContent("About Tailormap");
        about.setContent("# About Tailormap\n\nThis is a page about *Tailormap*. It doesn't say much yet.\n");
        this.pageRepository.save((Object)about);
        Page page = new Page();
        page.setName("home");
        page.setType("page");
        page.setTitle("Tailormap - Home");
        page.setContent("# Welcome to Tailormap!\n\nThis page is only visible when you implement a frontend to display pages, or get it (including a simple CMS)\nfrom [B3Partners](https://www.b3partners.nl)!\n");
        page.setClassName(null);
        page.setTiles(List.of(new PageTile().id(UUID.randomUUID().toString()).title("Default app").applicationId((Long)Optional.ofNullable(this.applicationRepository.findByName("default")).map(Application::getId).orElse(null)).image(logo.getId().toString()).content("*Default app* tile content").filterRequireAuthorization(Boolean.valueOf(false)).openInNewWindow(Boolean.valueOf(false)), new PageTile().id(UUID.randomUUID().toString()).title("Secured app").applicationId((Long)Optional.ofNullable(this.applicationRepository.findByName("secured")).map(Application::getId).orElse(null)).filterRequireAuthorization(Boolean.valueOf(true)).content("Secure app, only shown if user has authorization").openInNewWindow(Boolean.valueOf(false)), new PageTile().id(UUID.randomUUID().toString()).title("Secured app (unfiltered)").applicationId((Long)Optional.ofNullable(this.applicationRepository.findByName("secured")).map(Application::getId).orElse(null)).filterRequireAuthorization(Boolean.valueOf(false)).content("Secure app, tile shown to everyone").openInNewWindow(Boolean.valueOf(false)), new PageTile().id(UUID.randomUUID().toString()).title("About").pageId(about.getId()).openInNewWindow(Boolean.valueOf(false)), new PageTile().id(UUID.randomUUID().toString()).title("B3Partners").url("https://www.b3partners.nl/").openInNewWindow(Boolean.valueOf(true))));
        this.pageRepository.save((Object)page);
        Configuration c = new Configuration();
        c.setKey("home-page");
        c.setValue(page.getId().toString());
        this.configurationRepository.save((Object)c);
        List<MenuItem> globalMenuItems = List.of(new MenuItem().pageId(about.getId()).label("About").openInNewWindow(Boolean.valueOf(false)), new MenuItem().label("B3Partners website").url("https://www.b3partners.nl/").openInNewWindow(Boolean.valueOf(true)).exclusiveOnPageId(about.getId()));
        c = new Configuration();
        c.setKey("portal-menu");
        c.setJsonValue(new ObjectMapper().valueToTree(globalMenuItems));
        this.configurationRepository.save((Object)c);
    }

    private void insertTestDrawing() {
        try {
            this.jdbcClient.sql("INSERT INTO data.drawing (id,name,description,domain_data,\"access\",created_by,created_at,updated_by,updated_at,srid,\"version\") VALUES\n('38faa008-013e-49d4-9528-8f58c94d8791'::uuid,'Testcase','A private access drawing that is inserted as part of the testdata','{\"items\": 1, \"domain\": \"test drawings\"}','private','tm-admin','2025-02-27 17:53:36.095164+01','tm-admin','2025-02-27 17:54:19.384961+01',28992,1);\n").update();
            this.jdbcClient.sql("INSERT INTO data.drawing_feature (drawing_id,id,geometry,properties) VALUES\n('38faa008-013e-49d4-9528-8f58c94d8791'::uuid, '394e0d4a-b374-4d00-94c8-1758ea70e9d9'::uuid, 'SRID=28992;POLYGON ((131982.01 458929.27, 131957.31 458755.45, 132072.39 458736.69, 132099.06 458910.51, 131982.01 458929.27))'::public.geometry, '{\"type\": \"POLYGON\", \"style\": {\"label\": \"\", \"marker\": \"circle\", \"fillColor\": \"rgb(117, 117, 117)\", \"labelSize\": 15, \"labelColor\": \"rgb(0, 0, 0)\", \"markerSize\": 5, \"fillOpacity\": 30, \"strokeColor\": \"rgb(98, 54, 255)\", \"strokeWidth\": 3, \"strokeOpacity\": 100, \"markerRotation\": 0, \"markerFillColor\": \"rgb(98, 54, 255)\", \"labelOutlineColor\": \"rgb(189, 189, 189)\", \"markerStrokeColor\": \"rgb(98, 54, 255)\", \"markerStrokeWidth\": 1}}'::jsonb),\n('38faa008-013e-49d4-9528-8f58c94d8791'::uuid, '89fc320c-41a3-4635-8d98-39d822339692'::uuid, 'SRID=28992;POINT (131897.55 458971.24)'::public.geometry, '{\"type\": \"CIRCLE\", \"style\": {\"label\": \"CIRCLE\", \"marker\": \"circle\", \"fillColor\": \"rgb(117, 117, 117)\", \"labelSize\": 15, \"labelColor\": \"rgb(0, 0, 0)\", \"markerSize\": 5, \"fillOpacity\": 30, \"strokeColor\": \"rgb(98, 54, 255)\", \"strokeWidth\": 3, \"strokeOpacity\": 100, \"markerRotation\": 0, \"markerFillColor\": \"rgb(98, 54, 255)\", \"labelOutlineColor\": \"rgb(189, 189, 189)\", \"markerStrokeColor\": \"rgb(98, 54, 255)\", \"markerStrokeWidth\": 1}, \"radius\": 14.989999999990687}'::jsonb),\n('38faa008-013e-49d4-9528-8f58c94d8791'::uuid, '5d6252cc-25b6-4a43-9053-0779b86895a7'::uuid, 'SRID=28992;LINESTRING (131920.76 458754.96, 131923.73 458783.1, 131930.15 458793.97, 131945.95 458912.98, 131967.68 458946.06)'::public.geometry, '{\"type\": \"LINE\", \"style\": {\"label\": \"\", \"marker\": \"circle\", \"fillColor\": \"rgb(255, 82, 82)\", \"labelSize\": 15, \"labelColor\": \"rgb(0, 0, 0)\", \"markerSize\": 5, \"fillOpacity\": 30, \"strokeColor\": \"rgb(255, 82, 82)\", \"strokeWidth\": 13, \"strokeOpacity\": 100, \"markerRotation\": 0, \"markerFillColor\": \"rgb(98, 54, 255)\", \"labelOutlineColor\": \"rgb(189, 189, 189)\", \"markerStrokeColor\": \"rgb(98, 54, 255)\", \"markerStrokeWidth\": 1}}'::jsonb)\n").update();
        }
        catch (Exception any) {
            logger.error("Error inserting test drawing in data schema, some tests may fail", (Throwable)any);
        }
    }

    private void insertDrawingStyle() throws IOException {
        Upload upload = new Upload().setCategory("drawing-style-image").setMimeType("image/svg+xml").setFilename("ISO_7001_PI_PF_007.svg").setContent(new ClassPathResource("test/ISO_7001_PI_PF_007.svg").getContentAsByteArray()).setLastModified(OffsetDateTime.now(ZoneId.systemDefault()));
        upload = (Upload)this.uploadRepository.save((Object)upload);
        UUID drinkwaterImageId = upload.getId();
        upload = new Upload().setCategory("drawing-style-image").setMimeType("image/svg+xml").setFilename("lichtpunt.svg").setContent(new ClassPathResource("test/lichtpunt.svg").getContentAsByteArray()).setLastModified(OffsetDateTime.now(ZoneId.systemDefault()));
        upload = (Upload)this.uploadRepository.save((Object)upload);
        UUID lichtpuntImageId = upload.getId();
        upload = new Upload().setCategory("drawing-style-image").setMimeType("image/svg+xml").setFilename("ISO_7010_E003_-_First_aid_sign.svg").setContent(new ClassPathResource("test/ISO_7010_E003_-_First_aid_sign.svg").getContentAsByteArray()).setLastModified(OffsetDateTime.now(ZoneId.systemDefault()));
        upload = (Upload)this.uploadRepository.save((Object)upload);
        UUID firstAidImageId = upload.getId();
        Properties props = new Properties();
        props.putAll(Map.of("water-uuid", drinkwaterImageId.toString(), "lichtpunt-uuid", lichtpuntImageId.toString(), "first-aid-uuid", firstAidImageId.toString()));
        String drawingStyles = new ClassPathResource("test/object-drawing-style.json").getContentAsString(StandardCharsets.UTF_8);
        drawingStyles = new PropertyPlaceholderHelper("${", "}").replacePlaceholders(drawingStyles, props);
        upload = new Upload().setCategory("drawing-style").setMimeType("application/json").setFilename("object-drawing-style.json").setContent(drawingStyles.getBytes(StandardCharsets.UTF_8)).setLastModified(OffsetDateTime.now(ZoneId.systemDefault()));
        this.uploadRepository.save((Object)upload);
    }
}

