/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.security;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.tailormap.api.persistence.Group;
import org.tailormap.api.persistence.User;
import org.tailormap.api.repository.GroupRepository;
import org.tailormap.api.security.TailormapUserDetails;

public class TailormapUserDetails
implements UserDetails {
    private static final long serialVersionUID = 2L;
    private final Collection<GrantedAuthority> authorities;
    private final String username;
    private final String password;
    private final ZonedDateTime validUntil;
    private final boolean enabled;
    private final List<UDAdditionalProperty> additionalProperties = new ArrayList();
    private final List<UDAdditionalProperty> additionalGroupProperties = new ArrayList();

    public TailormapUserDetails(User user, GroupRepository groupRepository) {
        this.authorities = new HashSet();
        user.getGroups().stream().map(Group::getName).map(SimpleGrantedAuthority::new).forEach(this.authorities::add);
        user.getGroups().stream().map(Group::getAliasForGroup).filter(StringUtils::isNotBlank).map(SimpleGrantedAuthority::new).forEach(this.authorities::add);
        this.username = user.getUsername();
        this.password = user.getPassword();
        this.validUntil = user.getValidUntil();
        this.enabled = user.isEnabled();
        user.getAdditionalProperties().stream().map(p -> new UDAdditionalProperty(p.getKey(), p.getIsPublic(), p.getValue())).forEach(this.additionalProperties::add);
        groupRepository.findAllById(this.authorities.stream().map(GrantedAuthority::getAuthority).toList()).stream().map(Group::getAdditionalProperties).filter(Objects::nonNull).flatMap(Collection::stream).map(p -> new UDAdditionalProperty(p.getKey(), p.getIsPublic(), p.getValue())).forEach(this.additionalGroupProperties::add);
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAccountNonExpired() {
        return this.validUntil == null || this.validUntil.isAfter(ZonedDateTime.now(ZoneId.systemDefault()));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<UDAdditionalProperty> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public List<UDAdditionalProperty> getAdditionalGroupProperties() {
        return this.additionalGroupProperties;
    }

    public boolean getBooleanUserProperty(String key) {
        return this.additionalProperties.stream().filter(p -> p.key.equals(key)).map(UDAdditionalProperty::value).map("true"::equals).findFirst().orElse(false);
    }
}

