/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.springframework.format.annotation.DateTimeFormat;
import org.tailormap.api.viewer.model.Drawing;

@Schema(name="Drawing", description="A drawing is a collection of features (modeled as a GeoJSON FeatureCollection) and some metadata.")
public class Drawing
implements Serializable {
    private static final long serialVersionUID = 1L;
    private UUID id;
    private String name;
    private String description;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime createdAt;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime updatedAt;
    private String createdBy;
    private String updatedBy;
    private Integer version = 0;
    private AccessEnum access = AccessEnum.PRIVATE;
    @Valid
    private Map<String, Object> domainData;
    private Integer srid;
    private Object featureCollection = null;

    public Drawing id(UUID id) {
        this.id = id;
        return this;
    }

    @Valid
    @Schema(name="id", accessMode=Schema.AccessMode.READ_ONLY, example="a73ac8ee-1d64-44be-a05e-b6426e2c1c59", description="Unique identifier of the drawing. Generated by the backend.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="id")
    public UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public Drawing name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Schema(name="name", description="A user provided, identifying name of the drawing.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Drawing description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="A description of the drawing.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Drawing createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Valid
    @Schema(name="createdAt", accessMode=Schema.AccessMode.READ_ONLY, example="2024-12-12T16:02:34.587142504+01:00", description="Creation date of the drawing as a Zoned date-time.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="createdAt")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public Drawing updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Valid
    @Schema(name="updatedAt", accessMode=Schema.AccessMode.READ_ONLY, example="2024-12-12T16:02:34.587142504+01:00", description="Last update date of the drawing as a Zoned date-time.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="updatedAt")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Drawing createdBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @Schema(name="createdBy", accessMode=Schema.AccessMode.READ_ONLY, description="User that created the drawing.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="createdBy")
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Drawing updatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
        return this;
    }

    @Schema(name="updatedBy", accessMode=Schema.AccessMode.READ_ONLY, description="User that last saved the drawing.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="updatedBy")
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public Drawing version(Integer version) {
        this.version = version;
        return this;
    }

    @Schema(name="version", description="Version of the drawing.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Drawing access(AccessEnum access) {
        this.access = access;
        return this;
    }

    @NotNull
    @Schema(name="access", description="Access level of the drawing, defaults to private.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="access")
    public AccessEnum getAccess() {
        return this.access;
    }

    public void setAccess(AccessEnum access) {
        this.access = access;
    }

    public Drawing domainData(Map<String, Object> domainData) {
        this.domainData = domainData;
        return this;
    }

    public Drawing putDomainDataItem(String key, Object domainDataItem) {
        if (this.domainData == null) {
            this.domainData = new HashMap();
        }
        this.domainData.put(key, domainDataItem);
        return this;
    }

    @Schema(name="domainData", description="Domain specific data, can be used to store additional data.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="domainData")
    public Map<String, Object> getDomainData() {
        return this.domainData;
    }

    public void setDomainData(Map<String, Object> domainData) {
        this.domainData = domainData;
    }

    public Drawing srid(Integer srid) {
        this.srid = srid;
        return this;
    }

    @Schema(name="srid", accessMode=Schema.AccessMode.READ_ONLY, description="The EPSG SRID code of the drawing's features, defaults to the SRID of the application.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="srid")
    public Integer getSrid() {
        return this.srid;
    }

    public void setSrid(Integer srid) {
        this.srid = srid;
    }

    public Drawing featureCollection(Object featureCollection) {
        this.featureCollection = featureCollection;
        return this;
    }

    @Schema(name="featureCollection", description=" Features of the drawing, as a GeoJSON FeatureCollection. The collection is projected to the SRID of the application that the drawing was last edited in. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="featureCollection")
    public Object getFeatureCollection() {
        return this.featureCollection;
    }

    public void setFeatureCollection(Object featureCollection) {
        this.featureCollection = featureCollection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Drawing drawing = (Drawing)o;
        return Objects.equals(this.id, drawing.id) && Objects.equals(this.name, drawing.name) && Objects.equals(this.description, drawing.description) && Objects.equals(this.createdAt, drawing.createdAt) && Objects.equals(this.updatedAt, drawing.updatedAt) && Objects.equals(this.createdBy, drawing.createdBy) && Objects.equals(this.updatedBy, drawing.updatedBy) && Objects.equals(this.version, drawing.version) && Objects.equals(this.access, drawing.access) && Objects.equals(this.domainData, drawing.domainData) && Objects.equals(this.srid, drawing.srid) && Objects.equals(this.featureCollection, drawing.featureCollection);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.createdAt, this.updatedAt, this.createdBy, this.updatedBy, this.version, this.access, this.domainData, this.srid, this.featureCollection);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Drawing {\n");
        sb.append("    id: ").append(this.toIndentedString((Object)this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString((Object)this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString((Object)this.description)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString((Object)this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString((Object)this.updatedAt)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString((Object)this.createdBy)).append("\n");
        sb.append("    updatedBy: ").append(this.toIndentedString((Object)this.updatedBy)).append("\n");
        sb.append("    version: ").append(this.toIndentedString((Object)this.version)).append("\n");
        sb.append("    access: ").append(this.toIndentedString((Object)this.access)).append("\n");
        sb.append("    domainData: ").append(this.toIndentedString((Object)this.domainData)).append("\n");
        sb.append("    srid: ").append(this.toIndentedString((Object)this.srid)).append("\n");
        sb.append("    featureCollection: ").append(this.toIndentedString(this.featureCollection)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

