package org.tailormap.api.admin.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.lang.Nullable;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * Task progress event. This event is sent when a _running_ task makes progress, including start/stop. The fraction of the task that is done can be computed using &#x60;progress&#x60; and &#x60;total&#x60; (if not null).
 */

@Schema(name = "TaskProgressEvent", description = "Task progress event. This event is sent when a _running_ task makes progress, including start/stop. The fraction of the task that is done can be computed using `progress` and `total` (if not null).")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.15.0")
public class TaskProgressEvent implements Serializable {

  private static final long serialVersionUID = 1L;

  private String type;

  private UUID uuid;

  private Integer total = null;

  private Integer progress = 0;

  @DateTimeFormat(iso = DateTimeFormat.ISO.DATE_TIME)
  private OffsetDateTime startedAt = null;

  @Valid
  private Map<String, Object> taskData;

  public TaskProgressEvent() {
    super();
  }

  public TaskProgressEvent type(String type) {
    this.type = type;
    return this;
  }

  /**
   * Type of the task.
   * @return type
   */
  @NotNull 
  @Schema(name = "type", example = "index", description = "Type of the task.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("type")
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public TaskProgressEvent uuid(UUID uuid) {
    this.uuid = uuid;
    return this;
  }

  /**
   * UUID of the task; this, combined with type, is used to uniquely identify the task.
   * @return uuid
   */
  @NotNull @Valid 
  @Schema(name = "uuid", description = "UUID of the task; this, combined with type, is used to uniquely identify the task.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("uuid")
  public UUID getUuid() {
    return uuid;
  }

  public void setUuid(UUID uuid) {
    this.uuid = uuid;
  }

  public TaskProgressEvent total(Integer total) {
    this.total = total;
    return this;
  }

  /**
   * Total number of items to process. May be `null` or empty if unknown.
   * @return total
   */
  
  @Schema(name = "total", example = "1200", description = "Total number of items to process. May be `null` or empty if unknown.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("total")
  public Integer getTotal() {
    return total;
  }

  public void setTotal(Integer total) {
    this.total = total;
  }

  public TaskProgressEvent progress(Integer progress) {
    this.progress = progress;
    return this;
  }

  /**
   * Number of items processed so far.
   * @return progress
   */
  @NotNull 
  @Schema(name = "progress", example = "113", description = "Number of items processed so far.", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("progress")
  public Integer getProgress() {
    return progress;
  }

  public void setProgress(Integer progress) {
    this.progress = progress;
  }

  public TaskProgressEvent startedAt(OffsetDateTime startedAt) {
    this.startedAt = startedAt;
    return this;
  }

  /**
   * Zoned date-time when the task started.
   * @return startedAt
   */
  @Valid 
  @Schema(name = "startedAt", example = "2024-12-12T16:02:34.587142504+01:00", description = "Zoned date-time when the task started.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("startedAt")
  public OffsetDateTime getStartedAt() {
    return startedAt;
  }

  public void setStartedAt(OffsetDateTime startedAt) {
    this.startedAt = startedAt;
  }

  public TaskProgressEvent taskData(Map<String, Object> taskData) {
    this.taskData = taskData;
    return this;
  }

  public TaskProgressEvent putTaskDataItem(String key, Object taskDataItem) {
    if (this.taskData == null) {
      this.taskData = new HashMap<>();
    }
    this.taskData.put(key, taskDataItem);
    return this;
  }

  /**
   * Additional data for the task.
   * @return taskData
   */
  
  @Schema(name = "taskData", example = "{\"index\":1}", description = "Additional data for the task.", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("taskData")
  public Map<String, Object> getTaskData() {
    return taskData;
  }

  public void setTaskData(Map<String, Object> taskData) {
    this.taskData = taskData;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TaskProgressEvent taskProgressEvent = (TaskProgressEvent) o;
    return Objects.equals(this.type, taskProgressEvent.type) &&
        Objects.equals(this.uuid, taskProgressEvent.uuid) &&
        Objects.equals(this.total, taskProgressEvent.total) &&
        Objects.equals(this.progress, taskProgressEvent.progress) &&
        Objects.equals(this.startedAt, taskProgressEvent.startedAt) &&
        Objects.equals(this.taskData, taskProgressEvent.taskData);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, uuid, total, progress, startedAt, taskData);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TaskProgressEvent {\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    progress: ").append(toIndentedString(progress)).append("\n");
    sb.append("    startedAt: ").append(toIndentedString(startedAt)).append("\n");
    sb.append("    taskData: ").append(toIndentedString(taskData)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

