/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.controller;

import io.micrometer.core.annotation.Timed;
import jakarta.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;
import org.tailormap.api.annotation.AppRestController;
import org.tailormap.api.persistence.Application;
import org.tailormap.api.persistence.GeoService;
import org.tailormap.api.persistence.helper.GeoServiceHelper;
import org.tailormap.api.persistence.json.GeoServiceLayer;
import org.tailormap.api.persistence.json.GeoServiceProtocol;
import org.tailormap.api.persistence.json.ServiceAuthentication;
import org.tailormap.api.security.AuthorisationService;
import org.tailormap.api.util.HttpProxyUtil;

@AppRestController
@Validated
@RequestMapping(path={"/api/{viewerKind}/{viewerName}/layer/{appLayerId}/proxy"})
public class GeoServiceProxyController {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final AuthorisationService authorisationService;
    public static final String TILES3D_DESCRIPTION_PATH = "tiles3dDescription";

    public GeoServiceProxyController(AuthorisationService authorisationService) {
        this.authorisationService = authorisationService;
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST}, path={"/tiles3d/**"})
    public ResponseEntity<?> proxy3dtiles(@ModelAttribute Application application, @ModelAttribute GeoService service, @ModelAttribute GeoServiceLayer layer, HttpServletRequest request) {
        this.checkRequestValidity(application, service, layer, GeoServiceProtocol.TILES3D);
        return GeoServiceProxyController.doProxy(this.build3DTilesUrl(service, request), service, request);
    }

    @RequestMapping(method={RequestMethod.GET, RequestMethod.POST}, path={"/{protocol}"})
    @Timed(value="proxy", description="Proxy OGC service calls")
    public ResponseEntity<?> proxy(@ModelAttribute Application application, @ModelAttribute GeoService service, @ModelAttribute GeoServiceLayer layer, @PathVariable(value="protocol") GeoServiceProtocol protocol, HttpServletRequest request) {
        this.checkRequestValidity(application, service, layer, protocol);
        switch (protocol) {
            case WMS: 
            case WMTS: {
                return GeoServiceProxyController.doProxy(this.buildWMSUrl(service, request), service, request);
            }
            case LEGEND: {
                URI legendURI = this.buildLegendURI(service, layer, request);
                if (legendURI == null) {
                    logger.warn("No legend URL found for layer {}", (Object)layer.getName());
                    return null;
                }
                return GeoServiceProxyController.doProxy(legendURI, service, request);
            }
            case TILES3D: {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Incorrect 3D Tiles proxy request: No path to capabilities or content");
            }
        }
        throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Unsupported proxy protocol: " + String.valueOf(protocol));
    }

    private void checkRequestValidity(Application application, GeoService service, GeoServiceLayer layer, GeoServiceProtocol protocol) {
        if (service == null || layer == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        if (GeoServiceProtocol.XYZ.equals(protocol)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_IMPLEMENTED, "XYZ proxying not implemented");
        }
        if (!service.getProtocol().equals(protocol) && !GeoServiceProtocol.LEGEND.equals(protocol)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Invalid proxy protocol: " + String.valueOf(protocol));
        }
        if (!service.getSettings().getUseProxy().booleanValue()) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN, "Proxy not enabled for requested service");
        }
        if (this.authorisationService.mustDenyAccessForSecuredProxy(service)) {
            logger.debug("Denying proxy for layer \"{}\" in app #{} (\"{}\") from secured service #{} (URL {}): user is not authenticated", new Object[]{layer.getName(), application.getId(), application.getName(), service.getId(), service.getUrl()});
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
    }

    @Nullable
    private URI buildLegendURI(GeoService service, GeoServiceLayer layer, HttpServletRequest request) {
        URI legendURI = GeoServiceHelper.getLayerLegendUrlFromStyles(service, layer);
        if (legendURI == null) {
            return null;
        }
        String wmsRequest = GeoServiceHelper.getWmsRequest(legendURI);
        if (!"getlegendgraphic".equalsIgnoreCase(wmsRequest)) {
            return legendURI;
        }
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUri((URI)legendURI);
        if (request.getParameterMap() != null) {
            request.getParameterMap().forEach((key, values) -> {
                for (String value : values) {
                    uriComponentsBuilder.replaceQueryParam(key, new Object[]{UriUtils.encode((String)value, (Charset)StandardCharsets.UTF_8)});
                }
            });
        }
        uriComponentsBuilder.replaceQueryParam("REQUEST", new Object[]{"GetLegendGraphic"});
        return uriComponentsBuilder.build(true).toUri();
    }

    private URI buildWMSUrl(GeoService service, HttpServletRequest request) {
        UriComponentsBuilder originalServiceUrl = UriComponentsBuilder.fromUriString((String)service.getUrl());
        MultiValueMap requestParams = (MultiValueMap)request.getParameterMap().entrySet().stream().map(entry -> new AbstractMap.SimpleEntry((String)entry.getKey(), Arrays.stream((String[])entry.getValue()).map(value -> UriUtils.encode((String)value, (Charset)StandardCharsets.UTF_8)).collect(Collectors.toList()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (x, y) -> y, LinkedMultiValueMap::new));
        MultiValueMap<String, String> params = GeoServiceProxyController.buildOgcProxyRequestParams((MultiValueMap<String, String>)originalServiceUrl.build(true).getQueryParams(), (MultiValueMap<String, String>)requestParams);
        originalServiceUrl.replaceQueryParams(params);
        return originalServiceUrl.build(true).toUri();
    }

    public static MultiValueMap<String, String> buildOgcProxyRequestParams(MultiValueMap<String, String> originalServiceParams, MultiValueMap<String, String> requestParams) {
        LinkedMultiValueMap params = new LinkedMultiValueMap(requestParams);
        List<String> ogcParams = List.of(new String[]{"SERVICE", "REQUEST", "VERSION"});
        for (Map.Entry serviceParam : originalServiceParams.entrySet()) {
            if (params.containsKey(serviceParam.getKey()) || ogcParams.contains(((String)serviceParam.getKey()).toUpperCase(Locale.ROOT))) continue;
            params.put((Object)((String)serviceParam.getKey()), (Object)((List)serviceParam.getValue()));
        }
        return params;
    }

    private URI build3DTilesUrl(GeoService service, HttpServletRequest request) {
        UriComponentsBuilder originalServiceUrl = UriComponentsBuilder.fromUriString((String)service.getUrl());
        String baseUrl = originalServiceUrl.build(true).toUriString();
        String pathToContent = request.getRequestURI().split("/proxy/tiles3d/", 2)[1];
        if (Objects.equals(pathToContent, TILES3D_DESCRIPTION_PATH)) {
            return UriComponentsBuilder.fromUriString((String)baseUrl).build(true).toUri();
        }
        int lastSlashIndex = baseUrl.lastIndexOf(47);
        if (lastSlashIndex != -1) {
            baseUrl = baseUrl.substring(0, lastSlashIndex + 1);
        }
        String finalUrl = baseUrl + pathToContent;
        return UriComponentsBuilder.fromUriString((String)finalUrl).build(true).toUri();
    }

    private static ResponseEntity<?> doProxy(URI uri, GeoService service, HttpServletRequest request) {
        HttpClient.Builder builder = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL);
        HttpClient httpClient = builder.build();
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(uri);
        HttpProxyUtil.addForwardedForRequestHeaders(requestBuilder, request);
        HttpProxyUtil.passthroughRequestHeaders(requestBuilder, request, Set.of("Accept", "If-Modified-Since", "If-Unmodified-Since", "If-Match", "If-None-Match", "If-Range", "Range", "Referer", "User-Agent"));
        if (service.getAuthentication() != null && service.getAuthentication().getMethod() == ServiceAuthentication.MethodEnum.PASSWORD) {
            HttpProxyUtil.setHttpBasicAuthenticationHeader(requestBuilder, service.getAuthentication().getUsername(), service.getAuthentication().getPassword());
        }
        try {
            HttpResponse<InputStream> response = httpClient.send(requestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
            InputStreamResource body = new InputStreamResource(response.body());
            HttpHeaders headers = HttpProxyUtil.passthroughResponseHeaders(response.headers(), Set.of("Content-Type", "Content-Length", "Content-Range", "Content-Disposition", "Cache-Control", "Expires", "Last-Modified", "ETag", "Pragma"));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((int)response.statusCode()).headers(headers)).body((Object)body);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_GATEWAY).body((Object)"Bad Gateway");
        }
    }
}

