/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.geotools;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.commons.io.input.TeeInputStream;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPResponse;

public class ResponseTeeingHTTPClient
implements HTTPClient {
    private TeeHTTPResponseWrapper responseWrapper;
    private final HTTPClient wrapped;
    private final BiConsumer<URL, TeeHTTPResponseWrapper> requestConsumer;
    private final Set<String> responseHeadersToCache;

    public ResponseTeeingHTTPClient(HTTPClient wrapped) {
        this(wrapped, null, null);
    }

    public ResponseTeeingHTTPClient(HTTPClient wrapped, BiConsumer<URL, TeeHTTPResponseWrapper> requestConsumer, Set<String> responseHeadersToCache) {
        this.wrapped = wrapped;
        this.requestConsumer = requestConsumer == null ? (url, response) -> {} : requestConsumer;
        this.responseHeadersToCache = responseHeadersToCache == null ? Collections.emptySet() : responseHeadersToCache;
    }

    public HTTPResponse get(URL url, Map<String, String> headers) throws IOException {
        this.responseWrapper = new TeeHTTPResponseWrapper(this.wrapped.get(url, headers));
        this.requestConsumer.accept(url, this.responseWrapper);
        return this.responseWrapper;
    }

    public HTTPResponse post(URL url, InputStream inputStream, String s) throws IOException {
        this.responseWrapper = new TeeHTTPResponseWrapper(this.wrapped.post(url, inputStream, s));
        this.requestConsumer.accept(url, this.responseWrapper);
        return this.responseWrapper;
    }

    public HTTPResponse get(URL url) throws IOException {
        this.responseWrapper = new TeeHTTPResponseWrapper(this.wrapped.get(url));
        this.requestConsumer.accept(url, this.responseWrapper);
        return this.responseWrapper;
    }

    public HTTPResponse getLatestResponse() {
        return this.responseWrapper;
    }

    public byte[] getLatestResponseCopy() {
        return this.responseWrapper == null ? null : this.responseWrapper.getCopy();
    }

    public String getUser() {
        return this.wrapped.getUser();
    }

    public void setUser(String user) {
        this.wrapped.setUser(user);
    }

    public String getPassword() {
        return this.wrapped.getPassword();
    }

    public void setPassword(String password) {
        this.wrapped.setPassword(password);
    }

    public Map<String, String> getExtraParams() {
        return this.wrapped.getExtraParams();
    }

    public void setExtraParams(Map<String, String> extraParams) {
        this.wrapped.setExtraParams(extraParams);
    }

    public int getConnectTimeout() {
        return this.wrapped.getConnectTimeout();
    }

    public void setConnectTimeout(int connectTimeout) {
        this.wrapped.setConnectTimeout(connectTimeout);
    }

    public int getReadTimeout() {
        return this.wrapped.getReadTimeout();
    }

    public void setReadTimeout(int readTimeout) {
        this.wrapped.setReadTimeout(readTimeout);
    }

    public void setTryGzip(boolean tryGZIP) {
        this.wrapped.setTryGzip(tryGZIP);
    }

    public boolean isTryGzip() {
        return this.wrapped.isTryGzip();
    }

    public class TeeHTTPResponseWrapper
    implements HTTPResponse {
        private final HTTPResponse wrapped;
        private boolean disposed = false;
        private final ByteArrayOutputStream copy = new ByteArrayOutputStream();
        private String contentType;
        private final Map<String, String> cachedResponseHeaders = new HashMap<String, String>();

        public TeeHTTPResponseWrapper(HTTPResponse wrapped) {
            this.wrapped = wrapped;
        }

        public byte[] getCopy() {
            return this.copy.toByteArray();
        }

        public void dispose() {
            this.disposed = true;
            this.wrapped.dispose();
        }

        public boolean isDisposed() {
            return this.disposed;
        }

        public String getContentType() {
            if (this.contentType == null) {
                this.contentType = this.wrapped.getContentType();
            }
            return this.contentType;
        }

        public String getResponseHeader(String header) {
            if (this.cachedResponseHeaders.containsKey(header)) {
                return this.cachedResponseHeaders.get(header);
            }
            if (this.isDisposed()) {
                return null;
            }
            return this.wrapped.getResponseHeader(header);
        }

        public InputStream getResponseStream() throws IOException {
            for (String header : ResponseTeeingHTTPClient.this.responseHeadersToCache) {
                this.cachedResponseHeaders.put(header, this.wrapped.getResponseHeader(header));
            }
            return new TeeInputStream(this.wrapped.getResponseStream(), (OutputStream)this.copy);
        }

        public String getResponseCharset() {
            return this.wrapped.getResponseCharset();
        }
    }
}

