/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.solr;

import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Positive;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BaseHttpSolrClient;
import org.apache.solr.client.solrj.request.schema.FieldTypeDefinition;
import org.apache.solr.client.solrj.request.schema.SchemaRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.client.solrj.response.schema.SchemaResponse;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.tailormap.api.admin.model.SearchIndexSummary;
import org.tailormap.api.admin.model.TaskProgressEvent;
import org.tailormap.api.geotools.featuresources.FeatureSourceFactoryHelper;
import org.tailormap.api.geotools.processing.GeometryProcessor;
import org.tailormap.api.persistence.SearchIndex;
import org.tailormap.api.persistence.TMFeatureType;
import org.tailormap.api.repository.SearchIndexRepository;
import org.tailormap.api.scheduling.TaskType;
import org.tailormap.api.solr.FeatureIndexingDocument;
import org.tailormap.api.util.Constants;
import org.tailormap.api.viewer.model.SearchDocument;
import org.tailormap.api.viewer.model.SearchResponse;

public class SolrHelper
implements AutoCloseable,
Constants {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String SOLR_SPATIAL_FIELDNAME = "tm_geometry_rpt";
    private final SolrClient solrClient;
    private final Map<String, SchemaRequest.AddField> solrSearchFields = Map.of("searchLayer", new SchemaRequest.AddField(Map.of("name", "searchLayer", "type", "string", "indexed", true, "stored", true, "multiValued", false, "required", true, "uninvertible", false)), "geometry", new SchemaRequest.AddField(Map.of("name", "geometry", "type", "tm_geometry_rpt", "stored", true)), "searchFields", new SchemaRequest.AddField(Map.of("name", "searchFields", "type", "text_general", "indexed", true, "stored", true, "multiValued", true, "required", true, "uninvertible", false)), "displayFields", new SchemaRequest.AddField(Map.of("name", "displayFields", "type", "text_general", "indexed", false, "stored", true, "multiValued", true, "required", true, "uninvertible", false)));
    private int solrQueryTimeout = 7000;
    private int solrBatchSize = 1000;
    private String solrGeometryValidationRule = "repairBuffer0";

    public SolrHelper(@NotNull SolrClient solrClient) {
        this.solrClient = solrClient;
    }

    public SolrHelper withQueryTimeout(@Positive(message="Must use a positive integer for query timeout") @Positive(message="Must use a positive integer for query timeout") int solrQueryTimeout) {
        this.solrQueryTimeout = solrQueryTimeout * 1000;
        return this;
    }

    public SolrHelper withBatchSize(@Positive(message="Must use a positive integer for batching") @Positive(message="Must use a positive integer for batching") int solrBatchSize) {
        this.solrBatchSize = solrBatchSize;
        return this;
    }

    public SolrHelper withGeometryValidationRule(@NonNull String solrGeometryValidationRule) {
        if (List.of("error", "none", "repairBuffer0", "repairConvexHull").contains(solrGeometryValidationRule)) {
            logger.trace("Setting geometry validation rule for Solr geometry field to {}", (Object)solrGeometryValidationRule);
            this.solrGeometryValidationRule = solrGeometryValidationRule;
        }
        return this;
    }

    public SearchIndex addFeatureTypeIndex(@NotNull SearchIndex searchIndex, @NotNull TMFeatureType tmFeatureType, @NotNull FeatureSourceFactoryHelper featureSourceFactoryHelper, @NotNull SearchIndexRepository searchIndexRepository) throws IOException, SolrServerException {
        Consumer<TaskProgressEvent> progressListener = event -> logger.debug("Progress event: {}", event);
        return this.addFeatureTypeIndex(searchIndex, tmFeatureType, featureSourceFactoryHelper, searchIndexRepository, progressListener, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchIndex addFeatureTypeIndex(@NotNull SearchIndex searchIndex, @NotNull TMFeatureType tmFeatureType, @NotNull FeatureSourceFactoryHelper featureSourceFactoryHelper, @NotNull SearchIndexRepository searchIndexRepository, @NotNull Consumer<TaskProgressEvent> progressListener, @Nullable UUID taskUuid) throws IOException, SolrServerException {
        UpdateResponse updateResponse;
        this.createSchemaIfNotExists();
        Instant startedAt = Instant.now();
        OffsetDateTime startedAtOffset = startedAt.atOffset(ZoneId.systemDefault().getRules().getOffset(startedAt));
        if (null == taskUuid && null != searchIndex.getSchedule()) {
            taskUuid = searchIndex.getSchedule().getUuid();
        }
        SearchIndexSummary summary = new SearchIndexSummary().startedAt(startedAtOffset).total(0).duration(0.0);
        if (null == searchIndex.getSearchFieldsUsed()) {
            logger.warn("No search fields configured for search index: {}, skipping index {}.", (Object)tmFeatureType.getName(), (Object)searchIndex.getName());
            return (SearchIndex)searchIndexRepository.save(searchIndex.setStatus(SearchIndex.Status.ERROR).setSummary(summary.errorMessage("No search fields configured")));
        }
        TaskProgressEvent taskProgressEvent = new TaskProgressEvent().type(TaskType.INDEX.getValue()).uuid(taskUuid).startedAt(startedAtOffset).progress(0).taskData(Map.of("indexId", searchIndex.getId()));
        progressListener.accept(taskProgressEvent);
        List<String> searchFields = searchIndex.getSearchFieldsUsed().stream().filter(s -> !tmFeatureType.getSettings().getHideAttributes().contains(s)).toList();
        List<String> displayFields = searchIndex.getSearchDisplayFieldsUsed().stream().filter(s -> !tmFeatureType.getSettings().getHideAttributes().contains(s)).toList();
        if (searchFields.isEmpty()) {
            logger.warn("No valid search fields configured for feature type: {}, skipping index {}.", (Object)tmFeatureType.getName(), (Object)searchIndex.getName());
            return (SearchIndex)searchIndexRepository.save(searchIndex.setStatus(SearchIndex.Status.ERROR).setSummary(summary.errorMessage("No search fields configured")));
        }
        HashSet<String> propertyNames = new HashSet<String>();
        if (null == tmFeatureType.getPrimaryKeyAttribute()) {
            logger.error("No primary key attribute configured for feature type: {}, skipping index {}.", (Object)tmFeatureType.getName(), (Object)searchIndex.getName());
            return (SearchIndex)searchIndexRepository.save(searchIndex.setStatus(SearchIndex.Status.ERROR).setSummary(summary.errorMessage("No primary key attribute configured")));
        }
        propertyNames.add(tmFeatureType.getPrimaryKeyAttribute());
        if (null == tmFeatureType.getDefaultGeometryAttribute()) {
            logger.error("No default geometry attribute configured for feature type: {}, skipping index {}.", (Object)tmFeatureType.getName(), (Object)searchIndex.getName());
            return (SearchIndex)searchIndexRepository.save(searchIndex.setStatus(SearchIndex.Status.ERROR).setSummary(summary.errorMessage("No default geometry attribute configured")));
        }
        propertyNames.add(tmFeatureType.getDefaultGeometryAttribute());
        propertyNames.addAll(searchFields);
        if (!displayFields.isEmpty()) {
            propertyNames.addAll(displayFields);
        }
        this.clearIndexForLayer(searchIndex.getId());
        logger.info("Indexing started for index: {}, feature type: {}", (Object)searchIndex.getName(), (Object)tmFeatureType.getName());
        searchIndex = (SearchIndex)searchIndexRepository.save(searchIndex.setStatus(SearchIndex.Status.INDEXING));
        SimpleFeatureSource fs = featureSourceFactoryHelper.openGeoToolsFeatureSource(tmFeatureType);
        Query q = new Query(fs.getName().toString());
        tmFeatureType.getSettings().getHideAttributes().forEach(propertyNames::remove);
        if (propertyNames.isEmpty()) {
            logger.warn("No valid properties to index for feature type: {}, skipping index {}.", (Object)tmFeatureType.getName(), (Object)searchIndex.getName());
            return (SearchIndex)searchIndexRepository.save(searchIndex.setStatus(SearchIndex.Status.ERROR).setSummary(summary.errorMessage("No valid properties to index. Check if any properties are hidden.")));
        }
        q.setPropertyNames(List.copyOf(propertyNames));
        q.setStartIndex(Integer.valueOf(0));
        logger.trace("Indexing query: {}", (Object)q);
        SimpleFeatureCollection simpleFeatureCollection = fs.getFeatures(q);
        int total = simpleFeatureCollection.size();
        ArrayList<FeatureIndexingDocument> docsBatch = new ArrayList<FeatureIndexingDocument>(this.solrBatchSize);
        int indexCounter = 0;
        int indexSkippedCounter = 0;
        try (SimpleFeatureIterator iterator = simpleFeatureCollection.features();){
            while (iterator.hasNext()) {
                ++indexCounter;
                SimpleFeature feature = (SimpleFeature)iterator.next();
                FeatureIndexingDocument doc = new FeatureIndexingDocument(feature.getID(), searchIndex.getId());
                ArrayList searchValues = new ArrayList();
                ArrayList displayValues = new ArrayList();
                propertyNames.forEach(propertyName -> {
                    Object value = feature.getAttribute(propertyName);
                    if (value != null) {
                        if (value instanceof Geometry && propertyName.equals(tmFeatureType.getDefaultGeometryAttribute())) {
                            doc.setGeometry(GeometryProcessor.processGeometry(value, true, true, null));
                        } else {
                            if (searchFields.contains(propertyName)) {
                                searchValues.add(value.toString());
                            }
                            if (displayFields.contains(propertyName)) {
                                displayValues.add(value.toString());
                            }
                        }
                    }
                });
                if (searchValues.isEmpty() || displayValues.isEmpty()) {
                    logger.trace("No search or display values found for feature: {} in feature type: {}, skipped for indexing", (Object)feature.getID(), (Object)tmFeatureType.getName());
                    ++indexSkippedCounter;
                } else {
                    doc.setSearchFields(searchValues.toArray(new String[0]));
                    doc.setDisplayFields(displayValues.toArray(new String[0]));
                    docsBatch.add(doc);
                }
                if (indexCounter % this.solrBatchSize != 0) continue;
                updateResponse = this.solrClient.addBeans(docsBatch, this.solrQueryTimeout);
                logger.info("Added {} documents of {} to index, result status: {}", new Object[]{indexCounter - indexSkippedCounter, total, updateResponse.getStatus()});
                progressListener.accept(taskProgressEvent.total(total).progress(indexCounter - indexSkippedCounter));
                docsBatch.clear();
            }
        }
        finally {
            if (fs.getDataStore() != null) {
                fs.getDataStore().dispose();
            }
        }
        if (!docsBatch.isEmpty()) {
            this.solrClient.addBeans(docsBatch, this.solrQueryTimeout);
            logger.info("Added last {} documents of {} to index", (Object)docsBatch.size(), (Object)total);
            progressListener.accept(taskProgressEvent.progress(indexCounter - indexSkippedCounter).total(total));
        }
        Instant finishedAt = Instant.now();
        OffsetDateTime finishedAtOffset = finishedAt.atOffset(ZoneId.systemDefault().getRules().getOffset(finishedAt));
        Duration processTime = Duration.between(startedAt, finishedAt).abs();
        logger.info("Indexing finished for index: {}, feature type: {} at {} in {}", new Object[]{searchIndex.getName(), tmFeatureType.getName(), finishedAtOffset, processTime});
        updateResponse = this.solrClient.commit();
        logger.trace("Update response commit status: {}", (Object)updateResponse.getStatus());
        if (indexSkippedCounter > 0) {
            logger.warn("{} features were skipped because no search or display values were found.", (Object)indexSkippedCounter);
        }
        return (SearchIndex)searchIndexRepository.save(searchIndex.setLastIndexed(finishedAtOffset).setStatus(SearchIndex.Status.INDEXED).setSummary(summary.total(total).skippedCounter(indexSkippedCounter).duration(BigDecimal.valueOf(processTime.getSeconds()).add(BigDecimal.valueOf(processTime.getNano(), 9)).doubleValue()).errorMessage(null)));
    }

    public void clearIndexForLayer(@NotNull Long searchLayerId) throws IOException, SolrServerException {
        QueryResponse response = this.solrClient.query((SolrParams)new SolrQuery("exists(query(searchLayer:" + searchLayerId + "))"));
        if (response.getResults().getNumFound() > 0L) {
            logger.info("Clearing index for searchLayer {}", (Object)searchLayerId);
            UpdateResponse updateResponse = this.solrClient.deleteByQuery("searchLayer:" + searchLayerId);
            logger.trace("Delete response status: {}", (Object)updateResponse.getStatus());
            updateResponse = this.solrClient.commit();
            logger.trace("Commit response status: {}", (Object)updateResponse.getStatus());
        } else {
            logger.info("No index to clear for layer {}", (Object)searchLayerId);
        }
    }

    public SearchResponse findInIndex(@NotNull SearchIndex searchIndex, String solrQuery, String solrFilterQuery, String solrPoint, Double solrDistance, int start, int numResultsToReturn) throws IOException, SolrServerException, SolrException {
        if (null == solrQuery || solrQuery.isBlank()) {
            solrQuery = "*";
        }
        logger.info("Query index for '{}' in {} (id {})", new Object[]{solrQuery, searchIndex.getName(), searchIndex.getId()});
        SolrQuery query = new SolrQuery("searchFields:" + solrQuery).setShowDebugInfo(logger.isDebugEnabled()).setTimeAllowed(Integer.valueOf(this.solrQueryTimeout)).setIncludeScore(true).setFields(new String[]{"id", "displayFields", "geometry"}).addFilterQuery(new String[]{"searchLayer:" + searchIndex.getId()}).setSort("score", SolrQuery.ORDER.desc).addSort("id", SolrQuery.ORDER.asc).setRows(Integer.valueOf(numResultsToReturn)).setStart(Integer.valueOf(start));
        if (null != solrFilterQuery && !solrFilterQuery.isBlank()) {
            query.addFilterQuery(new String[]{solrFilterQuery});
        }
        if (null != solrPoint && null != solrDistance) {
            if (null == solrFilterQuery || !solrFilterQuery.startsWith("{!geofilt") && !solrFilterQuery.startsWith("{!bbox")) {
                query.addFilterQuery(new String[]{"{!geofilt sfield=geometry}"});
            }
            query.add("pt", new String[]{solrPoint});
            query.add("d", new String[]{solrDistance.toString()});
        }
        query.set("q.op", new String[]{"AND"});
        logger.info("Solr query: {}", (Object)query);
        QueryResponse response = this.solrClient.query((SolrParams)query);
        logger.trace("response: {}", (Object)response);
        SolrDocumentList solrDocumentList = response.getResults();
        logger.debug("Found {} solr documents", (Object)solrDocumentList.getNumFound());
        SearchResponse searchResponse = new SearchResponse().total(solrDocumentList.getNumFound()).start(response.getResults().getStart()).maxScore(solrDocumentList.getMaxScore());
        response.getResults().forEach(solrDocument -> {
            List<String> displayValues = solrDocument.getFieldValues("displayFields").stream().map(Object::toString).toList();
            searchResponse.addDocumentsItem(new SearchDocument().fid(solrDocument.getFieldValue("id").toString()).geometry(solrDocument.getFieldValue("geometry").toString()).displayValues(displayValues));
        });
        return searchResponse;
    }

    @Override
    public void close() throws IOException {
        if (null != this.solrClient) {
            this.solrClient.close();
        }
    }

    private boolean checkSchemaIfFieldExists(String fieldName) {
        SchemaRequest.Field fieldCheck = new SchemaRequest.Field(fieldName);
        try {
            SchemaResponse.FieldResponse isField = (SchemaResponse.FieldResponse)fieldCheck.process(this.solrClient);
            logger.debug("Field {} exists", (Object)isField.getField());
            return true;
        }
        catch (SolrServerException | BaseHttpSolrClient.RemoteSolrException e) {
            logger.debug("Field {} does not exist or could not be retrieved. Assuming it does not exist.", (Object)fieldName);
        }
        catch (IOException e) {
            logger.error("Tried getting field: {}, but failed.", (Object)fieldName, (Object)e);
        }
        return false;
    }

    private void createSchemaFieldIfNotExists(String fieldName) throws SolrServerException, IOException {
        if (!this.checkSchemaIfFieldExists(fieldName)) {
            logger.info("Creating Solr field {}.", (Object)fieldName);
            SchemaRequest.AddField schemaRequest = this.solrSearchFields.get(fieldName);
            SolrResponse response = schemaRequest.process(this.solrClient);
            logger.debug("Field type {} created", (Object)response);
            this.solrClient.commit();
        }
    }

    private void createSchemaIfNotExists() {
        this.solrSearchFields.forEach((key, value) -> {
            try {
                if (key.equals("geometry")) {
                    this.createGeometryFieldTypeIfNotExists();
                }
                this.createSchemaFieldIfNotExists((String)key);
            }
            catch (IOException | SolrServerException e) {
                logger.error("Error creating schema field: {} indexing may fail. Details: {}", new Object[]{key, e.getLocalizedMessage(), e});
            }
        });
    }

    private void createGeometryFieldTypeIfNotExists() throws SolrServerException, IOException {
        SchemaRequest.FieldType fieldTypeCheck = new SchemaRequest.FieldType(SOLR_SPATIAL_FIELDNAME);
        try {
            SchemaResponse.FieldTypeResponse isFieldType = (SchemaResponse.FieldTypeResponse)fieldTypeCheck.process(this.solrClient);
            logger.debug("Field type {} exists", (Object)isFieldType.getFieldType());
            return;
        }
        catch (SolrServerException | BaseHttpSolrClient.RemoteSolrException e) {
            logger.debug("Field type {} does not exist or could not be retrieved. Assuming it does not exist.", (Object)SOLR_SPATIAL_FIELDNAME);
        }
        catch (IOException e) {
            logger.error("Tried getting field type: {}, but failed.", (Object)SOLR_SPATIAL_FIELDNAME, (Object)e);
        }
        logger.info("Creating Solr field type for {} with validation rule {}", (Object)SOLR_SPATIAL_FIELDNAME, (Object)this.solrGeometryValidationRule);
        FieldTypeDefinition spatialFieldTypeDef = new FieldTypeDefinition();
        HashMap<String, String> spatialFieldAttributes = new HashMap<String, String>(Map.of("name", SOLR_SPATIAL_FIELDNAME, "class", "solr.SpatialRecursivePrefixTreeFieldType", "spatialContextFactory", "JTS", "geo", false, "distanceUnits", "kilometers", "distCalculator", "cartesian", "format", "WKT", "autoIndex", true, "distErrPct", "0.025", "maxDistErr", "0.001"));
        spatialFieldAttributes.putAll(Map.of("prefixTree", "packedQuad", "validationRule", this.solrGeometryValidationRule, "worldBounds", "ENVELOPE(-20037508.34, 20037508.34, 20048966.1, -20048966.1)"));
        spatialFieldTypeDef.setAttributes(spatialFieldAttributes);
        SchemaRequest.AddFieldType spatialFieldType = new SchemaRequest.AddFieldType(spatialFieldTypeDef);
        spatialFieldType.process(this.solrClient);
        this.solrClient.commit();
    }
}

