/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Objects;
import org.tailormap.api.viewer.model.ComponentConfig;

@Schema(name="Component", description="a component to be used in the application")
public class Component
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String type;
    private ComponentConfig config;

    public Component type(String type) {
        this.type = type;
        return this;
    }

    @NotNull
    @Schema(name="type", description="component type eg. featurereport or print", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Component config(ComponentConfig config) {
        this.config = config;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="config", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="config")
    public ComponentConfig getConfig() {
        return this.config;
    }

    public void setConfig(ComponentConfig config) {
        this.config = config;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Component component = (Component)o;
        return Objects.equals(this.type, component.type) && Objects.equals(this.config, component.config);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.config);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Component {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

