/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.lang.Nullable;
import org.tailormap.api.viewer.model.ColumnMetadata;
import org.tailormap.api.viewer.model.Feature;

@Schema(name="FeaturesResponse", description="A -possibly empty- list of features with requested attributes and presentation metadata")
public class FeaturesResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer total = null;
    private Integer page = null;
    @Nullable
    private Integer pageSize = null;
    @Valid
    private @Valid List<@Valid Feature> features = new ArrayList<Feature>();
    @Valid
    private @Valid List<@Valid ColumnMetadata> columnMetadata = new ArrayList<ColumnMetadata>();
    private String template = null;

    public FeaturesResponse total(Integer total) {
        this.total = total;
        return this;
    }

    @Schema(name="total", description=" the total number of available features, can be an estimated value. Can be missing when unknown or irrelevant (eg. featureinfo request) ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="total")
    public Integer getTotal() {
        return this.total;
    }

    public void setTotal(Integer total) {
        this.total = total;
    }

    public FeaturesResponse page(Integer page) {
        this.page = page;
        return this;
    }

    @Min(value=1L)
    @Schema(name="page", description="current page, this will allow the client to request the next or previous page by adding or removing 1 or more", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="page")
    public @Min(value=1L) Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public FeaturesResponse pageSize(@Nullable Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @Min(value=1L)
    @Schema(name="pageSize", accessMode=Schema.AccessMode.READ_ONLY, description="number of features in a page, this will allow calculating the offset (page * pagesize)", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="pageSize")
    @Nullable
    public @Min(value=1L) Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(@Nullable Integer pageSize) {
        this.pageSize = pageSize;
    }

    public FeaturesResponse features(List<@Valid Feature> features) {
        this.features = features;
        return this;
    }

    public FeaturesResponse addFeaturesItem(Feature featuresItem) {
        if (this.features == null) {
            this.features = new ArrayList<Feature>();
        }
        this.features.add(featuresItem);
        return this;
    }

    @NotNull
    @Valid
    @Size(min=0)
    @Schema(name="features", description="list of features. When the pagenumber*pagesize exceeds the number of features this list will be empty", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="features")
    public @NotNull @Valid @Size(min=0) List<@Valid Feature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<@Valid Feature> features) {
        this.features = features;
    }

    public FeaturesResponse columnMetadata(List<@Valid ColumnMetadata> columnMetadata) {
        this.columnMetadata = columnMetadata;
        return this;
    }

    public FeaturesResponse addColumnMetadataItem(ColumnMetadata columnMetadataItem) {
        if (this.columnMetadata == null) {
            this.columnMetadata = new ArrayList<ColumnMetadata>();
        }
        this.columnMetadata.add(columnMetadataItem);
        return this;
    }

    @NotNull
    @Valid
    @Size(min=0)
    @Schema(name="columnMetadata", description="presentation metadata", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="columnMetadata")
    public @NotNull @Valid @Size(min=0) List<@Valid ColumnMetadata> getColumnMetadata() {
        return this.columnMetadata;
    }

    public void setColumnMetadata(List<@Valid ColumnMetadata> columnMetadata) {
        this.columnMetadata = columnMetadata;
    }

    public FeaturesResponse template(String template) {
        this.template = template;
        return this;
    }

    @Schema(name="template", description="Template/description for a feature. Will replace placeholders by attribute values in the viewer", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="template")
    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeaturesResponse featuresResponse = (FeaturesResponse)o;
        return Objects.equals(this.total, featuresResponse.total) && Objects.equals(this.page, featuresResponse.page) && Objects.equals(this.pageSize, featuresResponse.pageSize) && Objects.equals(this.features, featuresResponse.features) && Objects.equals(this.columnMetadata, featuresResponse.columnMetadata) && Objects.equals(this.template, featuresResponse.template);
    }

    public int hashCode() {
        return Objects.hash(this.total, this.page, this.pageSize, this.features, this.columnMetadata, this.template);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeaturesResponse {\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    features: ").append(this.toIndentedString(this.features)).append("\n");
        sb.append("    columnMetadata: ").append(this.toIndentedString(this.columnMetadata)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

