/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(name="SearchDocument", description="A search result document")
public class SearchDocument
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String fid;
    private String geometry = null;
    @Valid
    private List<String> displayValues;

    public SearchDocument fid(String fid) {
        this.fid = fid;
        return this;
    }

    @Schema(name="fid", description="The unique identifier of the feature, also the primary key in the underlying data source", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="fid")
    public String getFid() {
        return this.fid;
    }

    public void setFid(String fid) {
        this.fid = fid;
    }

    public SearchDocument geometry(String geometry) {
        this.geometry = geometry;
        return this;
    }

    @Schema(name="geometry", description="The geometry of the feature (WKT)", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="geometry")
    public String getGeometry() {
        return this.geometry;
    }

    public void setGeometry(String geometry) {
        this.geometry = geometry;
    }

    public SearchDocument displayValues(List<String> displayValues) {
        this.displayValues = displayValues;
        return this;
    }

    public SearchDocument addDisplayValuesItem(String displayValuesItem) {
        if (this.displayValues == null) {
            this.displayValues = new ArrayList<String>();
        }
        this.displayValues.add(displayValuesItem);
        return this;
    }

    @Schema(name="displayValues", description="The values from the index to display in the search result", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="displayValues")
    public List<String> getDisplayValues() {
        return this.displayValues;
    }

    public void setDisplayValues(List<String> displayValues) {
        this.displayValues = displayValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchDocument searchDocument = (SearchDocument)o;
        return Objects.equals(this.fid, searchDocument.fid) && Objects.equals(this.geometry, searchDocument.geometry) && Objects.equals(this.displayValues, searchDocument.displayValues);
    }

    public int hashCode() {
        return Objects.hash(this.fid, this.geometry, this.displayValues);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchDocument {\n");
        sb.append("    fid: ").append(this.toIndentedString(this.fid)).append("\n");
        sb.append("    geometry: ").append(this.toIndentedString(this.geometry)).append("\n");
        sb.append("    displayValues: ").append(this.toIndentedString(this.displayValues)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

