/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

@Schema(name="SliderFilterConfiguration", description="Configuration for a slider filter")
public class SliderFilterConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Double minimumValue;
    private Double maximumValue;
    private Double initialValue;
    private Double initialLowerValue;
    private Double initialUpperValue;
    private InputModeEnum inputMode = InputModeEnum.SLIDER;
    private Double stepSize;

    public SliderFilterConfiguration minimumValue(Double minimumValue) {
        this.minimumValue = minimumValue;
        return this;
    }

    @Schema(name="minimumValue", description="minimum value for the slider", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="minimumValue")
    public Double getMinimumValue() {
        return this.minimumValue;
    }

    public void setMinimumValue(Double minimumValue) {
        this.minimumValue = minimumValue;
    }

    public SliderFilterConfiguration maximumValue(Double maximumValue) {
        this.maximumValue = maximumValue;
        return this;
    }

    @Schema(name="maximumValue", description="maximum value for the slider", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="maximumValue")
    public Double getMaximumValue() {
        return this.maximumValue;
    }

    public void setMaximumValue(Double maximumValue) {
        this.maximumValue = maximumValue;
    }

    public SliderFilterConfiguration initialValue(Double initialValue) {
        this.initialValue = initialValue;
        return this;
    }

    @Schema(name="initialValue", description="initial value for the slider", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="initialValue")
    public Double getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(Double initialValue) {
        this.initialValue = initialValue;
    }

    public SliderFilterConfiguration initialLowerValue(Double initialLowerValue) {
        this.initialLowerValue = initialLowerValue;
        return this;
    }

    @Schema(name="initialLowerValue", description="initial lower value for a slider filter with between condition", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="initialLowerValue")
    public Double getInitialLowerValue() {
        return this.initialLowerValue;
    }

    public void setInitialLowerValue(Double initialLowerValue) {
        this.initialLowerValue = initialLowerValue;
    }

    public SliderFilterConfiguration initialUpperValue(Double initialUpperValue) {
        this.initialUpperValue = initialUpperValue;
        return this;
    }

    @Schema(name="initialUpperValue", description="initial upper value for a slider filter with between condition", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="initialUpperValue")
    public Double getInitialUpperValue() {
        return this.initialUpperValue;
    }

    public void setInitialUpperValue(Double initialUpperValue) {
        this.initialUpperValue = initialUpperValue;
    }

    public SliderFilterConfiguration inputMode(InputModeEnum inputMode) {
        this.inputMode = inputMode;
        return this;
    }

    @Schema(name="inputMode", description="the mode of input for the filter", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="inputMode")
    public InputModeEnum getInputMode() {
        return this.inputMode;
    }

    public void setInputMode(InputModeEnum inputMode) {
        this.inputMode = inputMode;
    }

    public SliderFilterConfiguration stepSize(Double stepSize) {
        this.stepSize = stepSize;
        return this;
    }

    @Schema(name="stepSize", description="the step size for the slider", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="stepSize")
    public Double getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(Double stepSize) {
        this.stepSize = stepSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SliderFilterConfiguration sliderFilterConfiguration = (SliderFilterConfiguration)o;
        return Objects.equals(this.minimumValue, sliderFilterConfiguration.minimumValue) && Objects.equals(this.maximumValue, sliderFilterConfiguration.maximumValue) && Objects.equals(this.initialValue, sliderFilterConfiguration.initialValue) && Objects.equals(this.initialLowerValue, sliderFilterConfiguration.initialLowerValue) && Objects.equals(this.initialUpperValue, sliderFilterConfiguration.initialUpperValue) && Objects.equals((Object)this.inputMode, (Object)sliderFilterConfiguration.inputMode) && Objects.equals(this.stepSize, sliderFilterConfiguration.stepSize);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.minimumValue, this.maximumValue, this.initialValue, this.initialLowerValue, this.initialUpperValue, this.inputMode, this.stepSize});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SliderFilterConfiguration {\n");
        sb.append("    minimumValue: ").append(this.toIndentedString(this.minimumValue)).append("\n");
        sb.append("    maximumValue: ").append(this.toIndentedString(this.maximumValue)).append("\n");
        sb.append("    initialValue: ").append(this.toIndentedString(this.initialValue)).append("\n");
        sb.append("    initialLowerValue: ").append(this.toIndentedString(this.initialLowerValue)).append("\n");
        sb.append("    initialUpperValue: ").append(this.toIndentedString(this.initialUpperValue)).append("\n");
        sb.append("    inputMode: ").append(this.toIndentedString((Object)this.inputMode)).append("\n");
        sb.append("    stepSize: ").append(this.toIndentedString(this.stepSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum InputModeEnum {
        SLIDER("SLIDER"),
        INPUT_FIELD("INPUT_FIELD"),
        SLIDER_AND_INPUT_FIELD("SLIDER_AND_INPUT_FIELD");

        private final String value;

        private InputModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InputModeEnum fromValue(String value) {
            for (InputModeEnum b : InputModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

