/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.micrometer.core.annotation.Counted;
import io.micrometer.core.annotation.Timed;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.server.ResponseStatusException;
import org.tailormap.api.annotation.AppRestController;
import org.tailormap.api.drawing.DrawingService;
import org.tailormap.api.persistence.Application;
import org.tailormap.api.viewer.model.Drawing;

@AppRestController
@Validated
public class DrawingController {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final DrawingService drawingService;

    public DrawingController(DrawingService drawingService) {
        this.drawingService = drawingService;
    }

    @PutMapping(path={"${tailormap-api.base-path}/{viewerKind}/{viewerName}/drawing"}, consumes={"application/json"}, produces={"application/json"})
    @Timed(value="create_or_update_drawing", description="time spent to create or update a drawing")
    @Counted(value="create_or_update_drawing", description="number of created or updated drawings")
    @Valid
    public ResponseEntity<Serializable> createOrUpdateDrawing(@NonNull @RequestBody Drawing drawing, @ModelAttribute Application application) throws JsonProcessingException {
        HttpStatus httpStatus;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || authentication instanceof AnonymousAuthenticationToken) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Authentication required");
        }
        if ((drawing = drawing.srid(this.getApplicationSrid(application))).getId() == null) {
            logger.trace("create new drawing {}", (Object)drawing);
            drawing = this.drawingService.createDrawing(drawing, authentication);
            httpStatus = HttpStatus.CREATED;
        } else {
            logger.trace("update existing drawing {}", (Object)drawing);
            drawing = this.drawingService.updateDrawing(drawing, authentication);
            httpStatus = HttpStatus.OK;
        }
        return ResponseEntity.status((HttpStatusCode)httpStatus).body((Object)drawing);
    }

    @GetMapping(path={"${tailormap-api.base-path}/{viewerKind}/{viewerName}/drawing/{drawingId}"}, produces={"application/json"})
    @Counted(value="get_drawing", description="number of drawings retrieved")
    @Timed(value="get_drawing", description="time spent to retrieve a drawing")
    @Valid
    public ResponseEntity<Serializable> getDrawing(@NonNull @PathVariable UUID drawingId, @ModelAttribute Application application) throws ResponseStatusException {
        Drawing drawing = (Drawing)this.drawingService.getDrawing(drawingId, SecurityContextHolder.getContext().getAuthentication(), true, this.getApplicationSrid(application).intValue()).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Drawing not found"));
        return ResponseEntity.status((HttpStatusCode)HttpStatus.OK).body((Object)drawing);
    }

    @GetMapping(path={"${tailormap-api.base-path}/drawing/list"}, produces={"application/json"})
    @Counted(value="list_drawings", description="number of drawings listed")
    @Timed(value="list_drawings", description="time spent to list drawings")
    public Set<Drawing> listDrawings() {
        return this.drawingService.getDrawingsForUser(SecurityContextHolder.getContext().getAuthentication());
    }

    @DeleteMapping(path={"${tailormap-api.base-path}/drawing/{drawingId}"})
    @Timed(value="delete_drawing", description="time spent to delete a drawing")
    @Counted(value="delete_drawing", description="number of drawings deleted")
    public ResponseEntity<Serializable> deleteDrawing(@NonNull @PathVariable UUID drawingId) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null || authentication instanceof AnonymousAuthenticationToken) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED, "Authentication required");
        }
        this.drawingService.deleteDrawing(drawingId, authentication);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.NO_CONTENT).build();
    }

    private Integer getApplicationSrid(Application application) {
        if (application.getCrs().contains(":")) {
            return Integer.valueOf(application.getCrs().substring(application.getCrs().lastIndexOf(":") + 1));
        }
        return Integer.valueOf(application.getCrs());
    }
}

