/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.geotools.featuresources;

import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.ResourceInfo;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.data.wfs.internal.FeatureTypeInfo;
import org.locationtech.jts.geom.Envelope;
import org.springframework.util.LinkedCaseInsensitiveMap;
import org.springframework.web.util.UriComponentsBuilder;
import org.tailormap.api.geotools.PreventLocalAllowNestedJarEntityResolver;
import org.tailormap.api.geotools.featuresources.FeatureSourceHelper;
import org.tailormap.api.geotools.wfs.SimpleWFSHelper;
import org.tailormap.api.persistence.TMFeatureSource;
import org.tailormap.api.persistence.TMFeatureType;
import org.tailormap.api.persistence.helper.GeoToolsHelper;
import org.tailormap.api.persistence.json.ServiceAuthentication;
import org.tailormap.api.persistence.json.TMFeatureTypeInfo;

public class WFSFeatureSourceHelper
extends FeatureSourceHelper {
    public DataStore createDataStore(TMFeatureSource tmfs, Integer timeout) throws IOException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(WFSDataStoreFactory.ENTITY_RESOLVER.key, PreventLocalAllowNestedJarEntityResolver.INSTANCE);
        if (timeout != null) {
            params.put(WFSDataStoreFactory.TIMEOUT.key, timeout);
        }
        LinkedCaseInsensitiveMap wfsUrlParams = new LinkedCaseInsensitiveMap();
        wfsUrlParams.putAll(UriComponentsBuilder.fromUriString((String)tmfs.getUrl()).build().getQueryParams().toSingleValueMap());
        String version = (String)wfsUrlParams.get((Object)"VERSION");
        if (!"2.0.0".equals(version)) {
            version = "1.1.0";
        }
        params.put(WFSDataStoreFactory.URL.key, SimpleWFSHelper.getWFSRequestURL((String)tmfs.getUrl(), (String)"GetCapabilities", (String)version, null).toURL());
        ServiceAuthentication authentication = tmfs.getAuthentication();
        if (authentication != null) {
            if (authentication.getMethod() != ServiceAuthentication.MethodEnum.PASSWORD) {
                throw new IllegalArgumentException(authentication.getMethod().getValue());
            }
            params.put(WFSDataStoreFactory.USERNAME.key, authentication.getUsername());
            params.put(WFSDataStoreFactory.PASSWORD.key, authentication.getPassword());
        }
        return this.openDatastore(params, WFSDataStoreFactory.PASSWORD.key);
    }

    protected TMFeatureTypeInfo getFeatureTypeInfo(TMFeatureType pft, ResourceInfo info, SimpleFeatureSource gtFs) {
        TMFeatureTypeInfo tmInfo = super.getFeatureTypeInfo(pft, info, gtFs);
        if (info instanceof FeatureTypeInfo) {
            FeatureTypeInfo ftInfo = (FeatureTypeInfo)info;
            tmInfo.schema(info.getSchema()).wgs84BoundingBox(GeoToolsHelper.fromEnvelope((Envelope)ftInfo.getWGS84BoundingBox())).defaultSrs(ftInfo.getDefaultSRS()).otherSrs(Set.copyOf(ftInfo.getOtherSRS())).outputFormats(ftInfo.getOutputFormats()).abstractText(ftInfo.getAbstract());
        }
        return tmInfo;
    }
}

