/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.tailormap.api.persistence.json.HiddenLayerFunctionalityEnum;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AppLayerSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String title = null;
    private Integer opacity = 100;
    private String attribution = null;
    private String description = null;
    @Nullable
    private Boolean editable = null;
    private Long formId = null;
    private Long searchIndexId = null;
    @Valid
    private List<String> hideAttributes = new ArrayList();
    @Valid
    private List<String> readOnlyAttributes = new ArrayList();
    private Double autoRefreshInSeconds = null;
    @Valid
    private Set<HiddenLayerFunctionalityEnum> hiddenFunctionality = new LinkedHashSet();

    public AppLayerSettings title(String title) {
        this.title = title;
        return this;
    }

    @Schema(name="title", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public AppLayerSettings opacity(Integer opacity) {
        this.opacity = opacity;
        return this;
    }

    @Schema(name="opacity", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="opacity")
    public Integer getOpacity() {
        return this.opacity;
    }

    public void setOpacity(Integer opacity) {
        this.opacity = opacity;
    }

    public AppLayerSettings attribution(String attribution) {
        this.attribution = attribution;
        return this;
    }

    @Schema(name="attribution", description="Attribution to show for this layer.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="attribution")
    public String getAttribution() {
        return this.attribution;
    }

    public void setAttribution(String attribution) {
        this.attribution = attribution;
    }

    public AppLayerSettings description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="Description to show for this layer.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AppLayerSettings editable(@Nullable Boolean editable) {
        this.editable = editable;
        return this;
    }

    @Schema(name="editable", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="editable")
    @Nullable
    public Boolean getEditable() {
        return this.editable;
    }

    public void setEditable(@Nullable Boolean editable) {
        this.editable = editable;
    }

    public AppLayerSettings formId(Long formId) {
        this.formId = formId;
        return this;
    }

    @Schema(name="formId", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="formId")
    public Long getFormId() {
        return this.formId;
    }

    public void setFormId(Long formId) {
        this.formId = formId;
    }

    public AppLayerSettings searchIndexId(Long searchIndexId) {
        this.searchIndexId = searchIndexId;
        return this;
    }

    @Schema(name="searchIndexId", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="searchIndexId")
    public Long getSearchIndexId() {
        return this.searchIndexId;
    }

    public void setSearchIndexId(Long searchIndexId) {
        this.searchIndexId = searchIndexId;
    }

    public AppLayerSettings hideAttributes(List<String> hideAttributes) {
        this.hideAttributes = hideAttributes;
        return this;
    }

    public AppLayerSettings addHideAttributesItem(String hideAttributesItem) {
        if (this.hideAttributes == null) {
            this.hideAttributes = new ArrayList();
        }
        this.hideAttributes.add(hideAttributesItem);
        return this;
    }

    @Schema(name="hideAttributes", description="List of attribute names that should be hidden (in addition to attributes already hidden by the feature type settings).", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="hideAttributes")
    public List<String> getHideAttributes() {
        return this.hideAttributes;
    }

    public void setHideAttributes(List<String> hideAttributes) {
        this.hideAttributes = hideAttributes;
    }

    public AppLayerSettings readOnlyAttributes(List<String> readOnlyAttributes) {
        this.readOnlyAttributes = readOnlyAttributes;
        return this;
    }

    public AppLayerSettings addReadOnlyAttributesItem(String readOnlyAttributesItem) {
        if (this.readOnlyAttributes == null) {
            this.readOnlyAttributes = new ArrayList();
        }
        this.readOnlyAttributes.add(readOnlyAttributesItem);
        return this;
    }

    @Schema(name="readOnlyAttributes", description="List of feature type attribute names that are not editable (in addition to read only attributes from the feature type settings).", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="readOnlyAttributes")
    public List<String> getReadOnlyAttributes() {
        return this.readOnlyAttributes;
    }

    public void setReadOnlyAttributes(List<String> readOnlyAttributes) {
        this.readOnlyAttributes = readOnlyAttributes;
    }

    public AppLayerSettings autoRefreshInSeconds(Double autoRefreshInSeconds) {
        this.autoRefreshInSeconds = autoRefreshInSeconds;
        return this;
    }

    @Schema(name="autoRefreshInSeconds", description="Auto refresh layer in seconds", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="autoRefreshInSeconds")
    public Double getAutoRefreshInSeconds() {
        return this.autoRefreshInSeconds;
    }

    public void setAutoRefreshInSeconds(Double autoRefreshInSeconds) {
        this.autoRefreshInSeconds = autoRefreshInSeconds;
    }

    public AppLayerSettings hiddenFunctionality(Set<HiddenLayerFunctionalityEnum> hiddenFunctionality) {
        this.hiddenFunctionality = hiddenFunctionality;
        return this;
    }

    public AppLayerSettings addHiddenFunctionalityItem(HiddenLayerFunctionalityEnum hiddenFunctionalityItem) {
        if (this.hiddenFunctionality == null) {
            this.hiddenFunctionality = new LinkedHashSet();
        }
        this.hiddenFunctionality.add(hiddenFunctionalityItem);
        return this;
    }

    @Valid
    @Schema(name="hiddenFunctionality", description="Functionality that should be hidden for a layer in the UI. The functionality is still available in the backend, so not a \"security\" setting.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="hiddenFunctionality")
    public Set<HiddenLayerFunctionalityEnum> getHiddenFunctionality() {
        return this.hiddenFunctionality;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setHiddenFunctionality(Set<HiddenLayerFunctionalityEnum> hiddenFunctionality) {
        this.hiddenFunctionality = hiddenFunctionality;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppLayerSettings appLayerSettings = (AppLayerSettings)o;
        return Objects.equals(this.title, appLayerSettings.title) && Objects.equals(this.opacity, appLayerSettings.opacity) && Objects.equals(this.attribution, appLayerSettings.attribution) && Objects.equals(this.description, appLayerSettings.description) && Objects.equals(this.editable, appLayerSettings.editable) && Objects.equals(this.formId, appLayerSettings.formId) && Objects.equals(this.searchIndexId, appLayerSettings.searchIndexId) && Objects.equals(this.hideAttributes, appLayerSettings.hideAttributes) && Objects.equals(this.readOnlyAttributes, appLayerSettings.readOnlyAttributes) && Objects.equals(this.autoRefreshInSeconds, appLayerSettings.autoRefreshInSeconds) && Objects.equals(this.hiddenFunctionality, appLayerSettings.hiddenFunctionality);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.opacity, this.attribution, this.description, this.editable, this.formId, this.searchIndexId, this.hideAttributes, this.readOnlyAttributes, this.autoRefreshInSeconds, this.hiddenFunctionality);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppLayerSettings {\n");
        sb.append("    title: ").append(this.toIndentedString((Object)this.title)).append("\n");
        sb.append("    opacity: ").append(this.toIndentedString((Object)this.opacity)).append("\n");
        sb.append("    attribution: ").append(this.toIndentedString((Object)this.attribution)).append("\n");
        sb.append("    description: ").append(this.toIndentedString((Object)this.description)).append("\n");
        sb.append("    editable: ").append(this.toIndentedString((Object)this.editable)).append("\n");
        sb.append("    formId: ").append(this.toIndentedString((Object)this.formId)).append("\n");
        sb.append("    searchIndexId: ").append(this.toIndentedString((Object)this.searchIndexId)).append("\n");
        sb.append("    hideAttributes: ").append(this.toIndentedString((Object)this.hideAttributes)).append("\n");
        sb.append("    readOnlyAttributes: ").append(this.toIndentedString((Object)this.readOnlyAttributes)).append("\n");
        sb.append("    autoRefreshInSeconds: ").append(this.toIndentedString((Object)this.autoRefreshInSeconds)).append("\n");
        sb.append("    hiddenFunctionality: ").append(this.toIndentedString((Object)this.hiddenFunctionality)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

