/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(name="SwitchFilterConfiguration", description="Configuration for a boolean filter")
public class SwitchFilterConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String value1;
    private String value2;
    private String alias1;
    private String alias2;
    private Boolean startWithValue2 = false;

    public SwitchFilterConfiguration value1(String value1) {
        this.value1 = value1;
        return this;
    }

    @Schema(name="value1", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="value1")
    public String getValue1() {
        return this.value1;
    }

    public void setValue1(String value1) {
        this.value1 = value1;
    }

    public SwitchFilterConfiguration value2(String value2) {
        this.value2 = value2;
        return this;
    }

    @Schema(name="value2", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="value2")
    public String getValue2() {
        return this.value2;
    }

    public void setValue2(String value2) {
        this.value2 = value2;
    }

    public SwitchFilterConfiguration alias1(String alias1) {
        this.alias1 = alias1;
        return this;
    }

    @Schema(name="alias1", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="alias1")
    public String getAlias1() {
        return this.alias1;
    }

    public void setAlias1(String alias1) {
        this.alias1 = alias1;
    }

    public SwitchFilterConfiguration alias2(String alias2) {
        this.alias2 = alias2;
        return this;
    }

    @Schema(name="alias2", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="alias2")
    public String getAlias2() {
        return this.alias2;
    }

    public void setAlias2(String alias2) {
        this.alias2 = alias2;
    }

    public SwitchFilterConfiguration startWithValue2(Boolean startWithValue2) {
        this.startWithValue2 = startWithValue2;
        return this;
    }

    @Schema(name="startWithValue2", description="when true the filter starts with value2 selected", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="startWithValue2")
    public Boolean getStartWithValue2() {
        return this.startWithValue2;
    }

    public void setStartWithValue2(Boolean startWithValue2) {
        this.startWithValue2 = startWithValue2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SwitchFilterConfiguration switchFilterConfiguration = (SwitchFilterConfiguration)o;
        return Objects.equals(this.value1, switchFilterConfiguration.value1) && Objects.equals(this.value2, switchFilterConfiguration.value2) && Objects.equals(this.alias1, switchFilterConfiguration.alias1) && Objects.equals(this.alias2, switchFilterConfiguration.alias2) && Objects.equals(this.startWithValue2, switchFilterConfiguration.startWithValue2);
    }

    public int hashCode() {
        return Objects.hash(this.value1, this.value2, this.alias1, this.alias2, this.startWithValue2);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SwitchFilterConfiguration {\n");
        sb.append("    value1: ").append(this.toIndentedString((Object)this.value1)).append("\n");
        sb.append("    value2: ").append(this.toIndentedString((Object)this.value2)).append("\n");
        sb.append("    alias1: ").append(this.toIndentedString((Object)this.alias1)).append("\n");
        sb.append("    alias2: ").append(this.toIndentedString((Object)this.alias2)).append("\n");
        sb.append("    startWithValue2: ").append(this.toIndentedString((Object)this.startWithValue2)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

