/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.repository.events;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.quartz.JobDataMap;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.core.annotation.HandleAfterDelete;
import org.springframework.data.rest.core.annotation.HandleBeforeSave;
import org.springframework.data.rest.core.annotation.RepositoryEventHandler;
import org.springframework.stereotype.Component;
import org.tailormap.api.persistence.SearchIndex;
import org.tailormap.api.scheduling.IndexTask;
import org.tailormap.api.scheduling.TMJobDataMap;
import org.tailormap.api.scheduling.TaskManagerService;
import org.tailormap.api.scheduling.TaskType;

@Component
@RepositoryEventHandler
public class SearchIndexEventHandler {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Scheduler scheduler;
    private final TaskManagerService taskManagerService;

    public SearchIndexEventHandler(@Autowired Scheduler scheduler, @Autowired TaskManagerService taskManagerService) {
        this.scheduler = scheduler;
        this.taskManagerService = taskManagerService;
    }

    @HandleAfterDelete
    public void afterDeleteSearchIndexEventHandler(SearchIndex searchIndex) throws SchedulerException {
        JobKey jobKey;
        if (null != searchIndex.getSchedule() && null != (jobKey = this.taskManagerService.getJobKey(TaskType.INDEX, searchIndex.getSchedule().getUuid())) && this.scheduler.checkExists(jobKey)) {
            logger.info("Deleting index task {} associated with search index: {}", (Object)searchIndex.getSchedule().getUuid(), (Object)searchIndex.getName());
            boolean succes = this.scheduler.deleteJob(jobKey);
            logger.info("Task {}:{} deletion {}", new Object[]{jobKey.getGroup(), jobKey.getName(), succes ? "succeeded" : "failed"});
        }
    }

    @HandleBeforeSave
    public void beforeSaveSearchIndexEventHandler(SearchIndex searchIndex) throws SchedulerException {
        if (null != searchIndex.getSchedule()) {
            if (null == searchIndex.getSchedule().getUuid()) {
                this.validateNoTaskExistsForIndex(searchIndex);
                logger.info("Creating new task associated with search index: {}", (Object)searchIndex.getName());
                TMJobDataMap jobDataMap = new TMJobDataMap(Map.of("type", TaskType.INDEX, "description", searchIndex.getSchedule().getDescription(), "indexId", searchIndex.getId().toString()));
                if (null != searchIndex.getSchedule().getPriority() && searchIndex.getSchedule().getPriority() > 0) {
                    jobDataMap.put((Object)"priority", (Object)searchIndex.getSchedule().getPriority());
                }
                UUID uuid = this.taskManagerService.createTask(IndexTask.class, jobDataMap, searchIndex.getSchedule().getCronExpression());
                searchIndex.getSchedule().setUuid(uuid);
            } else {
                logger.info("Updating task {} associated with search index: {}", (Object)searchIndex.getSchedule().getUuid(), (Object)searchIndex.getName());
                JobKey jobKey = this.taskManagerService.getJobKey(TaskType.INDEX, searchIndex.getSchedule().getUuid());
                if (null != jobKey && this.scheduler.checkExists(jobKey)) {
                    JobDataMap jobDataMap = this.scheduler.getJobDetail(jobKey).getJobDataMap();
                    jobDataMap.put("description", searchIndex.getSchedule().getDescription());
                    jobDataMap.put("cronExpression", searchIndex.getSchedule().getCronExpression());
                    if (null != searchIndex.getSchedule().getPriority() && searchIndex.getSchedule().getPriority() > 0) {
                        jobDataMap.put("priority", (Object)searchIndex.getSchedule().getPriority());
                    }
                    this.taskManagerService.updateTask(jobKey, new TMJobDataMap((Map)jobDataMap));
                }
            }
        }
    }

    private void validateNoTaskExistsForIndex(SearchIndex searchIndex) throws SchedulerException {
        Optional<JobDataMap> jobDataMapOptional = this.scheduler.getJobKeys(GroupMatcher.groupEquals((String)TaskType.INDEX.getValue())).stream().map(jobKey -> {
            try {
                return this.scheduler.getJobDetail(jobKey).getJobDataMap();
            }
            catch (SchedulerException e) {
                logger.error("Error getting task detail", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).filter(jobDataMap -> searchIndex.getId().equals(jobDataMap.getLongValue("indexId"))).findFirst();
        if (jobDataMapOptional.isPresent()) {
            logger.warn("A scheduled task already exists for search index: {}", (Object)searchIndex.getName());
            throw new SchedulerException("A scheduled task already exists for search index: '%s'".formatted(searchIndex.getName()));
        }
    }
}

