/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.scheduling;

import ch.rasc.sse.eventbus.SseEvent;
import ch.rasc.sse.eventbus.SseEventBus;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Map;
import java.util.UUID;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.PersistJobDataAfterExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.tailormap.api.admin.model.ServerSentEvent;
import org.tailormap.api.admin.model.TaskProgressEvent;
import org.tailormap.api.scheduling.Task;
import org.tailormap.api.scheduling.TaskType;

@DisallowConcurrentExecution
@PersistJobDataAfterExecution
public class PocTask
extends QuartzJobBean
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String foo;
    private String description;
    private final SseEventBus eventBus;
    private final ObjectMapper objectMapper;

    public PocTask(SseEventBus eventBus, ObjectMapper objectMapper) {
        this.eventBus = eventBus;
        this.objectMapper = objectMapper;
    }

    protected void executeInternal(@NonNull JobExecutionContext context) {
        JobDetail jobDetail = context.getJobDetail();
        JobDataMap mergedJobDataMap = context.getMergedJobDataMap();
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        logger.debug("foo: {}", (Object)this.getFoo());
        logger.debug("executing POC task {}:{}, details: {}", new Object[]{jobDetail.getKey().getGroup(), jobDetail.getKey().getName(), mergedJobDataMap.getWrappedMap()});
        try {
            TaskProgressEvent progressEvent = new TaskProgressEvent().startedAt(OffsetDateTime.now(ZoneId.systemDefault())).type(this.getType().getValue()).taskData(Map.of("jobKey", jobDetail.getKey().getName())).uuid(UUID.fromString(jobDetail.getKey().getName()));
            for (int i = 0; i < 110; i += 10) {
                long workingTime = (long)(Math.random() * 5000.0);
                logger.debug("Working for {} ms", (Object)workingTime);
                Thread.sleep(workingTime);
                logger.debug("POC task is at {}%", (Object)i);
                context.setResult((Object)"POC task is at %d%%".formatted(i));
                this.taskProgress(progressEvent.progress(Integer.valueOf(i)).total(Integer.valueOf(100)));
            }
        }
        catch (InterruptedException e) {
            logger.error("Thread interrupted", (Throwable)e);
        }
        int executions = 1 + (Integer)mergedJobDataMap.getOrDefault((Object)"executionCount", (Object)0);
        jobDataMap.put("executionCount", executions);
        jobDataMap.put("lastExecutionFinished", (Object)Instant.now());
        jobDataMap.put("lastResult", "POC task executed successfully");
        context.setResult((Object)"POC task executed successfully");
        this.setFoo("foo executed: " + executions);
    }

    public void taskProgress(TaskProgressEvent event) {
        ServerSentEvent serverSentEvent = new ServerSentEvent().eventType(ServerSentEvent.EventTypeEnum.TASK_PROGRESS).details((Object)event);
        try {
            this.eventBus.handleEvent(SseEvent.of((String)"message", (Object)this.objectMapper.writeValueAsString((Object)serverSentEvent)));
        }
        catch (JsonProcessingException e) {
            logger.error("Error publishing poc task progress event", (Throwable)e);
        }
    }

    public String getFoo() {
        return this.foo;
    }

    public void setFoo(String foo) {
        this.foo = foo;
    }

    public TaskType getType() {
        return TaskType.POC;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

