/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.tailormap.api.persistence.json.TMGeometryType;
import org.tailormap.api.viewer.model.Attribute;
import org.tailormap.api.viewer.model.LayerDetailsForm;

@Schema(name="LayerDetails", description="All details of an app layer.")
public class LayerDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String featureTypeName;
    private String serviceId;
    private String geometryAttribute;
    private Integer geometryAttributeIndex;
    private TMGeometryType geometryType;
    private Boolean editable = false;
    private LayerDetailsForm form = null;
    @Valid
    private @Valid List<@Valid Attribute> attributes = new ArrayList();

    public LayerDetails id(String id) {
        this.id = id;
        return this;
    }

    @NotNull
    @Schema(name="id", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public LayerDetails featureTypeName(String featureTypeName) {
        this.featureTypeName = featureTypeName;
        return this;
    }

    @Schema(name="featureTypeName", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="featureTypeName")
    public String getFeatureTypeName() {
        return this.featureTypeName;
    }

    public void setFeatureTypeName(String featureTypeName) {
        this.featureTypeName = featureTypeName;
    }

    public LayerDetails serviceId(String serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    @NotNull
    @Schema(name="serviceId", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="serviceId")
    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public LayerDetails geometryAttribute(String geometryAttribute) {
        this.geometryAttribute = geometryAttribute;
        return this;
    }

    @Schema(name="geometryAttribute", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="geometryAttribute")
    public String getGeometryAttribute() {
        return this.geometryAttribute;
    }

    public void setGeometryAttribute(String geometryAttribute) {
        this.geometryAttribute = geometryAttribute;
    }

    public LayerDetails geometryAttributeIndex(Integer geometryAttributeIndex) {
        this.geometryAttributeIndex = geometryAttributeIndex;
        return this;
    }

    @Schema(name="geometryAttributeIndex", description="index of the geometryAttribute in the array of attributes.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="geometryAttributeIndex")
    public Integer getGeometryAttributeIndex() {
        return this.geometryAttributeIndex;
    }

    public void setGeometryAttributeIndex(Integer geometryAttributeIndex) {
        this.geometryAttributeIndex = geometryAttributeIndex;
    }

    public LayerDetails geometryType(TMGeometryType geometryType) {
        this.geometryType = geometryType;
        return this;
    }

    @Valid
    @Schema(name="geometryType", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="geometryType")
    public TMGeometryType getGeometryType() {
        return this.geometryType;
    }

    public void setGeometryType(TMGeometryType geometryType) {
        this.geometryType = geometryType;
    }

    public LayerDetails editable(Boolean editable) {
        this.editable = editable;
        return this;
    }

    @Schema(name="editable", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="editable")
    public Boolean getEditable() {
        return this.editable;
    }

    public void setEditable(Boolean editable) {
        this.editable = editable;
    }

    public LayerDetails form(LayerDetailsForm form) {
        this.form = form;
        return this;
    }

    @Valid
    @Schema(name="form", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="form")
    public LayerDetailsForm getForm() {
        return this.form;
    }

    public void setForm(LayerDetailsForm form) {
        this.form = form;
    }

    public LayerDetails attributes(List<@Valid Attribute> attributes) {
        this.attributes = attributes;
        return this;
    }

    public LayerDetails addAttributesItem(Attribute attributesItem) {
        if (this.attributes == null) {
            this.attributes = new ArrayList();
        }
        this.attributes.add(attributesItem);
        return this;
    }

    @Valid
    @Schema(name="attributes", description=" Array with attributes. **note** that the ordering of this array is determined in the backend and does not need to coincide with the actual data in the data source. ", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="attributes")
    public @Valid List<@Valid Attribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<@Valid Attribute> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LayerDetails layerDetails = (LayerDetails)o;
        return Objects.equals(this.id, layerDetails.id) && Objects.equals(this.featureTypeName, layerDetails.featureTypeName) && Objects.equals(this.serviceId, layerDetails.serviceId) && Objects.equals(this.geometryAttribute, layerDetails.geometryAttribute) && Objects.equals(this.geometryAttributeIndex, layerDetails.geometryAttributeIndex) && Objects.equals(this.geometryType, layerDetails.geometryType) && Objects.equals(this.editable, layerDetails.editable) && Objects.equals(this.form, layerDetails.form) && Objects.equals(this.attributes, layerDetails.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.featureTypeName, this.serviceId, this.geometryAttribute, this.geometryAttributeIndex, this.geometryType, this.editable, this.form, this.attributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LayerDetails {\n");
        sb.append("    id: ").append(this.toIndentedString((Object)this.id)).append("\n");
        sb.append("    featureTypeName: ").append(this.toIndentedString((Object)this.featureTypeName)).append("\n");
        sb.append("    serviceId: ").append(this.toIndentedString((Object)this.serviceId)).append("\n");
        sb.append("    geometryAttribute: ").append(this.toIndentedString((Object)this.geometryAttribute)).append("\n");
        sb.append("    geometryAttributeIndex: ").append(this.toIndentedString((Object)this.geometryAttributeIndex)).append("\n");
        sb.append("    geometryType: ").append(this.toIndentedString((Object)this.geometryType)).append("\n");
        sb.append("    editable: ").append(this.toIndentedString((Object)this.editable)).append("\n");
        sb.append("    form: ").append(this.toIndentedString((Object)this.form)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString((Object)this.attributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

