/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.tailormap.api.viewer.model.SearchDocument;

@Schema(name="SearchResponse", description="A -possibly empty- list of search documents that fulfill the requested conditions and some metadata.")
public class SearchResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long start = null;
    private Long total;
    private Float maxScore = null;
    @Valid
    private @Valid List<@Valid SearchDocument> documents = new ArrayList();

    public SearchResponse start(Long start) {
        this.start = start;
        return this;
    }

    @Min(value=0L)
    @Schema(name="start", description="requested start point, this will allow the client to request the next or previous page by adding or removing 1 or more. See also https://solr.apache.org/guide/solr/latest/query-guide/common-query-parameters.html#start-parameter", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="start")
    public @Min(value=0L) Long getStart() {
        return this.start;
    }

    public void setStart(Long start) {
        this.start = start;
    }

    public SearchResponse total(Long total) {
        this.total = total;
        return this;
    }

    @Schema(name="total", description="the total number of available search documents, could be an estimated value.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="total")
    public Long getTotal() {
        return this.total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public SearchResponse maxScore(Float maxScore) {
        this.maxScore = maxScore;
        return this;
    }

    @Schema(name="maxScore", description="the maximum score of the search documents. Commonly `null` for wildcard searches as these are filters and don't score.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="maxScore")
    public Float getMaxScore() {
        return this.maxScore;
    }

    public void setMaxScore(Float maxScore) {
        this.maxScore = maxScore;
    }

    public SearchResponse documents(List<@Valid SearchDocument> documents) {
        this.documents = documents;
        return this;
    }

    public SearchResponse addDocumentsItem(SearchDocument documentsItem) {
        if (this.documents == null) {
            this.documents = new ArrayList();
        }
        this.documents.add(documentsItem);
        return this;
    }

    @Valid
    @Size(min=0)
    @Schema(name="documents", description="list of search documents. When the pagenumber*pagesize exceeds the number of documents this list will be empty", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="documents")
    public @Valid @Size(min=0) List<@Valid SearchDocument> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<@Valid SearchDocument> documents) {
        this.documents = documents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchResponse searchResponse = (SearchResponse)o;
        return Objects.equals(this.start, searchResponse.start) && Objects.equals(this.total, searchResponse.total) && Objects.equals(this.maxScore, searchResponse.maxScore) && Objects.equals(this.documents, searchResponse.documents);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.total, this.maxScore, this.documents);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchResponse {\n");
        sb.append("    start: ").append(this.toIndentedString((Object)this.start)).append("\n");
        sb.append("    total: ").append(this.toIndentedString((Object)this.total)).append("\n");
        sb.append("    maxScore: ").append(this.toIndentedString((Object)this.maxScore)).append("\n");
        sb.append("    documents: ").append(this.toIndentedString((Object)this.documents)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

