/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.format.annotation.DateTimeFormat;
import org.tailormap.api.persistence.json.AttributeValueSettings;

@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(name="Filter_editConfiguration", description="configuration for editing filter")
@JsonTypeName(value="Filter_editConfiguration")
public class FilterEditConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private FilterToolEnum filterTool;
    private Double minimumValue;
    private Double maximumValue;
    private Double initialValue;
    private Double initialLowerValue;
    private Double initialUpperValue;
    private InputModeEnum inputMode = InputModeEnum.SLIDER;
    private Double stepSize;
    @Valid
    private @Valid List<@Valid AttributeValueSettings> attributeValuesSettings = new ArrayList<AttributeValueSettings>();
    private String value1;
    private String value2;
    private String alias1;
    private String alias2;
    private Boolean startWithValue2 = false;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime initialDate;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime initialLowerDate;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime initialUpperDate;

    public FilterEditConfiguration filterTool(FilterToolEnum filterTool) {
        this.filterTool = filterTool;
        return this;
    }

    @Schema(name="filterTool", description="the type of filter tool", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="filterTool")
    public FilterToolEnum getFilterTool() {
        return this.filterTool;
    }

    public void setFilterTool(FilterToolEnum filterTool) {
        this.filterTool = filterTool;
    }

    public FilterEditConfiguration minimumValue(Double minimumValue) {
        this.minimumValue = minimumValue;
        return this;
    }

    @Schema(name="minimumValue", description="minimum value for the slider", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="minimumValue")
    public Double getMinimumValue() {
        return this.minimumValue;
    }

    public void setMinimumValue(Double minimumValue) {
        this.minimumValue = minimumValue;
    }

    public FilterEditConfiguration maximumValue(Double maximumValue) {
        this.maximumValue = maximumValue;
        return this;
    }

    @Schema(name="maximumValue", description="maximum value for the slider", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="maximumValue")
    public Double getMaximumValue() {
        return this.maximumValue;
    }

    public void setMaximumValue(Double maximumValue) {
        this.maximumValue = maximumValue;
    }

    public FilterEditConfiguration initialValue(Double initialValue) {
        this.initialValue = initialValue;
        return this;
    }

    @Schema(name="initialValue", description="initial value for the slider", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="initialValue")
    public Double getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(Double initialValue) {
        this.initialValue = initialValue;
    }

    public FilterEditConfiguration initialLowerValue(Double initialLowerValue) {
        this.initialLowerValue = initialLowerValue;
        return this;
    }

    @Schema(name="initialLowerValue", description="initial lower value for a slider filter with between condition", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="initialLowerValue")
    public Double getInitialLowerValue() {
        return this.initialLowerValue;
    }

    public void setInitialLowerValue(Double initialLowerValue) {
        this.initialLowerValue = initialLowerValue;
    }

    public FilterEditConfiguration initialUpperValue(Double initialUpperValue) {
        this.initialUpperValue = initialUpperValue;
        return this;
    }

    @Schema(name="initialUpperValue", description="initial upper value for a slider filter with between condition", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="initialUpperValue")
    public Double getInitialUpperValue() {
        return this.initialUpperValue;
    }

    public void setInitialUpperValue(Double initialUpperValue) {
        this.initialUpperValue = initialUpperValue;
    }

    public FilterEditConfiguration inputMode(InputModeEnum inputMode) {
        this.inputMode = inputMode;
        return this;
    }

    @Schema(name="inputMode", description="the mode of input for the filter", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="inputMode")
    public InputModeEnum getInputMode() {
        return this.inputMode;
    }

    public void setInputMode(InputModeEnum inputMode) {
        this.inputMode = inputMode;
    }

    public FilterEditConfiguration stepSize(Double stepSize) {
        this.stepSize = stepSize;
        return this;
    }

    @Schema(name="stepSize", description="the step size for the slider", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="stepSize")
    public Double getStepSize() {
        return this.stepSize;
    }

    public void setStepSize(Double stepSize) {
        this.stepSize = stepSize;
    }

    public FilterEditConfiguration attributeValuesSettings(List<@Valid AttributeValueSettings> attributeValuesSettings) {
        this.attributeValuesSettings = attributeValuesSettings;
        return this;
    }

    public FilterEditConfiguration addAttributeValuesSettingsItem(AttributeValueSettings attributeValuesSettingsItem) {
        if (this.attributeValuesSettings == null) {
            this.attributeValuesSettings = new ArrayList<AttributeValueSettings>();
        }
        this.attributeValuesSettings.add(attributeValuesSettingsItem);
        return this;
    }

    @Valid
    @Schema(name="attributeValuesSettings", description="settings for the attribute values", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="attributeValuesSettings")
    public @Valid List<@Valid AttributeValueSettings> getAttributeValuesSettings() {
        return this.attributeValuesSettings;
    }

    public void setAttributeValuesSettings(List<@Valid AttributeValueSettings> attributeValuesSettings) {
        this.attributeValuesSettings = attributeValuesSettings;
    }

    public FilterEditConfiguration value1(String value1) {
        this.value1 = value1;
        return this;
    }

    @Schema(name="value1", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="value1")
    public String getValue1() {
        return this.value1;
    }

    public void setValue1(String value1) {
        this.value1 = value1;
    }

    public FilterEditConfiguration value2(String value2) {
        this.value2 = value2;
        return this;
    }

    @Schema(name="value2", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="value2")
    public String getValue2() {
        return this.value2;
    }

    public void setValue2(String value2) {
        this.value2 = value2;
    }

    public FilterEditConfiguration alias1(String alias1) {
        this.alias1 = alias1;
        return this;
    }

    @Schema(name="alias1", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="alias1")
    public String getAlias1() {
        return this.alias1;
    }

    public void setAlias1(String alias1) {
        this.alias1 = alias1;
    }

    public FilterEditConfiguration alias2(String alias2) {
        this.alias2 = alias2;
        return this;
    }

    @Schema(name="alias2", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="alias2")
    public String getAlias2() {
        return this.alias2;
    }

    public void setAlias2(String alias2) {
        this.alias2 = alias2;
    }

    public FilterEditConfiguration startWithValue2(Boolean startWithValue2) {
        this.startWithValue2 = startWithValue2;
        return this;
    }

    @Schema(name="startWithValue2", description="when true the filter starts with value2 selected", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="startWithValue2")
    public Boolean getStartWithValue2() {
        return this.startWithValue2;
    }

    public void setStartWithValue2(Boolean startWithValue2) {
        this.startWithValue2 = startWithValue2;
    }

    public FilterEditConfiguration initialDate(OffsetDateTime initialDate) {
        this.initialDate = initialDate;
        return this;
    }

    @Valid
    @Schema(name="initialDate", description="initial value for the date filter", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="initialDate")
    public OffsetDateTime getInitialDate() {
        return this.initialDate;
    }

    public void setInitialDate(OffsetDateTime initialDate) {
        this.initialDate = initialDate;
    }

    public FilterEditConfiguration initialLowerDate(OffsetDateTime initialLowerDate) {
        this.initialLowerDate = initialLowerDate;
        return this;
    }

    @Valid
    @Schema(name="initialLowerDate", description="initial lower value for a date filter with between condition", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="initialLowerDate")
    public OffsetDateTime getInitialLowerDate() {
        return this.initialLowerDate;
    }

    public void setInitialLowerDate(OffsetDateTime initialLowerDate) {
        this.initialLowerDate = initialLowerDate;
    }

    public FilterEditConfiguration initialUpperDate(OffsetDateTime initialUpperDate) {
        this.initialUpperDate = initialUpperDate;
        return this;
    }

    @Valid
    @Schema(name="initialUpperDate", description="initial upper value for a date filter with between condition", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="initialUpperDate")
    public OffsetDateTime getInitialUpperDate() {
        return this.initialUpperDate;
    }

    public void setInitialUpperDate(OffsetDateTime initialUpperDate) {
        this.initialUpperDate = initialUpperDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterEditConfiguration filterEditConfiguration = (FilterEditConfiguration)o;
        return Objects.equals((Object)this.filterTool, (Object)filterEditConfiguration.filterTool) && Objects.equals(this.minimumValue, filterEditConfiguration.minimumValue) && Objects.equals(this.maximumValue, filterEditConfiguration.maximumValue) && Objects.equals(this.initialValue, filterEditConfiguration.initialValue) && Objects.equals(this.initialLowerValue, filterEditConfiguration.initialLowerValue) && Objects.equals(this.initialUpperValue, filterEditConfiguration.initialUpperValue) && Objects.equals((Object)this.inputMode, (Object)filterEditConfiguration.inputMode) && Objects.equals(this.stepSize, filterEditConfiguration.stepSize) && Objects.equals(this.attributeValuesSettings, filterEditConfiguration.attributeValuesSettings) && Objects.equals(this.value1, filterEditConfiguration.value1) && Objects.equals(this.value2, filterEditConfiguration.value2) && Objects.equals(this.alias1, filterEditConfiguration.alias1) && Objects.equals(this.alias2, filterEditConfiguration.alias2) && Objects.equals(this.startWithValue2, filterEditConfiguration.startWithValue2) && Objects.equals(this.initialDate, filterEditConfiguration.initialDate) && Objects.equals(this.initialLowerDate, filterEditConfiguration.initialLowerDate) && Objects.equals(this.initialUpperDate, filterEditConfiguration.initialUpperDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.filterTool, this.minimumValue, this.maximumValue, this.initialValue, this.initialLowerValue, this.initialUpperValue, this.inputMode, this.stepSize, this.attributeValuesSettings, this.value1, this.value2, this.alias1, this.alias2, this.startWithValue2, this.initialDate, this.initialLowerDate, this.initialUpperDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FilterEditConfiguration {\n");
        sb.append("    filterTool: ").append(this.toIndentedString((Object)this.filterTool)).append("\n");
        sb.append("    minimumValue: ").append(this.toIndentedString(this.minimumValue)).append("\n");
        sb.append("    maximumValue: ").append(this.toIndentedString(this.maximumValue)).append("\n");
        sb.append("    initialValue: ").append(this.toIndentedString(this.initialValue)).append("\n");
        sb.append("    initialLowerValue: ").append(this.toIndentedString(this.initialLowerValue)).append("\n");
        sb.append("    initialUpperValue: ").append(this.toIndentedString(this.initialUpperValue)).append("\n");
        sb.append("    inputMode: ").append(this.toIndentedString((Object)this.inputMode)).append("\n");
        sb.append("    stepSize: ").append(this.toIndentedString(this.stepSize)).append("\n");
        sb.append("    attributeValuesSettings: ").append(this.toIndentedString(this.attributeValuesSettings)).append("\n");
        sb.append("    value1: ").append(this.toIndentedString(this.value1)).append("\n");
        sb.append("    value2: ").append(this.toIndentedString(this.value2)).append("\n");
        sb.append("    alias1: ").append(this.toIndentedString(this.alias1)).append("\n");
        sb.append("    alias2: ").append(this.toIndentedString(this.alias2)).append("\n");
        sb.append("    startWithValue2: ").append(this.toIndentedString(this.startWithValue2)).append("\n");
        sb.append("    initialDate: ").append(this.toIndentedString(this.initialDate)).append("\n");
        sb.append("    initialLowerDate: ").append(this.toIndentedString(this.initialLowerDate)).append("\n");
        sb.append("    initialUpperDate: ").append(this.toIndentedString(this.initialUpperDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum InputModeEnum {
        SLIDER("SLIDER"),
        INPUT_FIELD("INPUT_FIELD"),
        SLIDER_AND_INPUT_FIELD("SLIDER_AND_INPUT_FIELD");

        private final String value;

        private InputModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static InputModeEnum fromValue(String value) {
            for (InputModeEnum b : InputModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum FilterToolEnum {
        SLIDER("SLIDER"),
        CHECKBOX("CHECKBOX"),
        SWITCH("SWITCH"),
        DATE_PICKER("DATE_PICKER"),
        DROPDOWN_LIST("DROPDOWN_LIST");

        private final String value;

        private FilterToolEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FilterToolEnum fromValue(String value) {
            for (FilterToolEnum b : FilterToolEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

