/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.tailormap.api.persistence.json.AuthorizationRule;
import org.tailormap.api.persistence.json.Bounds;
import org.tailormap.api.persistence.json.FeatureTypeRef;
import org.tailormap.api.persistence.json.TileLayerHiDpiMode;

@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(name="XYZLayerSettings", description="Settings applying to a XYZ layer.")
public class XYZLayerSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String title = null;
    private Boolean hiDpiDisabled = null;
    private FeatureTypeRef featureType;
    private String attribution = null;
    private String description = null;
    private String legendImageId = null;
    @Valid
    private @Valid List<@Valid AuthorizationRule> authorizationRules = new ArrayList<AuthorizationRule>();
    private Integer minZoom = null;
    private Integer maxZoom = null;
    private Integer tileSize = null;
    private Bounds tileGridExtent;
    private TileLayerHiDpiMode hiDpiMode;
    private String hiDpiSubstituteLayer = null;

    public XYZLayerSettings title(String title) {
        this.title = title;
        return this;
    }

    @Schema(name="title", description="Override default title, null if not overridden.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public XYZLayerSettings hiDpiDisabled(Boolean hiDpiDisabled) {
        this.hiDpiDisabled = hiDpiDisabled;
        return this;
    }

    @Schema(name="hiDpiDisabled", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="hiDpiDisabled")
    public Boolean getHiDpiDisabled() {
        return this.hiDpiDisabled;
    }

    public void setHiDpiDisabled(Boolean hiDpiDisabled) {
        this.hiDpiDisabled = hiDpiDisabled;
    }

    public XYZLayerSettings featureType(FeatureTypeRef featureType) {
        this.featureType = featureType;
        return this;
    }

    @Valid
    @Schema(name="featureType", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="featureType")
    public FeatureTypeRef getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(FeatureTypeRef featureType) {
        this.featureType = featureType;
    }

    public XYZLayerSettings attribution(String attribution) {
        this.attribution = attribution;
        return this;
    }

    @Schema(name="attribution", description="Attribution to show for this layer.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="attribution")
    public String getAttribution() {
        return this.attribution;
    }

    public void setAttribution(String attribution) {
        this.attribution = attribution;
    }

    public XYZLayerSettings description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="Description to show for this layer.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public XYZLayerSettings legendImageId(String legendImageId) {
        this.legendImageId = legendImageId;
        return this;
    }

    @Schema(name="legendImageId", description="ID of uploaded legend image", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="legendImageId")
    public String getLegendImageId() {
        return this.legendImageId;
    }

    public void setLegendImageId(String legendImageId) {
        this.legendImageId = legendImageId;
    }

    public XYZLayerSettings authorizationRules(List<@Valid AuthorizationRule> authorizationRules) {
        this.authorizationRules = authorizationRules;
        return this;
    }

    public XYZLayerSettings addAuthorizationRulesItem(AuthorizationRule authorizationRulesItem) {
        if (this.authorizationRules == null) {
            this.authorizationRules = new ArrayList<AuthorizationRule>();
        }
        this.authorizationRules.add(authorizationRulesItem);
        return this;
    }

    @Valid
    @Schema(name="authorizationRules", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="authorizationRules")
    public @Valid List<@Valid AuthorizationRule> getAuthorizationRules() {
        return this.authorizationRules;
    }

    public void setAuthorizationRules(List<@Valid AuthorizationRule> authorizationRules) {
        this.authorizationRules = authorizationRules;
    }

    public XYZLayerSettings minZoom(Integer minZoom) {
        this.minZoom = minZoom;
        return this;
    }

    @Schema(name="minZoom", description="minZoom property of OpenLayers XYZ source", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="minZoom")
    public Integer getMinZoom() {
        return this.minZoom;
    }

    public void setMinZoom(Integer minZoom) {
        this.minZoom = minZoom;
    }

    public XYZLayerSettings maxZoom(Integer maxZoom) {
        this.maxZoom = maxZoom;
        return this;
    }

    @Schema(name="maxZoom", description="maxZoom property of OpenLayers XYZ source", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="maxZoom")
    public Integer getMaxZoom() {
        return this.maxZoom;
    }

    public void setMaxZoom(Integer maxZoom) {
        this.maxZoom = maxZoom;
    }

    public XYZLayerSettings tileSize(Integer tileSize) {
        this.tileSize = tileSize;
        return this;
    }

    @Schema(name="tileSize", description="tile size property of OpenLayers XYZ source", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tileSize")
    public Integer getTileSize() {
        return this.tileSize;
    }

    public void setTileSize(Integer tileSize) {
        this.tileSize = tileSize;
    }

    public XYZLayerSettings tileGridExtent(Bounds tileGridExtent) {
        this.tileGridExtent = tileGridExtent;
        return this;
    }

    @Valid
    @Schema(name="tileGridExtent", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tileGridExtent")
    public Bounds getTileGridExtent() {
        return this.tileGridExtent;
    }

    public void setTileGridExtent(Bounds tileGridExtent) {
        this.tileGridExtent = tileGridExtent;
    }

    public XYZLayerSettings hiDpiMode(TileLayerHiDpiMode hiDpiMode) {
        this.hiDpiMode = hiDpiMode;
        return this;
    }

    @Valid
    @Schema(name="hiDpiMode", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="hiDpiMode")
    public TileLayerHiDpiMode getHiDpiMode() {
        return this.hiDpiMode;
    }

    public void setHiDpiMode(TileLayerHiDpiMode hiDpiMode) {
        this.hiDpiMode = hiDpiMode;
    }

    public XYZLayerSettings hiDpiSubstituteLayer(String hiDpiSubstituteLayer) {
        this.hiDpiSubstituteLayer = hiDpiSubstituteLayer;
        return this;
    }

    @Schema(name="hiDpiSubstituteLayer", description="Alternate URL template to use when rendering at high dpi (using 'layer' instead of 'url' in the name for ease of use).", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="hiDpiSubstituteLayer")
    public String getHiDpiSubstituteLayer() {
        return this.hiDpiSubstituteLayer;
    }

    public void setHiDpiSubstituteLayer(String hiDpiSubstituteLayer) {
        this.hiDpiSubstituteLayer = hiDpiSubstituteLayer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XYZLayerSettings xyZLayerSettings = (XYZLayerSettings)o;
        return Objects.equals(this.title, xyZLayerSettings.title) && Objects.equals(this.hiDpiDisabled, xyZLayerSettings.hiDpiDisabled) && Objects.equals(this.featureType, xyZLayerSettings.featureType) && Objects.equals(this.attribution, xyZLayerSettings.attribution) && Objects.equals(this.description, xyZLayerSettings.description) && Objects.equals(this.legendImageId, xyZLayerSettings.legendImageId) && Objects.equals(this.authorizationRules, xyZLayerSettings.authorizationRules) && Objects.equals(this.minZoom, xyZLayerSettings.minZoom) && Objects.equals(this.maxZoom, xyZLayerSettings.maxZoom) && Objects.equals(this.tileSize, xyZLayerSettings.tileSize) && Objects.equals(this.tileGridExtent, xyZLayerSettings.tileGridExtent) && Objects.equals(this.hiDpiMode, xyZLayerSettings.hiDpiMode) && Objects.equals(this.hiDpiSubstituteLayer, xyZLayerSettings.hiDpiSubstituteLayer);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.hiDpiDisabled, this.featureType, this.attribution, this.description, this.legendImageId, this.authorizationRules, this.minZoom, this.maxZoom, this.tileSize, this.tileGridExtent, this.hiDpiMode, this.hiDpiSubstituteLayer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class XYZLayerSettings {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    hiDpiDisabled: ").append(this.toIndentedString(this.hiDpiDisabled)).append("\n");
        sb.append("    featureType: ").append(this.toIndentedString(this.featureType)).append("\n");
        sb.append("    attribution: ").append(this.toIndentedString(this.attribution)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    legendImageId: ").append(this.toIndentedString(this.legendImageId)).append("\n");
        sb.append("    authorizationRules: ").append(this.toIndentedString(this.authorizationRules)).append("\n");
        sb.append("    minZoom: ").append(this.toIndentedString(this.minZoom)).append("\n");
        sb.append("    maxZoom: ").append(this.toIndentedString(this.maxZoom)).append("\n");
        sb.append("    tileSize: ").append(this.toIndentedString(this.tileSize)).append("\n");
        sb.append("    tileGridExtent: ").append(this.toIndentedString(this.tileGridExtent)).append("\n");
        sb.append("    hiDpiMode: ").append(this.toIndentedString(this.hiDpiMode)).append("\n");
        sb.append("    hiDpiSubstituteLayer: ").append(this.toIndentedString(this.hiDpiSubstituteLayer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

