/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.repository.validation;

import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;
import org.tailormap.api.persistence.GeoService;
import org.tailormap.api.persistence.helper.GeoServiceHelper;
import org.tailormap.api.persistence.json.GeoServiceProtocol;
import org.tailormap.api.util.TMExceptionUtils;

@Component
public class GeoServiceValidator
implements Validator {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final GeoServiceHelper geoServiceHelper;

    public GeoServiceValidator(GeoServiceHelper geoServiceHelper) {
        this.geoServiceHelper = geoServiceHelper;
    }

    public boolean supports(@NonNull Class<?> clazz) {
        return GeoService.class.isAssignableFrom(clazz);
    }

    public void validate(@NonNull Object target, @NonNull Errors errors) {
        URI uri;
        GeoService service = (GeoService)target;
        logger.debug("Validate service {}, refresh capabilities {}, url {}", new Object[]{service.getId(), service.isRefreshCapabilities(), service.getUrl()});
        if (errors.getFieldError("url") != null) {
            return;
        }
        try {
            uri = service.getProtocol() == GeoServiceProtocol.XYZ ? new URL(service.getUrl().replaceAll("\\{[a-z\\-]+}", "")).toURI() : new URL(service.getUrl()).toURI();
        }
        catch (Exception e) {
            errors.rejectValue("url", "invalid", "Invalid URI");
            return;
        }
        if (!"https".equals(uri.getScheme()) && !"http".equals(uri.getScheme())) {
            errors.rejectValue("url", "invalid-scheme", "Invalid URI scheme");
            return;
        }
        if (service.isRefreshCapabilities() || GeoServiceProtocol.XYZ.equals(service.getProtocol())) {
            try {
                this.geoServiceHelper.loadServiceCapabilities(service);
            }
            catch (UnknownHostException e) {
                errors.rejectValue("url", "unknown-host", "Unknown host: \"" + uri.getHost() + "\"");
            }
            catch (Exception e) {
                String msg = String.format("Error loading capabilities from URL \"%s\": %s", service.getUrl(), TMExceptionUtils.joinAllThrowableMessages(e));
                logger.info("The following exception may not be an application error but could be a problem with an external service or user-entered data: {}", (Object)msg, (Object)e);
                errors.rejectValue("url", "loading-capabilities-failed", msg);
            }
        }
    }
}

