/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.scheduling;

import java.lang.invoke.MethodHandles;
import org.quartz.JobExecutionContext;
import org.quartz.Trigger;
import org.quartz.TriggerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DebugLoggingTriggerListener
implements TriggerListener {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public boolean vetoJobExecution(Trigger trigger, JobExecutionContext context) {
        return false;
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public void triggerFired(Trigger trigger, JobExecutionContext context) {
        if (logger.isDebugEnabled()) {
            logger.debug("Trigger {}:{} fired.", (Object)trigger.getKey().getGroup(), (Object)trigger.getKey().getName());
        }
    }

    public void triggerMisfired(Trigger trigger) {
        if (logger.isDebugEnabled()) {
            logger.warn("Trigger {}:{} misfired.", (Object)trigger.getKey().getGroup(), (Object)trigger.getKey().getName());
        }
    }

    public void triggerComplete(Trigger trigger, JobExecutionContext context, Trigger.CompletedExecutionInstruction triggerInstructionCode) {
        if (logger.isDebugEnabled()) {
            context.getJobDetail().getJobDataMap().put("runtime", context.getJobRunTime());
            logger.debug("Trigger {}:{} completed with instruction code {}.", new Object[]{trigger.getKey().getGroup(), trigger.getKey().getName(), triggerInstructionCode});
            logger.debug("Job data map after trigger complete: {}", (Object)context.getMergedJobDataMap().getWrappedMap());
        }
    }
}

