/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.security;

import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.server.Cookie;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationEventPublisher;
import org.springframework.security.authentication.DefaultAuthenticationEventPublisher;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2LoginConfigurer;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.core.oidc.user.OidcUserAuthority;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRequestAttributeHandler;
import org.springframework.security.web.csrf.CsrfTokenRequestHandler;
import org.tailormap.api.repository.GroupRepository;
import org.tailormap.api.repository.OIDCConfigurationRepository;
import org.tailormap.api.security.AuditInterceptor;
import org.tailormap.api.security.CsrfCookieFilter;
import org.tailormap.api.security.OIDCRepository;
import org.tailormap.api.security.events.DefaultAuthenticationFailureEvent;
import org.tailormap.api.security.events.OAuth2AuthenticationFailureEvent;

@Configuration
@EnableWebSecurity
@EnableMethodSecurity
public class ApiSecurityConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Value(value="${tailormap-api.base-path}")
    private String apiBasePath;
    @Value(value="${tailormap-api.admin.base-path}")
    private String adminApiBasePath;
    @Value(value="${tailormap-api.security.disable-csrf:false}")
    private boolean disableCsrf;

    @Bean
    public CookieCsrfTokenRepository csrfTokenRepository() {
        CookieCsrfTokenRepository csrfTokenRepository = CookieCsrfTokenRepository.withHttpOnlyFalse();
        csrfTokenRepository.setCookieCustomizer(cookieCustomizer -> {
            if (cookieCustomizer.build().isSecure()) {
                cookieCustomizer.sameSite(Cookie.SameSite.NONE.attributeValue());
            }
        });
        return csrfTokenRepository;
    }

    @Bean
    public AuthenticationEventPublisher authenticationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        DefaultAuthenticationEventPublisher authenticationEventPublisher = new DefaultAuthenticationEventPublisher(applicationEventPublisher);
        authenticationEventPublisher.setAdditionalExceptionMappings(Collections.singletonMap(OAuth2AuthenticationException.class, OAuth2AuthenticationFailureEvent.class));
        authenticationEventPublisher.setDefaultAuthenticationFailureEvent(DefaultAuthenticationFailureEvent.class);
        return authenticationEventPublisher;
    }

    @Bean
    public SecurityFilterChain apiFilterChain(HttpSecurity http, CookieCsrfTokenRepository csrfTokenRepository) throws Exception {
        if (this.disableCsrf) {
            http.csrf(AbstractHttpConfigurer::disable);
        } else {
            http.csrf(csrf -> csrf.csrfTokenRequestHandler((CsrfTokenRequestHandler)new CsrfTokenRequestAttributeHandler()).csrfTokenRepository((CsrfTokenRepository)csrfTokenRepository).ignoringRequestMatchers(new String[]{this.apiBasePath + "/{viewerKind}/{viewerName}/layer/{appLayerId}/features", this.apiBasePath + "/{viewerKind}/{viewerName}/metrics/ingest/{appLayerId}/{allowedMetric}"}));
            http.addFilterAfter((Filter)new CsrfCookieFilter(), BasicAuthenticationFilter.class);
        }
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy(){

            public void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
                String redirectUrl = request.getParameter("redirectUrl");
                if (redirectUrl != null && redirectUrl.startsWith("/")) {
                    request.getSession().setAttribute("redirectUrl", (Object)redirectUrl);
                }
                super.sendRedirect(request, response, url);
            }
        };
        AuthenticationSuccessHandler authenticationSuccessHandler = (request, response, authentication) -> {
            String redirectUrl;
            HttpSession session = request.getSession(false);
            if (session != null && (redirectUrl = (String)session.getAttribute("redirectUrl")) != null) {
                response.sendRedirect(redirectUrl);
                return;
            }
            response.sendRedirect("/");
        };
        http.securityMatchers(matchers -> matchers.requestMatchers(new String[]{this.apiBasePath + "/**"})).addFilterAfter((Filter)new AuditInterceptor(), AnonymousAuthenticationFilter.class).authorizeHttpRequests(authorize -> {
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(new String[]{this.adminApiBasePath + "/**"})).hasAuthority("admin");
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorize.requestMatchers(new String[]{this.apiBasePath + "/**"})).permitAll();
        }).formLogin(formLogin -> formLogin.loginPage(this.apiBasePath + "/unauthorized").loginProcessingUrl(this.apiBasePath + "/login")).oauth2Login(arg_0 -> this.lambda$apiFilterChain$8((RedirectStrategy)redirectStrategy, authenticationSuccessHandler, arg_0)).anonymous(anonymous -> anonymous.authorities(new String[]{"anonymous"})).logout(logout -> logout.logoutUrl(this.apiBasePath + "/logout").logoutSuccessHandler((request, response, authentication) -> response.sendError(HttpStatus.OK.value(), "OK")));
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public OIDCRepository clientRegistrationRepository(OIDCConfigurationRepository repository) {
        return new OIDCRepository(repository);
    }

    @Bean
    public GrantedAuthoritiesMapper userAuthoritiesMapper(GroupRepository repository) {
        return authorities -> {
            HashSet<SimpleGrantedAuthority> mappedAuthorities = new HashSet<SimpleGrantedAuthority>();
            try {
                mappedAuthorities.addAll(authorities);
                OidcIdToken idToken = authorities.stream().filter(OidcUserAuthority.class::isInstance).map(OidcUserAuthority.class::cast).map(OidcUserAuthority::getIdToken).findFirst().orElseThrow();
                List roles = Optional.ofNullable(idToken.getClaimAsStringList("roles")).orElse(Collections.emptyList());
                for (String role : roles) {
                    mappedAuthorities.add(new SimpleGrantedAuthority(role));
                    Optional groupEntity = repository.findById(role);
                    groupEntity.ifPresent(group -> {
                        if (StringUtils.isNotBlank((CharSequence)group.getAliasForGroup())) {
                            mappedAuthorities.add(new SimpleGrantedAuthority(group.getAliasForGroup()));
                        }
                    });
                }
            }
            catch (Exception e) {
                log.error("Error mapping OIDC authorities", (Throwable)e);
            }
            return mappedAuthorities;
        };
    }

    private /* synthetic */ void lambda$apiFilterChain$8(RedirectStrategy redirectStrategy, AuthenticationSuccessHandler authenticationSuccessHandler, OAuth2LoginConfigurer login) {
        login.authorizationEndpoint(endpoint -> endpoint.baseUri(this.apiBasePath + "/oauth2/authorization").authorizationRedirectStrategy(redirectStrategy)).redirectionEndpoint(endpoint -> endpoint.baseUri(this.apiBasePath + "/oauth2/callback")).successHandler(authenticationSuccessHandler);
    }
}

