/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.tailormap.api.persistence.json.AppI18nSettings;
import org.tailormap.api.persistence.json.AppUiSettings;
import org.tailormap.api.persistence.json.FilterGroup;
import org.tailormap.api.viewer.model.AppStyling;
import org.tailormap.api.viewer.model.Component;

@Schema(name="ViewerResponse", description="Basic viewer information")
public class ViewerResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private KindEnum kind;
    private String name;
    private String title;
    @Valid
    private List<String> baseApps = new ArrayList<String>();
    private AppI18nSettings i18nSettings;
    private AppUiSettings uiSettings;
    @Valid
    private @Valid List<@Valid FilterGroup> filterGroups = new ArrayList<FilterGroup>();
    @Valid
    private List<String> projections = new ArrayList<String>();
    private AppStyling styling;
    @Valid
    private @Valid List<@Valid Component> components = new ArrayList<Component>();

    public ViewerResponse kind(KindEnum kind) {
        this.kind = kind;
        return this;
    }

    @NotNull
    @Schema(name="kind", description="Kind of viewer; a 'service' viewer has layers from a single service combined with a base viewer. A 'viewer' has content configured from various services.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="kind")
    public KindEnum getKind() {
        return this.kind;
    }

    public void setKind(KindEnum kind) {
        this.kind = kind;
    }

    public ViewerResponse name(String name) {
        this.name = name;
        return this;
    }

    @NotNull
    @Schema(name="name", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ViewerResponse title(String title) {
        this.title = title;
        return this;
    }

    @NotNull
    @Schema(name="title", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ViewerResponse baseApps(List<String> baseApps) {
        this.baseApps = baseApps;
        return this;
    }

    public ViewerResponse addBaseAppsItem(String baseAppsItem) {
        if (this.baseApps == null) {
            this.baseApps = new ArrayList<String>();
        }
        this.baseApps.add(baseAppsItem);
        return this;
    }

    @Schema(name="baseApps", description="Available base apps. The first item is the default. May have one entry if only one is available. An empty list means there are no base apps available.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="baseApps")
    public List<String> getBaseApps() {
        return this.baseApps;
    }

    public void setBaseApps(List<String> baseApps) {
        this.baseApps = baseApps;
    }

    public ViewerResponse i18nSettings(AppI18nSettings i18nSettings) {
        this.i18nSettings = i18nSettings;
        return this;
    }

    @Valid
    @Schema(name="i18nSettings", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="i18nSettings")
    public AppI18nSettings getI18nSettings() {
        return this.i18nSettings;
    }

    public void setI18nSettings(AppI18nSettings i18nSettings) {
        this.i18nSettings = i18nSettings;
    }

    public ViewerResponse uiSettings(AppUiSettings uiSettings) {
        this.uiSettings = uiSettings;
        return this;
    }

    @Valid
    @Schema(name="uiSettings", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="uiSettings")
    public AppUiSettings getUiSettings() {
        return this.uiSettings;
    }

    public void setUiSettings(AppUiSettings uiSettings) {
        this.uiSettings = uiSettings;
    }

    public ViewerResponse filterGroups(List<@Valid FilterGroup> filterGroups) {
        this.filterGroups = filterGroups;
        return this;
    }

    public ViewerResponse addFilterGroupsItem(FilterGroup filterGroupsItem) {
        if (this.filterGroups == null) {
            this.filterGroups = new ArrayList<FilterGroup>();
        }
        this.filterGroups.add(filterGroupsItem);
        return this;
    }

    @Valid
    @Size(min=0)
    @Schema(name="filterGroups", description="List of filter groups to show in the application.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="filterGroups")
    public @Valid @Size(min=0) List<@Valid FilterGroup> getFilterGroups() {
        return this.filterGroups;
    }

    public void setFilterGroups(List<@Valid FilterGroup> filterGroups) {
        this.filterGroups = filterGroups;
    }

    public ViewerResponse projections(List<String> projections) {
        this.projections = projections;
        return this;
    }

    public ViewerResponse addProjectionsItem(String projectionsItem) {
        if (this.projections == null) {
            this.projections = new ArrayList<String>();
        }
        this.projections.add(projectionsItem);
        return this;
    }

    @NotNull
    @Schema(name="projections", description="Available projections for this application. The first item is the default. Not all layers may be available in all projections.", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="projections")
    public List<String> getProjections() {
        return this.projections;
    }

    public void setProjections(List<String> projections) {
        this.projections = projections;
    }

    public ViewerResponse styling(AppStyling styling) {
        this.styling = styling;
        return this;
    }

    @NotNull
    @Valid
    @Schema(name="styling", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="styling")
    public AppStyling getStyling() {
        return this.styling;
    }

    public void setStyling(AppStyling styling) {
        this.styling = styling;
    }

    public ViewerResponse components(List<@Valid Component> components) {
        this.components = components;
        return this;
    }

    public ViewerResponse addComponentsItem(Component componentsItem) {
        if (this.components == null) {
            this.components = new ArrayList<Component>();
        }
        this.components.add(componentsItem);
        return this;
    }

    @NotNull
    @Valid
    @Size(min=0)
    @Schema(name="components", description="Configured components (controls) for the viewer", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="components")
    public @NotNull @Valid @Size(min=0) List<@Valid Component> getComponents() {
        return this.components;
    }

    public void setComponents(List<@Valid Component> components) {
        this.components = components;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewerResponse viewerResponse = (ViewerResponse)o;
        return Objects.equals((Object)this.kind, (Object)viewerResponse.kind) && Objects.equals(this.name, viewerResponse.name) && Objects.equals(this.title, viewerResponse.title) && Objects.equals(this.baseApps, viewerResponse.baseApps) && Objects.equals(this.i18nSettings, viewerResponse.i18nSettings) && Objects.equals(this.uiSettings, viewerResponse.uiSettings) && Objects.equals(this.filterGroups, viewerResponse.filterGroups) && Objects.equals(this.projections, viewerResponse.projections) && Objects.equals(this.styling, viewerResponse.styling) && Objects.equals(this.components, viewerResponse.components);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.name, this.title, this.baseApps, this.i18nSettings, this.uiSettings, this.filterGroups, this.projections, this.styling, this.components});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ViewerResponse {\n");
        sb.append("    kind: ").append(this.toIndentedString((Object)this.kind)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    baseApps: ").append(this.toIndentedString(this.baseApps)).append("\n");
        sb.append("    i18nSettings: ").append(this.toIndentedString(this.i18nSettings)).append("\n");
        sb.append("    uiSettings: ").append(this.toIndentedString(this.uiSettings)).append("\n");
        sb.append("    filterGroups: ").append(this.toIndentedString(this.filterGroups)).append("\n");
        sb.append("    projections: ").append(this.toIndentedString(this.projections)).append("\n");
        sb.append("    styling: ").append(this.toIndentedString(this.styling)).append("\n");
        sb.append("    components: ").append(this.toIndentedString(this.components)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum KindEnum {
        SERVICE("service"),
        APP("app");

        private final String value;

        private KindEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static KindEnum fromValue(String value) {
            for (KindEnum b : KindEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

