/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.configuration.base;

import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.CacheControl;
import org.springframework.lang.NonNull;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.resource.EncodedResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolver;
import org.springframework.web.servlet.resource.ResourceTransformer;
import org.tailormap.api.configuration.CaseInsensitiveEnumConverter;
import org.tailormap.api.configuration.base.FrontControllerResolver;
import org.tailormap.api.configuration.base.IndexHtmlTransformer;
import org.tailormap.api.persistence.json.GeoServiceProtocol;
import org.tailormap.api.scheduling.TaskType;

@Configuration
public class WebMvcConfig
implements WebMvcConfigurer {
    private final FrontControllerResolver frontControllerResolver;
    private final IndexHtmlTransformer indexHtmlTransformer;
    @Value(value="${spring.web.resources.static-locations:file:/home/spring/static/}")
    private String resourceLocations;

    public WebMvcConfig(FrontControllerResolver frontControllerResolver, IndexHtmlTransformer indexHtmlTransformer) {
        this.frontControllerResolver = frontControllerResolver;
        this.indexHtmlTransformer = indexHtmlTransformer;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/version.json"}).addResourceLocations(new String[]{this.resourceLocations.split(",", -1)[0]}).setCacheControl(CacheControl.noStore());
        registry.addResourceHandler(new String[]{"/*/*.js", "/*/*.css", "/*/*.map", "/*/media/**", "/*/icons/**"}).addResourceLocations(new String[]{this.resourceLocations.split(",", -1)[0]}).setCacheControl(CacheControl.maxAge((long)7L, (TimeUnit)TimeUnit.DAYS).mustRevalidate()).resourceChain(true).addResolver((ResourceResolver)new EncodedResourceResolver());
        registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{this.resourceLocations.split(",", -1)[0]}).setCacheControl(CacheControl.noCache()).resourceChain(false).addResolver((ResourceResolver)this.frontControllerResolver).addResolver((ResourceResolver)new EncodedResourceResolver()).addTransformer((ResourceTransformer)this.indexHtmlTransformer);
    }

    public void addFormatters(@NonNull FormatterRegistry registry) {
        registry.addConverter(String.class, GeoServiceProtocol.class, (Converter)new CaseInsensitiveEnumConverter(GeoServiceProtocol.class));
        registry.addConverter(String.class, TaskType.class, (Converter)new CaseInsensitiveEnumConverter(TaskType.class));
    }
}

