/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.persistence;

import io.hypersistence.utils.hibernate.type.json.JsonBinaryType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.PreRemove;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.Version;
import jakarta.validation.constraints.Pattern;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.hibernate.annotations.Type;
import org.hibernate.bytecode.enhance.internal.bytebuddy.InlineDirtyCheckerEqualsHelper;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.bytecode.enhance.spi.interceptor.LazyAttributeLoadingInterceptor;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ExtendedSelfDirtinessTracker;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.tailormap.api.persistence.User;
import org.tailormap.api.persistence.helper.AdminAdditionalPropertyHelper;
import org.tailormap.api.persistence.json.AdminAdditionalProperty;
import org.tailormap.api.persistence.listener.EntityEventPublisher;

@Entity
@Table(name="groups")
@EntityListeners(value={EntityEventPublisher.class})
@EnhancementInfo(version="6.6.26.Final")
public class Group
implements ManagedEntity,
PersistentAttributeInterceptable,
ExtendedSelfDirtinessTracker {
    public static final String ANONYMOUS = "anonymous";
    public static final String AUTHENTICATED = "authenticated";
    public static final String ADMIN = "admin";
    public static final String ACTUATOR = "actuator";
    @Id
    @Pattern(regexp="^[a-zA-Z0-9-_]+", message="Group name must consist of alphanumeric characters, underscore or -")
    @Pattern(regexp="^[a-zA-Z0-9-_]+", message="Group name must consist of alphanumeric characters, underscore or -") String name;
    @Version
    Long version;
    boolean systemGroup;
    String description;
    @Column(columnDefinition="text")
    String notes;
    @ManyToMany(mappedBy="groups")
    Set<User> members;
    String aliasForGroup;
    @Type(value=JsonBinaryType.class)
    @Column(columnDefinition="jsonb")
    List<AdminAdditionalProperty> additionalProperties;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient boolean $$_hibernate_useTracker;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;
    @Transient
    private transient CollectionTracker $$_hibernate_collectionTracker;

    public Group() {
        this.$$_hibernate_write_members(new HashSet());
        this.$$_hibernate_write_additionalProperties(new ArrayList());
    }

    public String getName() {
        return this.$$_hibernate_read_name();
    }

    public Group setName(String name) {
        this.$$_hibernate_write_name(name);
        return this;
    }

    public Long getVersion() {
        return this.$$_hibernate_read_version();
    }

    public Group setVersion(Long version) {
        this.$$_hibernate_write_version(version);
        return this;
    }

    public boolean isSystemGroup() {
        return this.$$_hibernate_read_systemGroup();
    }

    public Group setSystemGroup(boolean systemGroup) {
        this.$$_hibernate_write_systemGroup(systemGroup);
        return this;
    }

    public String getDescription() {
        return this.$$_hibernate_read_description();
    }

    public Group setDescription(String title) {
        this.$$_hibernate_write_description(title);
        return this;
    }

    public String getNotes() {
        return this.$$_hibernate_read_notes();
    }

    public Group setNotes(String notes) {
        this.$$_hibernate_write_notes(notes);
        return this;
    }

    public Set<User> getMembers() {
        return this.$$_hibernate_read_members();
    }

    public Group setMembers(Set<User> members) {
        this.$$_hibernate_write_members(members);
        return this;
    }

    public String getAliasForGroup() {
        return this.$$_hibernate_read_aliasForGroup();
    }

    public Group setAliasForGroup(String aliasFor) {
        this.$$_hibernate_write_aliasForGroup(aliasFor);
        return this;
    }

    public List<AdminAdditionalProperty> getAdditionalProperties() {
        return this.$$_hibernate_read_additionalProperties();
    }

    public Group setAdditionalProperties(List<AdminAdditionalProperty> additionalProperties) {
        this.$$_hibernate_write_additionalProperties(additionalProperties);
        return this;
    }

    @PreRemove
    private void removeMembers() {
        for (User user : this.$$_hibernate_read_members()) {
            user.getGroups().remove(this);
        }
    }

    public void addOrUpdateAdminProperty(String key, Object value, boolean isPublic) {
        AdminAdditionalPropertyHelper.addOrUpdateAdminProperty((List)this.$$_hibernate_read_additionalProperties(), (String)key, (Object)value, (boolean)isPublic);
    }

    public void mapAdminPropertyValue(String key, boolean isPublic, Function<Object, Object> valueMapper) {
        AdminAdditionalPropertyHelper.mapAdminPropertyValue((List)this.$$_hibernate_read_additionalProperties(), (String)key, (boolean)isPublic, valueMapper);
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public boolean $$_hibernate_useTracker() {
        return this.$$_hibernate_useTracker;
    }

    public void $$_hibernate_setUseTracker(boolean bl) {
        this.$$_hibernate_useTracker = bl;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        if (this.$$_hibernate_collectionTracker == null) {
            stringArray = this.$$_hibernate_tracker == null ? ArrayHelper.EMPTY_STRING_ARRAY : this.$$_hibernate_tracker.get();
        } else {
            if (this.$$_hibernate_tracker == null) {
                this.$$_hibernate_tracker = new SimpleFieldTracker();
            }
            this.$$_hibernate_getCollectionFieldDirtyNames(this.$$_hibernate_tracker);
            stringArray = this.$$_hibernate_tracker.get();
        }
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        Group group = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty() || this.$$_hibernate_areCollectionFieldsDirty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
        this.$$_hibernate_clearDirtyCollectionNames();
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        return this.$$_hibernate_collectionTracker;
    }

    public boolean $$_hibernate_areCollectionFieldsDirty() {
        int n;
        block4: {
            int n2;
            block5: {
                Group group = this;
                Group group2 = group;
                n2 = 0;
                if (n2 == 0 && group.$$_hibernate_collectionTracker != null) {
                    int n3 = group.$$_hibernate_collectionTracker.getSize("members");
                    if (group.members == null && n3 != -1) {
                        n2 = 1;
                    } else if (group.members != null && (!(group.members instanceof PersistentCollection) || ((PersistentCollection)group.members).wasInitialized()) && n3 != group.members.size()) {
                        n2 = 1;
                    }
                }
                if ((n = n2) != 0 || this.$$_hibernate_collectionTracker == null) break block4;
                n2 = this.$$_hibernate_collectionTracker.getSize("additionalProperties");
                if (this.additionalProperties != null || n2 == -1) break block5;
                n = 1;
                break block4;
            }
            if (this.additionalProperties == null || this.additionalProperties instanceof PersistentCollection && !((PersistentCollection)this.additionalProperties).wasInitialized() || n2 == this.additionalProperties.size()) break block4;
            n = 1;
        }
        return n != 0;
    }

    public void $$_hibernate_getCollectionFieldDirtyNames(DirtyTracker dirtyTracker) {
        block4: {
            int n;
            block5: {
                Group group = this;
                DirtyTracker dirtyTracker2 = dirtyTracker;
                Group group2 = group;
                DirtyTracker dirtyTracker3 = dirtyTracker2;
                if (group.$$_hibernate_collectionTracker != null) {
                    int n2 = group.$$_hibernate_collectionTracker.getSize("members");
                    if (group.members == null && n2 != -1) {
                        dirtyTracker2.add("members");
                    } else if (group.members != null && (!(group.members instanceof PersistentCollection) || ((PersistentCollection)group.members).wasInitialized()) && n2 != group.members.size()) {
                        dirtyTracker2.add("members");
                    }
                }
                if (this.$$_hibernate_collectionTracker == null) break block4;
                n = this.$$_hibernate_collectionTracker.getSize("additionalProperties");
                if (this.additionalProperties != null || n == -1) break block5;
                dirtyTracker.add("additionalProperties");
                break block4;
            }
            if (this.additionalProperties == null || this.additionalProperties instanceof PersistentCollection && !((PersistentCollection)this.additionalProperties).wasInitialized() || n == this.additionalProperties.size()) break block4;
            dirtyTracker.add("additionalProperties");
        }
    }

    public void $$_hibernate_clearDirtyCollectionNames() {
        if (this.$$_hibernate_collectionTracker == null) {
            this.$$_hibernate_collectionTracker = new SimpleCollectionTracker();
        }
        this.$$_hibernate_removeDirtyFields(null);
    }

    public void $$_hibernate_removeDirtyFields(LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor) {
        block6: {
            if (this.$$_hibernate_attributeInterceptor instanceof LazyAttributeLoadingInterceptor) {
                lazyAttributeLoadingInterceptor = (LazyAttributeLoadingInterceptor)this.$$_hibernate_attributeInterceptor;
            }
            Group group = this;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor2 = lazyAttributeLoadingInterceptor;
            Group group2 = group;
            LazyAttributeLoadingInterceptor lazyAttributeLoadingInterceptor3 = lazyAttributeLoadingInterceptor2;
            if (lazyAttributeLoadingInterceptor2 == null || lazyAttributeLoadingInterceptor2.isAttributeLoaded("members")) {
                if (group.members == null || group.members instanceof PersistentCollection && !((PersistentCollection)group.members).wasInitialized()) {
                    group.$$_hibernate_collectionTracker.add("members", -1);
                } else {
                    group.$$_hibernate_collectionTracker.add("members", group.members.size());
                }
            }
            if (lazyAttributeLoadingInterceptor != null && !lazyAttributeLoadingInterceptor.isAttributeLoaded("additionalProperties")) break block6;
            if (this.additionalProperties == null || this.additionalProperties instanceof PersistentCollection && !((PersistentCollection)this.additionalProperties).wasInitialized()) {
                this.$$_hibernate_collectionTracker.add("additionalProperties", -1);
            } else {
                this.$$_hibernate_collectionTracker.add("additionalProperties", this.additionalProperties.size());
            }
        }
    }

    public String $$_hibernate_read_name() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "name", (Object)this.name);
        }
        return this.name;
    }

    public void $$_hibernate_write_name(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "name", (Object)this.name, (Object)string);
            return;
        }
        this.name = string;
    }

    public Long $$_hibernate_read_version() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = (Long)this.$$_hibernate_getInterceptor().readObject((Object)this, "version", (Object)this.version);
        }
        return this.version;
    }

    public void $$_hibernate_write_version(Long l) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"version", (Object)l, (Object)this.version)) {
            this.$$_hibernate_trackChange("version");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = (Long)this.$$_hibernate_getInterceptor().writeObject((Object)this, "version", (Object)this.version, (Object)l);
            return;
        }
        this.version = l;
    }

    public boolean $$_hibernate_read_systemGroup() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.systemGroup = this.$$_hibernate_getInterceptor().readBoolean((Object)this, "systemGroup", this.systemGroup);
        }
        return this.systemGroup;
    }

    public void $$_hibernate_write_systemGroup(boolean bl) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"systemGroup", (boolean)bl, (boolean)this.systemGroup)) {
            this.$$_hibernate_trackChange("systemGroup");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.systemGroup = this.$$_hibernate_getInterceptor().writeBoolean((Object)this, "systemGroup", this.systemGroup, bl);
            return;
        }
        this.systemGroup = bl;
    }

    public String $$_hibernate_read_description() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.description = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "description", (Object)this.description);
        }
        return this.description;
    }

    public void $$_hibernate_write_description(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"description", (Object)string, (Object)this.description)) {
            this.$$_hibernate_trackChange("description");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.description = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "description", (Object)this.description, (Object)string);
            return;
        }
        this.description = string;
    }

    public String $$_hibernate_read_notes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.notes = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "notes", (Object)this.notes);
        }
        return this.notes;
    }

    public void $$_hibernate_write_notes(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"notes", (Object)string, (Object)this.notes)) {
            this.$$_hibernate_trackChange("notes");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.notes = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "notes", (Object)this.notes, (Object)string);
            return;
        }
        this.notes = string;
    }

    public Set $$_hibernate_read_members() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.members = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "members", (Object)this.members);
        }
        return this.members;
    }

    public void $$_hibernate_write_members(Set set) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.members = (Set)this.$$_hibernate_getInterceptor().writeObject((Object)this, "members", (Object)this.members, (Object)set);
            return;
        }
        this.members = set;
    }

    public String $$_hibernate_read_aliasForGroup() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.aliasForGroup = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "aliasForGroup", (Object)this.aliasForGroup);
        }
        return this.aliasForGroup;
    }

    public void $$_hibernate_write_aliasForGroup(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"aliasForGroup", (Object)string, (Object)this.aliasForGroup)) {
            this.$$_hibernate_trackChange("aliasForGroup");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.aliasForGroup = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "aliasForGroup", (Object)this.aliasForGroup, (Object)string);
            return;
        }
        this.aliasForGroup = string;
    }

    public List $$_hibernate_read_additionalProperties() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.additionalProperties = (List)this.$$_hibernate_getInterceptor().readObject((Object)this, "additionalProperties", (Object)this.additionalProperties);
        }
        return this.additionalProperties;
    }

    public void $$_hibernate_write_additionalProperties(List list) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.additionalProperties = (List)this.$$_hibernate_getInterceptor().writeObject((Object)this, "additionalProperties", (Object)this.additionalProperties, (Object)list);
            return;
        }
        this.additionalProperties = list;
    }
}

