/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.prometheus;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class PrometheusService {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Value(value="${tailormap-api.prometheus-api-url}")
    private String prometheusUrl;
    private final RestTemplate restTemplate;

    public PrometheusService(RestTemplate template) {
        this.restTemplate = template;
    }

    public boolean isPrometheusAvailable() {
        try {
            ResponseEntity response = this.restTemplate.getForEntity(this.prometheusUrl + "/query?query=up", String.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                return true;
            }
            logger.warn("Prometheus server is not available: {}", (Object)response.getStatusCode());
            return false;
        }
        catch (Exception e) {
            logger.debug("Error checking Prometheus availability", (Throwable)e);
            return false;
        }
    }

    public JsonNode executeQuery(String promQuery) throws JsonProcessingException, IOException {
        ResponseEntity response;
        URI promUrl = UriComponentsBuilder.fromUriString((String)this.prometheusUrl).path("/query").queryParam("query", new Object[]{promQuery}).build().toUri();
        logger.trace("Executing Prometheus query (GET): {}", (Object)promUrl);
        try {
            response = this.restTemplate.getForEntity(promUrl, String.class);
            if (response.getStatusCode() != HttpStatus.OK) {
                logger.error("Failed to execute Prometheus query: {}", (Object)response.getStatusCode());
                throw new IOException("Failed to execute Prometheus query: " + String.valueOf(response.getStatusCode()));
            }
        }
        catch (RestClientException e) {
            logger.error("Error executing Prometheus query: {}", (Object)e.getMessage());
            throw new IOException("Error executing Prometheus query: " + e.getMessage(), e);
        }
        JsonNode jsonResponse = new ObjectMapper().readTree((String)response.getBody());
        logger.trace("Prometheus query response: {}", (Object)jsonResponse.toPrettyString());
        if (!"success".equals(jsonResponse.path("status").asText())) {
            logger.error("Prometheus query failed: {}", (Object)jsonResponse.path("error").asText());
            throw new IOException("Prometheus query failed: " + jsonResponse.path("error").asText());
        }
        return jsonResponse;
    }

    public void deleteMetric(String ... metricMatches) throws IOException {
        URL url = new URL(this.prometheusUrl + "/admin/tsdb/delete_series?match[]=" + String.join((CharSequence)"&match[]=", metricMatches));
        logger.trace("Deleting metrics using (PUT): {}", (Object)url);
        HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
        httpURLConnection.setRequestMethod("PUT");
        if (httpURLConnection.getResponseCode() != HttpStatus.NO_CONTENT.value()) {
            throw new IOException("Failed to delete Prometheus metric: " + httpURLConnection.getResponseCode());
        }
    }

    public void cleanTombstones() throws IOException {
        URL url = new URL(this.prometheusUrl + "/admin/tsdb/clean_tombstones");
        HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
        httpURLConnection.setRequestMethod("PUT");
        if (httpURLConnection.getResponseCode() != HttpStatus.NO_CONTENT.value()) {
            throw new IOException("Failed to cleanup Prometheus tombstones: " + httpURLConnection.getResponseCode());
        }
    }
}

