package org.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.lang.Nullable;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * ServicePublishingSettings
 */
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.15.0")
public class ServicePublishingSettings implements Serializable {

  private static final long serialVersionUID = 1L;

  private String baseApp;

  private String defaultProjection;

  @Valid
  private List<String> projections = new ArrayList<>();

  public ServicePublishingSettings baseApp(String baseApp) {
    this.baseApp = baseApp;
    return this;
  }

  /**
   * Get baseApp
   * @return baseApp
   */
  
  @Schema(name = "baseApp", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("baseApp")
  public String getBaseApp() {
    return baseApp;
  }

  public void setBaseApp(String baseApp) {
    this.baseApp = baseApp;
  }

  public ServicePublishingSettings defaultProjection(String defaultProjection) {
    this.defaultProjection = defaultProjection;
    return this;
  }

  /**
   * Get defaultProjection
   * @return defaultProjection
   */
  
  @Schema(name = "defaultProjection", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("defaultProjection")
  public String getDefaultProjection() {
    return defaultProjection;
  }

  public void setDefaultProjection(String defaultProjection) {
    this.defaultProjection = defaultProjection;
  }

  public ServicePublishingSettings projections(List<String> projections) {
    this.projections = projections;
    return this;
  }

  public ServicePublishingSettings addProjectionsItem(String projectionsItem) {
    if (this.projections == null) {
      this.projections = new ArrayList<>();
    }
    this.projections.add(projectionsItem);
    return this;
  }

  /**
   * Get projections
   * @return projections
   */
  
  @Schema(name = "projections", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("projections")
  public List<String> getProjections() {
    return projections;
  }

  public void setProjections(List<String> projections) {
    this.projections = projections;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ServicePublishingSettings servicePublishingSettings = (ServicePublishingSettings) o;
    return Objects.equals(this.baseApp, servicePublishingSettings.baseApp) &&
        Objects.equals(this.defaultProjection, servicePublishingSettings.defaultProjection) &&
        Objects.equals(this.projections, servicePublishingSettings.projections);
  }

  @Override
  public int hashCode() {
    return Objects.hash(baseApp, defaultProjection, projections);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ServicePublishingSettings {\n");
    sb.append("    baseApp: ").append(toIndentedString(baseApp)).append("\n");
    sb.append("    defaultProjection: ").append(toIndentedString(defaultProjection)).append("\n");
    sb.append("    projections: ").append(toIndentedString(projections)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

