package org.tailormap.api.persistence.json;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import org.springframework.lang.Nullable;
import org.tailormap.api.persistence.json.TMServiceCapabilitiesRequest;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * TMServiceCapsCapabilities
 */
@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown = true)

@JsonTypeName("TMServiceCaps_capabilities")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.15.0")
public class TMServiceCapsCapabilities implements Serializable {

  private static final long serialVersionUID = 1L;

  private String version;

  private String updateSequence;

  private String abstractText;

  private TMServiceCapabilitiesRequest request;

  public TMServiceCapsCapabilities version(String version) {
    this.version = version;
    return this;
  }

  /**
   * Get version
   * @return version
   */
  
  @Schema(name = "version", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("version")
  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }

  public TMServiceCapsCapabilities updateSequence(String updateSequence) {
    this.updateSequence = updateSequence;
    return this;
  }

  /**
   * Get updateSequence
   * @return updateSequence
   */
  
  @Schema(name = "updateSequence", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("updateSequence")
  public String getUpdateSequence() {
    return updateSequence;
  }

  public void setUpdateSequence(String updateSequence) {
    this.updateSequence = updateSequence;
  }

  public TMServiceCapsCapabilities abstractText(String abstractText) {
    this.abstractText = abstractText;
    return this;
  }

  /**
   * Get abstractText
   * @return abstractText
   */
  
  @Schema(name = "abstractText", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("abstractText")
  public String getAbstractText() {
    return abstractText;
  }

  public void setAbstractText(String abstractText) {
    this.abstractText = abstractText;
  }

  public TMServiceCapsCapabilities request(TMServiceCapabilitiesRequest request) {
    this.request = request;
    return this;
  }

  /**
   * Get request
   * @return request
   */
  @Valid 
  @Schema(name = "request", requiredMode = Schema.RequiredMode.NOT_REQUIRED)
  @JsonProperty("request")
  public TMServiceCapabilitiesRequest getRequest() {
    return request;
  }

  public void setRequest(TMServiceCapabilitiesRequest request) {
    this.request = request;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TMServiceCapsCapabilities tmServiceCapsCapabilities = (TMServiceCapsCapabilities) o;
    return Objects.equals(this.version, tmServiceCapsCapabilities.version) &&
        Objects.equals(this.updateSequence, tmServiceCapsCapabilities.updateSequence) &&
        Objects.equals(this.abstractText, tmServiceCapsCapabilities.abstractText) &&
        Objects.equals(this.request, tmServiceCapsCapabilities.request);
  }

  @Override
  public int hashCode() {
    return Objects.hash(version, updateSequence, abstractText, request);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TMServiceCapsCapabilities {\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    updateSequence: ").append(toIndentedString(updateSequence)).append("\n");
    sb.append("    abstractText: ").append(toIndentedString(abstractText)).append("\n");
    sb.append("    request: ").append(toIndentedString(request)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

