package org.tailormap.api.viewer.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import org.springframework.lang.Nullable;
import org.tailormap.api.persistence.json.GeoServiceProtocol;
import java.io.Serializable;
import java.time.OffsetDateTime;
import jakarta.validation.Valid;
import jakarta.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import jakarta.annotation.Generated;

/**
 * A service provides one or more layers used in a viewer
 */

@Schema(name = "Service", description = "A service provides one or more layers used in a viewer")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", comments = "Generator version: 7.15.0")
public class Service implements Serializable {

  private static final long serialVersionUID = 1L;

  private String id;

  private String title;

  private String url;

  private GeoServiceProtocol protocol;

  private String capabilities = null;

  /**
   * Gets or Sets serverType
   */
  public enum ServerTypeEnum {
    GENERIC("generic"),
    
    GEOSERVER("geoserver"),
    
    MAPSERVER("mapserver");

    private final String value;

    ServerTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ServerTypeEnum fromValue(String value) {
      for (ServerTypeEnum b : ServerTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  private ServerTypeEnum serverType = ServerTypeEnum.GENERIC;

  public Service() {
    super();
  }

  public Service id(String id) {
    this.id = id;
    return this;
  }

  /**
   * Get id
   * @return id
   */
  @NotNull 
  @Schema(name = "id", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("id")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Service title(String title) {
    this.title = title;
    return this;
  }

  /**
   * Get title
   * @return title
   */
  @NotNull 
  @Schema(name = "title", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  public void setTitle(String title) {
    this.title = title;
  }

  public Service url(String url) {
    this.url = url;
    return this;
  }

  /**
   * Get url
   * @return url
   */
  @NotNull 
  @Schema(name = "url", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("url")
  public String getUrl() {
    return url;
  }

  public void setUrl(String url) {
    this.url = url;
  }

  public Service protocol(GeoServiceProtocol protocol) {
    this.protocol = protocol;
    return this;
  }

  /**
   * Get protocol
   * @return protocol
   */
  @NotNull @Valid 
  @Schema(name = "protocol", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("protocol")
  public GeoServiceProtocol getProtocol() {
    return protocol;
  }

  public void setProtocol(GeoServiceProtocol protocol) {
    this.protocol = protocol;
  }

  public Service capabilities(String capabilities) {
    this.capabilities = capabilities;
    return this;
  }

  /**
   * capabilities document of the service - currently only for WMTS
   * @return capabilities
   */
  @NotNull 
  @Schema(name = "capabilities", description = "capabilities document of the service - currently only for WMTS", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("capabilities")
  public String getCapabilities() {
    return capabilities;
  }

  public void setCapabilities(String capabilities) {
    this.capabilities = capabilities;
  }

  public Service serverType(ServerTypeEnum serverType) {
    this.serverType = serverType;
    return this;
  }

  /**
   * Get serverType
   * @return serverType
   */
  @NotNull 
  @Schema(name = "serverType", requiredMode = Schema.RequiredMode.REQUIRED)
  @JsonProperty("serverType")
  public ServerTypeEnum getServerType() {
    return serverType;
  }

  public void setServerType(ServerTypeEnum serverType) {
    this.serverType = serverType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Service service = (Service) o;
    return Objects.equals(this.id, service.id) &&
        Objects.equals(this.title, service.title) &&
        Objects.equals(this.url, service.url) &&
        Objects.equals(this.protocol, service.protocol) &&
        Objects.equals(this.capabilities, service.capabilities) &&
        Objects.equals(this.serverType, service.serverType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, title, url, protocol, capabilities, serverType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Service {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    protocol: ").append(toIndentedString(protocol)).append("\n");
    sb.append("    capabilities: ").append(toIndentedString(capabilities)).append("\n");
    sb.append("    serverType: ").append(toIndentedString(serverType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

