/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.configuration.base;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.Resource;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.i18n.AcceptHeaderLocaleResolver;
import org.springframework.web.servlet.resource.ResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolverChain;
import org.springframework.web.util.UriUtils;
import org.tailormap.api.persistence.Application;
import org.tailormap.api.repository.ApplicationRepository;
import org.tailormap.api.repository.ConfigurationRepository;

@Component
public class FrontControllerResolver
implements ResourceResolver,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ConfigurationRepository configurationRepository;
    private final ApplicationRepository applicationRepository;
    @Value(value="${spring.profiles.active:}")
    private String activeProfile;
    @Value(value="#{'${spring.web.resources.static-locations:}'.split(',')}")
    private List<String> staticResourceLocations;
    @Value(value="${tailormap-api.default-language:en}")
    private String defaultLanguage;
    private List<String> supportedLanguages = Collections.emptyList();
    private AcceptHeaderLocaleResolver localeResolver;
    private boolean staticOnly;
    private final Pattern localeBundlePrefixPattern = Pattern.compile("^[a-z]{2}/.*");

    public FrontControllerResolver(@Lazy ConfigurationRepository configurationRepository, @Lazy ApplicationRepository applicationRepository) {
        this.configurationRepository = configurationRepository;
        this.applicationRepository = applicationRepository;
    }

    public void afterPropertiesSet() {
        this.staticOnly = this.activeProfile.contains("static-only");
        this.localeResolver = new AcceptHeaderLocaleResolver();
        try {
            for (String resourceLocation : this.staticResourceLocations) {
                File[] languageBundleDirs;
                Path resourcePath = resourceLocation.startsWith("file:") ? Path.of(Strings.CS.removeStart(resourceLocation, (CharSequence)"file:"), new String[0]) : null;
                if (resourcePath == null || !resourcePath.resolve("version.json").toFile().exists()) continue;
                if (!resourcePath.resolve("index.html").toFile().exists() && (languageBundleDirs = resourcePath.toFile().listFiles((file, name) -> name.matches("^[a-z]{2}$"))) != null && languageBundleDirs.length > 0) {
                    this.supportedLanguages = Arrays.stream(languageBundleDirs).map(File::getName).toList();
                    logger.info("Detected frontend bundles for languages: {}", (Object)this.supportedLanguages);
                }
                break;
            }
        }
        catch (Exception e) {
            logger.error("Error while trying to determine frontend languages bundles", (Throwable)e);
        }
        if (!this.supportedLanguages.isEmpty()) {
            this.localeResolver.setSupportedLocales(this.supportedLanguages.stream().map(Locale::new).toList());
            Locale defaultLocale = this.supportedLanguages.contains(this.defaultLanguage) ? new Locale(this.defaultLanguage) : (Locale)this.localeResolver.getSupportedLocales().get(0);
            this.localeResolver.setDefaultLocale(defaultLocale);
            logger.info("Default language set to: {}", (Object)defaultLocale.toLanguageTag());
        }
    }

    public Resource resolveResource(HttpServletRequest request, @NonNull String requestPath, @NonNull List<? extends Resource> locations, ResourceResolverChain chain) {
        Locale locale;
        Resource resource = chain.resolveResource(request, requestPath, locations);
        if (resource != null) {
            return resource;
        }
        String localePrefix = StringUtils.left((String)requestPath, (int)2);
        if (this.localeBundlePrefixPattern.matcher(requestPath).matches() && this.supportedLanguages.contains(localePrefix) || this.supportedLanguages.contains(requestPath)) {
            return chain.resolveResource(request, localePrefix + "/index.html", locations);
        }
        if (!this.staticOnly) {
            String appLanguage;
            String[] parts;
            Application app = null;
            if ("index.html".equals(requestPath) || requestPath.matches("^app/?")) {
                String defaultAppName = this.configurationRepository.get("default-app");
                app = this.applicationRepository.findByName(defaultAppName);
            } else if (requestPath.startsWith("app/") && (parts = requestPath.split("/", -1)).length > 1) {
                String appName = UriUtils.decode((String)parts[1], (Charset)StandardCharsets.UTF_8);
                app = this.applicationRepository.findByName(appName);
            }
            if (app != null && app.getSettings().getI18nSettings() != null && (appLanguage = app.getSettings().getI18nSettings().getDefaultLanguage()) != null && (resource = chain.resolveResource(request, appLanguage + "/index.html", locations)) != null) {
                return resource;
            }
        }
        if ((resource = chain.resolveResource(request, (locale = this.localeResolver.resolveLocale(request)).toLanguageTag() + "/index.html", locations)) == null) {
            resource = chain.resolveResource(request, "/index.html", locations);
        }
        return resource;
    }

    public String resolveUrlPath(@NonNull String resourcePath, @NonNull List<? extends Resource> locations, ResourceResolverChain chain) {
        return chain.resolveUrlPath(resourcePath, locations);
    }
}

