/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.configuration.base;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.resource.ResourceTransformer;
import org.springframework.web.servlet.resource.ResourceTransformerChain;
import org.springframework.web.servlet.resource.TransformedResource;

@Component
public class IndexHtmlTransformer
implements ResourceTransformer {
    @Value(value="${tailormap-api.sentry.dsn:#{null}}")
    private String sentryDsn;

    @NonNull
    public Resource transform(@NonNull HttpServletRequest request, @NonNull Resource resource, @NonNull ResourceTransformerChain transformerChain) throws IOException {
        resource = transformerChain.transform(request, resource);
        if (this.sentryDsn == null || !"index.html".equals(resource.getFilename())) {
            return resource;
        }
        String html = resource.getContentAsString(StandardCharsets.UTF_8);
        html = html.replace("@SENTRY_DSN@", this.sentryDsn);
        return new TransformedResource(resource, html.getBytes(StandardCharsets.UTF_8));
    }
}

