/*
 * Decompiled with CFR 0.152.
 */
package org.tailormap.api.controller.admin;

import jakarta.servlet.http.HttpServletResponse;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.data.rest.core.event.BeforeSaveEvent;
import org.springframework.data.rest.webmvc.support.RepositoryEntityLinks;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import org.tailormap.api.persistence.TMFeatureSource;
import org.tailormap.api.repository.FeatureSourceRepository;

@RestController
public class FeatureSourceAdminController {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final FeatureSourceRepository featureSourceRepository;
    private final ApplicationContext applicationContext;
    private final RepositoryEntityLinks repositoryEntityLinks;

    public FeatureSourceAdminController(FeatureSourceRepository featureSourceRepository, ApplicationContext applicationContext, RepositoryEntityLinks repositoryEntityLinks) {
        this.featureSourceRepository = featureSourceRepository;
        this.applicationContext = applicationContext;
        this.repositoryEntityLinks = repositoryEntityLinks;
    }

    @PostMapping(path={"${tailormap-api.admin.base-path}/feature-sources/{id}/refresh-capabilities"})
    @Transactional
    public ResponseEntity<?> refreshCapabilities(@PathVariable Long id, HttpServletResponse httpServletResponse) throws Exception {
        TMFeatureSource featureSource = (TMFeatureSource)this.featureSourceRepository.findById(id).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND));
        logger.info("Loading capabilities for feature source {}", (Object)featureSource);
        featureSource.setRefreshCapabilities(true);
        this.applicationContext.publishEvent((ApplicationEvent)new BeforeSaveEvent((Object)featureSource));
        httpServletResponse.sendRedirect(String.valueOf(this.repositoryEntityLinks.linkToItemResource(TMFeatureSource.class, (Object)id).toUri()));
        return null;
    }
}

